/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Reference;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseItem;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommunityViewer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(CommunityViewer.class);
    private static final Message T_dspace_home = CommunityViewer.message((String)"xmlui.general.dspace_home");
    private static final Message T_full_text_search = CommunityViewer.message((String)"xmlui.ArtifactBrowser.CommunityViewer.full_text_search");
    private static final Message T_go = CommunityViewer.message((String)"xmlui.general.go");
    public static final Message T_untitled = CommunityViewer.message((String)"xmlui.general.untitled");
    private static final Message T_head_browse = CommunityViewer.message((String)"xmlui.ArtifactBrowser.CommunityViewer.head_browse");
    private static final Message T_browse_titles = CommunityViewer.message((String)"xmlui.ArtifactBrowser.CommunityViewer.browse_titles");
    private static final Message T_browse_authors = CommunityViewer.message((String)"xmlui.ArtifactBrowser.CommunityViewer.browse_authors");
    private static final Message T_browse_dates = CommunityViewer.message((String)"xmlui.ArtifactBrowser.CommunityViewer.browse_dates");
    private static final Message T_advanced_search_link = CommunityViewer.message((String)"xmlui.ArtifactBrowser.CommunityViewer.advanced_search_link");
    private static final Message T_head_sub_communities = CommunityViewer.message((String)"xmlui.ArtifactBrowser.CommunityViewer.head_sub_communities");
    private static final Message T_head_sub_collections = CommunityViewer.message((String)"xmlui.ArtifactBrowser.CommunityViewer.head_sub_collections");
    private static final Message T_head_recent_submissions = CommunityViewer.message((String)"xmlui.ArtifactBrowser.CommunityViewer.head_recent_submissions");
    private static final int RECENT_SUBMISSIONS = 5;
    private List<BrowseItem> recentSubmittedItems;
    private SourceValidity validity;

    public Serializable getKey() {
        try {
            DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
            if (dso == null) {
                return "0";
            }
            return Long.valueOf(HashUtil.hash((String)dso.getHandle()));
        }
        catch (SQLException sqle) {
            return "0";
        }
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            Community community = null;
            try {
                DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
                if (dso == null) {
                    return null;
                }
                if (!(dso instanceof Community)) {
                    return null;
                }
                community = (Community)dso;
                DSpaceValidity validity = new DSpaceValidity();
                validity.add((DSpaceObject)community);
                Community[] subCommunities = community.getSubcommunities();
                Collection[] collections = community.getCollections();
                for (Community community2 : subCommunities) {
                    validity.add((DSpaceObject)community2);
                }
                for (Community community3 : collections) {
                    validity.add((DSpaceObject)community3);
                }
                for (BrowseItem item : this.getRecentlySubmittedIems(community)) {
                    validity.add((DSpaceObject)item);
                }
                this.validity = validity.complete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.validity;
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (!(dso instanceof Community)) {
            return;
        }
        Community community = (Community)dso;
        String name = community.getMetadata("name");
        if (name == null || name.length() == 0) {
            pageMeta.addMetadata("title").addContent(T_untitled);
        } else {
            pageMeta.addMetadata("title").addContent(name);
        }
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        HandleUtil.buildHandleTrail((DSpaceObject)community, pageMeta, this.contextPath);
        String formats = ConfigurationManager.getProperty((String)"webui.feed.formats");
        if (formats != null) {
            for (String format : formats.split(",")) {
                String[] parts = format.split("_");
                if (parts.length < 1) continue;
                String feedFormat = parts[0].trim() + "+xml";
                String feedURL = this.contextPath + "/feed/" + format.trim() + "/" + community.getHandle();
                pageMeta.addMetadata("feed", feedFormat).addContent(feedURL);
            }
        }
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        ReferenceSet communityReferenceSet;
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (!(dso instanceof Community)) {
            return;
        }
        Community community = (Community)dso;
        Community[] subCommunities = community.getSubcommunities();
        Collection[] collections = community.getCollections();
        Division home = body.addDivision("community-home", "primary repository community");
        String name = community.getMetadata("name");
        if (name == null || name.length() == 0) {
            home.setHead(T_untitled);
        } else {
            home.setHead(name);
        }
        Division search = home.addDivision("community-search-browse", "secondary search-browse");
        Division query = search.addInteractiveDivision("community-search", this.contextPath + "/handle/" + community.getHandle() + "/search", "post", "secondary search");
        Para para = query.addPara("search-query", null);
        para.addContent(T_full_text_search);
        para.addContent(" ");
        para.addText("query");
        para.addContent(" ");
        para.addButton("submit").setValue(T_go);
        query.addPara().addXref(this.contextPath + "/handle/" + community.getHandle() + "/advanced-search", T_advanced_search_link);
        Division browseDiv = search.addDivision("community-browse", "secondary browse");
        org.dspace.app.xmlui.wing.element.List browse = browseDiv.addList("community-browse", "simple", "community-browse");
        browse.setHead(T_head_browse);
        String url = this.contextPath + "/handle/" + community.getHandle();
        try {
            BrowseIndex[] bis;
            for (BrowseIndex bix : bis = BrowseIndex.getBrowseIndices()) {
                HashMap<String, String> queryParams = new HashMap<String, String>();
                queryParams.put("type", bix.getName());
                browse.addItemXref(AbstractDSpaceTransformer.generateURL(url + "/browse", queryParams), CommunityViewer.message((String)("xmlui.ArtifactBrowser.Navigation.browse_" + bix.getName())));
            }
        }
        catch (BrowseException bex) {
            browse.addItemXref(url + "/browse?type=title", T_browse_titles);
            browse.addItemXref(url + "/browse?type=author", T_browse_authors);
            browse.addItemXref(url + "/browse?type=dateissued", T_browse_dates);
        }
        Division viewer = home.addDivision("community-view", "secondary");
        ReferenceSet referenceSet = viewer.addReferenceSet("community-view", "detailView");
        Reference communityInclude = referenceSet.addReference((Object)community);
        if (subCommunities != null && subCommunities.length > 0) {
            communityReferenceSet = communityInclude.addReferenceSet("summaryList", null, "hierarchy");
            communityReferenceSet.setHead(T_head_sub_communities);
            for (Community community2 : subCommunities) {
                communityReferenceSet.addReference((Object)community2);
            }
        }
        if (collections != null && collections.length > 0) {
            communityReferenceSet = communityInclude.addReferenceSet("summaryList", null, "hierarchy");
            communityReferenceSet.setHead(T_head_sub_collections);
            for (Community community3 : collections) {
                communityReferenceSet.addReference((Object)community3);
            }
        }
        List<BrowseItem> items = this.getRecentlySubmittedIems(community);
        Division lastSubmittedDiv = home.addDivision("community-recent-submission", "secondary recent-submission");
        lastSubmittedDiv.setHead(T_head_recent_submissions);
        ReferenceSet lastSubmitted = lastSubmittedDiv.addReferenceSet("collection-last-submitted", "summaryList", null, "recent-submissions");
        for (BrowseItem item : items) {
            lastSubmitted.addReference((Object)item);
        }
    }

    private List<BrowseItem> getRecentlySubmittedIems(Community community) throws SQLException {
        if (this.recentSubmittedItems != null) {
            return this.recentSubmittedItems;
        }
        String source = ConfigurationManager.getProperty((String)"recent.submissions.sort-option");
        int numRecentSubmissions = ConfigurationManager.getIntProperty((String)"recent.submissions.count", (int)5);
        BrowserScope scope = new BrowserScope(this.context);
        scope.setCommunity(community);
        scope.setResultsPerPage(numRecentSubmissions);
        try {
            scope.setBrowseIndex(BrowseIndex.getItemBrowseIndex());
            for (SortOption so : SortOption.getSortOptions()) {
                if (!so.getName().equals(source)) continue;
                scope.setSortBy(so.getNumber());
                scope.setOrder("DESC");
            }
            BrowseEngine be = new BrowseEngine(this.context);
            this.recentSubmittedItems = be.browse(scope).getResults();
        }
        catch (SortException se) {
            log.error((Object)"Caught SortException", (Throwable)se);
        }
        catch (BrowseException bex) {
            log.error((Object)"Caught BrowseException", (Throwable)bex);
        }
        return this.recentSubmittedItems;
    }

    @Override
    public void recycle() {
        this.recentSubmittedItems = null;
        this.validity = null;
        super.recycle();
    }
}

