/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Options;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.UserMeta;
import org.dspace.authorize.AuthorizeException;
import org.xml.sax.SAXException;

public class StepTransformer
extends AbstractDSpaceTransformer {
    private static Logger log = Logger.getLogger(StepTransformer.class);
    protected String id;
    private double stepAndPage;
    private String transformerClassName;
    protected String collectionHandle;
    private AbstractSubmissionStep step;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.id = parameters.getParameter("id", null);
        this.transformerClassName = parameters.getParameter("transformer", null);
        this.stepAndPage = Double.valueOf(parameters.getParameter("step", "-1"));
        this.collectionHandle = parameters.getParameter("handle", null);
        try {
            ClassLoader loader = this.getClass().getClassLoader();
            Class<?> stepClass = loader.loadClass(this.transformerClassName);
            this.step = (AbstractSubmissionStep)stepClass.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new ProcessingException("Class Not Found: " + this.transformerClassName, (Throwable)cnfe);
        }
        catch (Exception e) {
            throw new ProcessingException("Unable to instantiate class " + this.transformerClassName + ". " + "Please make sure it extends org.dspace.app.xmlui.submission.AbstractSubmissionStep!", (Throwable)e);
        }
        if (this.step == null) {
            throw new ProcessingException("Step class is null!  We do not have a valid AbstractStep in " + this.transformerClassName + ". ");
        }
        this.step.setup(resolver, objectModel, src, parameters);
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        this.step.addBody(body);
    }

    public void addOptions(Options options) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        this.step.addOptions(options);
    }

    public void addUserMeta(UserMeta userMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        this.step.addUserMeta(userMeta);
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        this.step.addPageMeta(pageMeta);
    }

    public void recycle() {
        this.id = null;
        this.transformerClassName = null;
        this.collectionHandle = null;
        this.stepAndPage = -1.0;
        if (this.step != null) {
            this.step.recycle();
            this.step = null;
        }
        super.recycle();
    }
}

