/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;
import org.dspace.app.util.DCInput;
import org.dspace.app.util.DCInputSet;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.aspect.submission.FlowUtils;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Composite;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Instance;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Radio;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DCDate;
import org.dspace.content.DCPersonName;
import org.dspace.content.DCSeriesNumber;
import org.dspace.content.DCValue;
import org.dspace.content.Item;
import org.dspace.content.authority.Choice;
import org.dspace.content.authority.ChoiceAuthorityManager;
import org.dspace.content.authority.Choices;
import org.dspace.content.authority.MetadataAuthorityManager;
import org.xml.sax.SAXException;

public class DescribeStep
extends AbstractSubmissionStep {
    private static Logger log = Logger.getLogger(DescribeStep.class);
    protected static final Message T_head = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.head");
    protected static final Message T_unknown_field = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.unknown_field");
    protected static final Message T_required_field = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.required_field");
    protected static final Message T_last_name_help = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.last_name_help");
    protected static final Message T_first_name_help = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.first_name_help");
    protected static final Message T_year = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.year");
    protected static final Message T_month = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.month");
    protected static final Message T_day = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.day");
    protected static final Message T_series_name = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.series_name");
    protected static final Message T_report_no = DescribeStep.message((String)"xmlui.Submission.submit.DescribeStep.report_no");
    private static DCInputsReader INPUTS_READER = null;
    private static final String HINT_HTML_PREFIX = "<tr><td colspan=\"4\" class=\"submitFormHelp\">";
    private static final String HINT_HTML_POSTFIX = "</td></tr>";

    private static void initializeInputsReader() throws DCInputsReaderException {
        if (INPUTS_READER == null) {
            INPUTS_READER = new DCInputsReader();
        }
    }

    private static DCInputsReader getInputsReader() {
        return INPUTS_READER;
    }

    public DescribeStep() throws ServletException {
        this.requireSubmission = true;
        this.requireStep = true;
        try {
            DescribeStep.initializeInputsReader();
        }
        catch (DCInputsReaderException e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        int collectionID = this.submission.getCollection().getID();
        pageMeta.addMetadata("choice", "collection").addContent(String.valueOf(collectionID));
        String jumpTo = this.submissionInfo.getJumpToField();
        if (jumpTo != null) {
            pageMeta.addMetadata("page", "jumpTo").addContent(jumpTo);
        }
    }

    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Item item = this.submission.getItem();
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        DCInputSet inputSet = null;
        DCInput[] inputs = new DCInput[]{};
        try {
            inputSet = DescribeStep.getInputsReader().getInputs(this.submission.getCollection().getHandle());
            inputs = inputSet.getPageRows(this.getPage() - 1, this.submission.hasMultipleTitles(), this.submission.isPublishedBefore());
        }
        catch (DCInputsReaderException se) {
            throw new UIException(se);
        }
        Division div = body.addInteractiveDivision("submit-describe", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        org.dspace.app.xmlui.wing.element.List form = div.addList("submit-describe", "form");
        form.setHead(T_head);
        for (DCInput dcInput : inputs) {
            String scope = this.submissionInfo.isInWorkflow() ? DCInput.WORKFLOW_SCOPE : DCInput.SUBMISSION_SCOPE;
            boolean readonly = dcInput.isReadOnly(scope);
            if (!dcInput.isVisible(scope) && !readonly) continue;
            String schema = dcInput.getSchema();
            String element = dcInput.getElement();
            String qualifier = dcInput.getQualifier();
            DCValue[] dcValues = item.getMetadata(schema, element, qualifier, "*");
            String fieldName = FlowUtils.getFieldName(dcInput);
            String inputType = dcInput.getInputType();
            String fieldKey = MetadataAuthorityManager.makeFieldKey((String)schema, (String)element, (String)qualifier);
            ChoiceAuthorityManager cmgr = ChoiceAuthorityManager.getManager();
            if (cmgr.isChoicesConfigured(fieldKey) && "select".equals(cmgr.getPresentation(fieldKey))) {
                this.renderChoiceSelectField(form, fieldName, collection, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("name")) {
                this.renderNameField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("date")) {
                this.renderDateField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("series")) {
                this.renderSeriesField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("twobox")) {
                this.renderOneboxField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("qualdrop_value")) {
                DCValue[] unfiltered = item.getMetadata(dcInput.getSchema(), dcInput.getElement(), "*", "*");
                ArrayList<DCValue> filtered = new ArrayList<DCValue>();
                for (DCValue dcValue : unfiltered) {
                    String unfilteredFieldName = dcValue.element + "." + dcValue.qualifier;
                    if (inputSet.isFieldPresent(unfilteredFieldName)) continue;
                    filtered.add(dcValue);
                }
                this.renderQualdropField(form, fieldName, dcInput, filtered.toArray(new DCValue[filtered.size()]), readonly);
                continue;
            }
            if (inputType.equals("textarea")) {
                this.renderTextArea(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("dropdown")) {
                this.renderDropdownField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("list")) {
                this.renderSelectFromListField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            if (inputType.equals("onebox")) {
                this.renderOneboxField(form, fieldName, dcInput, dcValues, readonly);
                continue;
            }
            form.addItem(T_unknown_field);
        }
        this.addControlButtons(form);
    }

    public org.dspace.app.xmlui.wing.element.List addReviewSection(org.dspace.app.xmlui.wing.element.List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        DCInput[] inputs;
        org.dspace.app.xmlui.wing.element.List describeSection = reviewList.addList("submit-review-" + this.stepAndPage, "form");
        describeSection.setHead(T_head);
        DCInputSet inputSet = null;
        try {
            inputSet = DescribeStep.getInputsReader().getInputs(this.submission.getCollection().getHandle());
        }
        catch (DCInputsReaderException se) {
            throw new UIException(se);
        }
        MetadataAuthorityManager mam = MetadataAuthorityManager.getManager();
        for (DCInput input : inputs = inputSet.getPageRows(this.getPage() - 1, this.submission.hasMultipleTitles(), this.submission.isPublishedBefore())) {
            String scope;
            String string = scope = this.submissionInfo.isInWorkflow() ? DCInput.WORKFLOW_SCOPE : DCInput.SUBMISSION_SCOPE;
            if (!input.isVisible(scope) && !input.isReadOnly(scope)) continue;
            String inputType = input.getInputType();
            String pairsName = input.getPairsType();
            DCValue[] values = new DCValue[]{};
            values = inputType.equals("qualdrop_value") ? this.submission.getItem().getMetadata(input.getSchema(), input.getElement(), "*", "*") : this.submission.getItem().getMetadata(input.getSchema(), input.getElement(), input.getQualifier(), "*");
            if (values.length <= 0) continue;
            for (DCValue value : values) {
                String displayValue = null;
                if (inputType.equals("date")) {
                    DCDate date = new DCDate(value.value);
                    displayValue = date.toString();
                } else if (inputType.equals("dropdown")) {
                    displayValue = input.getDisplayString(pairsName, value.value);
                } else if (inputType.equals("qualdrop_value")) {
                    String qualifier = value.qualifier;
                    String displayQual = input.getDisplayString(pairsName, qualifier);
                    if (displayQual != null && displayQual.length() > 0) {
                        displayValue = displayQual + ":" + value.value;
                    }
                } else {
                    displayValue = value.value;
                }
                if (displayValue == null || displayValue.length() <= 0) continue;
                describeSection.addLabel(input.getLabel());
                if (mam.isAuthorityControlled(value.schema, value.element, value.qualifier)) {
                    String confidence = value.authority != null && value.authority.length() > 0 ? Choices.getConfidenceText((int)value.confidence).toLowerCase() : "blank";
                    org.dspace.app.xmlui.wing.element.Item authItem = describeSection.addItem("submit-review-field-with-authority", "ds-authority-confidence cf-" + confidence);
                    authItem.addContent(displayValue);
                    continue;
                }
                describeSection.addItem(displayValue);
            }
        }
        return describeSection;
    }

    private void renderNameField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, DCValue[] dcValues, boolean readonly) throws WingException {
        Composite fullName = form.addItem().addComposite(fieldName, "submit-name");
        Text lastName = fullName.addText(fieldName + "_last");
        Text firstName = fullName.addText(fieldName + "_first");
        fullName.setLabel(dcInput.getLabel());
        fullName.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            fullName.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                fullName.addError(dcInput.getWarning());
            } else {
                fullName.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() && !readonly) {
            fullName.enableAddOperation();
        }
        if ((dcInput.isRepeatable() || dcValues.length > 1) && !readonly) {
            fullName.enableDeleteOperation();
        }
        String fieldKey = MetadataAuthorityManager.makeFieldKey((String)dcInput.getSchema(), (String)dcInput.getElement(), (String)dcInput.getQualifier());
        boolean isAuthorityControlled = MetadataAuthorityManager.getManager().isAuthorityControlled(fieldKey);
        if (isAuthorityControlled) {
            fullName.setAuthorityControlled();
            fullName.setAuthorityRequired(MetadataAuthorityManager.getManager().isAuthorityRequired(fieldKey));
        }
        if (ChoiceAuthorityManager.getManager().isChoicesConfigured(fieldKey)) {
            fullName.setChoices(fieldKey);
            fullName.setChoicesPresentation(ChoiceAuthorityManager.getManager().getPresentation(fieldKey));
            fullName.setChoicesClosed(ChoiceAuthorityManager.getManager().isClosed(fieldKey));
        }
        lastName.setLabel(T_last_name_help);
        firstName.setLabel(T_first_name_help);
        if (readonly) {
            lastName.setDisabled();
            firstName.setDisabled();
            fullName.setDisabled();
        }
        if (dcInput.isRepeatable() || dcValues.length > 1) {
            for (DCValue dcValue : dcValues) {
                DCPersonName dpn = new DCPersonName(dcValue.value);
                lastName.addInstance().setValue(dpn.getLastName());
                firstName.addInstance().setValue(dpn.getFirstNames());
                Instance fi = fullName.addInstance();
                fi.setValue(dcValue.value);
                if (!isAuthorityControlled) continue;
                if (dcValue.authority == null || dcValue.authority.equals("")) {
                    fi.setAuthorityValue("", "blank");
                    continue;
                }
                fi.setAuthorityValue(dcValue.authority, Choices.getConfidenceText((int)dcValue.confidence));
            }
        } else if (dcValues.length == 1) {
            DCPersonName dpn = new DCPersonName(dcValues[0].value);
            lastName.setValue(dpn.getLastName());
            firstName.setValue(dpn.getFirstNames());
            if (isAuthorityControlled) {
                if (dcValues[0].authority == null || dcValues[0].authority.equals("")) {
                    lastName.setAuthorityValue("", "blank");
                } else {
                    lastName.setAuthorityValue(dcValues[0].authority, Choices.getConfidenceText((int)dcValues[0].confidence));
                }
            }
        }
    }

    private void renderDateField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, DCValue[] dcValues, boolean readonly) throws WingException {
        Composite fullDate = form.addItem().addComposite(fieldName, "submit-date");
        Text year = fullDate.addText(fieldName + "_year");
        Select month = fullDate.addSelect(fieldName + "_month");
        Text day = fullDate.addText(fieldName + "_day");
        fullDate.setLabel(dcInput.getLabel());
        fullDate.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            fullDate.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                fullDate.addError(dcInput.getWarning());
            } else {
                fullDate.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() && !readonly) {
            fullDate.enableAddOperation();
        }
        if ((dcInput.isRepeatable() || dcValues.length > 1) && !readonly) {
            fullDate.enableDeleteOperation();
        }
        if (readonly) {
            year.setDisabled();
            month.setDisabled();
            day.setDisabled();
        }
        year.setLabel(T_year);
        year.setSize(4, 4);
        month.setLabel(T_month);
        month.addOption(0, "");
        for (int i = 1; i < 13; ++i) {
            month.addOption(i, DCDate.getMonthName((int)i, (Locale)Locale.getDefault()));
        }
        day.setLabel(T_day);
        day.setSize(2, 2);
        if (dcInput.isRepeatable() || dcValues.length > 1) {
            for (DCValue dcValue : dcValues) {
                DCDate dcDate = new DCDate(dcValue.value);
                year.addInstance().setValue(String.valueOf(dcDate.getYear()));
                month.addInstance().setOptionSelected(dcDate.getMonth());
                day.addInstance().setValue(String.valueOf(dcDate.getDay()));
                fullDate.addInstance().setValue(dcDate.toString());
            }
        } else if (dcValues.length == 1) {
            DCDate dcDate = new DCDate(dcValues[0].value);
            year.setValue(String.valueOf(dcDate.getYear()));
            month.setOptionSelected(dcDate.getMonth());
            if (dcDate.getDay() == -1) {
                day.setValue("");
            } else {
                day.setValue(String.valueOf(dcDate.getDay()));
            }
        }
    }

    private void renderSeriesField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, DCValue[] dcValues, boolean readonly) throws WingException {
        Composite fullSeries = form.addItem().addComposite(fieldName, "submit-" + dcInput.getInputType());
        Text series = fullSeries.addText(fieldName + "_series");
        Text number = fullSeries.addText(fieldName + "_number");
        fullSeries.setLabel(dcInput.getLabel());
        fullSeries.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            fullSeries.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                fullSeries.addError(dcInput.getWarning());
            } else {
                fullSeries.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() && !readonly) {
            fullSeries.enableAddOperation();
        }
        if ((dcInput.isRepeatable() || dcValues.length > 1) && !readonly) {
            fullSeries.enableDeleteOperation();
        }
        series.setLabel(T_series_name);
        number.setLabel(T_report_no);
        if (readonly) {
            fullSeries.setDisabled();
            series.setDisabled();
            number.setDisabled();
        }
        if (dcInput.isRepeatable() || dcValues.length > 1) {
            for (DCValue dcValue : dcValues) {
                DCSeriesNumber dcSeriesNumber = new DCSeriesNumber(dcValue.value);
                series.addInstance().setValue(dcSeriesNumber.getSeries());
                number.addInstance().setValue(dcSeriesNumber.getNumber());
                fullSeries.addInstance().setValue(dcSeriesNumber.toString());
            }
        } else if (dcValues.length == 1) {
            DCSeriesNumber dcSeriesNumber = new DCSeriesNumber(dcValues[0].value);
            series.setValue(dcSeriesNumber.getSeries());
            number.setValue(dcSeriesNumber.getNumber());
        }
    }

    private void renderQualdropField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, DCValue[] dcValues, boolean readonly) throws WingException {
        Composite qualdrop = form.addItem().addComposite(fieldName, "submit-qualdrop");
        Select qual = qualdrop.addSelect(fieldName + "_qualifier");
        Text value = qualdrop.addText(fieldName + "_value");
        qualdrop.setLabel(dcInput.getLabel());
        qualdrop.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            qualdrop.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                qualdrop.addError(dcInput.getWarning());
            } else {
                qualdrop.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() && !readonly) {
            qualdrop.enableAddOperation();
        }
        if ((dcInput.isRepeatable() || dcValues.length > 1) && !readonly) {
            qualdrop.enableDeleteOperation();
        }
        if (readonly) {
            qualdrop.setDisabled();
            qual.setDisabled();
            value.setDisabled();
        }
        List pairs = dcInput.getPairs();
        for (int i = 0; i < pairs.size(); i += 2) {
            String display = (String)pairs.get(i);
            String returnValue = (String)pairs.get(i + 1);
            qual.addOption(returnValue, display);
        }
        if (dcInput.isRepeatable() || dcValues.length > 1) {
            for (DCValue dcValue : dcValues) {
                qual.addInstance().setOptionSelected(dcValue.qualifier);
                value.addInstance().setValue(dcValue.value);
                qualdrop.addInstance().setValue(dcValue.qualifier + ":" + dcValue.value);
            }
        } else if (dcValues.length == 1) {
            qual.setOptionSelected(dcValues[0].qualifier);
            value.setValue(dcValues[0].value);
        }
    }

    private void renderTextArea(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, DCValue[] dcValues, boolean readonly) throws WingException {
        TextArea textArea = form.addItem().addTextArea(fieldName, "submit-textarea");
        textArea.setLabel(dcInput.getLabel());
        textArea.setHelp(this.cleanHints(dcInput.getHints()));
        String fieldKey = MetadataAuthorityManager.makeFieldKey((String)dcInput.getSchema(), (String)dcInput.getElement(), (String)dcInput.getQualifier());
        boolean isAuth = MetadataAuthorityManager.getManager().isAuthorityControlled(fieldKey);
        if (isAuth) {
            textArea.setAuthorityControlled();
            textArea.setAuthorityRequired(MetadataAuthorityManager.getManager().isAuthorityRequired(fieldKey));
        }
        if (ChoiceAuthorityManager.getManager().isChoicesConfigured(fieldKey)) {
            textArea.setChoices(fieldKey);
            textArea.setChoicesPresentation(ChoiceAuthorityManager.getManager().getPresentation(fieldKey));
            textArea.setChoicesClosed(ChoiceAuthorityManager.getManager().isClosed(fieldKey));
        }
        if (dcInput.isRequired()) {
            textArea.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                textArea.addError(dcInput.getWarning());
            } else {
                textArea.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() && !readonly) {
            textArea.enableAddOperation();
        }
        if ((dcInput.isRepeatable() || dcValues.length > 1) && !readonly) {
            textArea.enableDeleteOperation();
        }
        if (readonly) {
            textArea.setDisabled();
        }
        if (dcInput.isRepeatable() || dcValues.length > 1) {
            for (DCValue dcValue : dcValues) {
                Instance ti = textArea.addInstance();
                ti.setValue(dcValue.value);
                if (!isAuth) continue;
                if (dcValue.authority == null || dcValue.authority.equals("")) {
                    ti.setAuthorityValue("", "blank");
                    continue;
                }
                ti.setAuthorityValue(dcValue.authority, Choices.getConfidenceText((int)dcValue.confidence));
            }
        } else if (dcValues.length == 1) {
            textArea.setValue(dcValues[0].value);
            if (isAuth) {
                if (dcValues[0].authority == null || dcValues[0].authority.equals("")) {
                    textArea.setAuthorityValue("", "blank");
                } else {
                    textArea.setAuthorityValue(dcValues[0].authority, Choices.getConfidenceText((int)dcValues[0].confidence));
                }
            }
        }
    }

    private void renderChoiceSelectField(org.dspace.app.xmlui.wing.element.List form, String fieldName, Collection coll, DCInput dcInput, DCValue[] dcValues, boolean readonly) throws WingException {
        String fieldKey = MetadataAuthorityManager.makeFieldKey((String)dcInput.getSchema(), (String)dcInput.getElement(), (String)dcInput.getQualifier());
        if (MetadataAuthorityManager.getManager().isAuthorityControlled(fieldKey)) {
            throw new WingException("Field " + fieldKey + " has choice presentation of type \"" + "select" + "\", it may NOT be authority-controlled.");
        }
        Select select = form.addItem().addSelect(fieldName, "submit-select");
        select.setLabel(dcInput.getLabel());
        select.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            select.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                select.addError(dcInput.getWarning());
            } else {
                select.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() || dcValues.length > 1) {
            select.setMultiple();
            select.setSize(6);
        } else {
            select.setSize(1);
        }
        if (readonly) {
            select.setDisabled();
        }
        Choices cs = ChoiceAuthorityManager.getManager().getMatches(fieldKey, "", coll.getID(), 0, 0, null);
        if (dcValues.length == 0) {
            select.addOption(true, "", "");
        }
        for (Choice choice : cs.values) {
            select.addOption(choice.value, choice.label);
        }
        for (Choice choice : dcValues) {
            select.setOptionSelected(choice.value);
        }
    }

    private void renderDropdownField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, DCValue[] dcValues, boolean readonly) throws WingException {
        Select select = form.addItem().addSelect(fieldName, "submit-select");
        select.setLabel(dcInput.getLabel());
        select.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            select.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                select.addError(dcInput.getWarning());
            } else {
                select.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() || dcValues.length > 1) {
            select.setMultiple();
            select.setSize(6);
        }
        if (readonly) {
            select.setDisabled();
        }
        List pairs = dcInput.getPairs();
        for (int i = 0; i < pairs.size(); i += 2) {
            String display = (String)pairs.get(i);
            String value = (String)pairs.get(i + 1);
            select.addOption(value, display);
        }
        for (DCValue dcValue : dcValues) {
            select.setOptionSelected(dcValue.value);
        }
    }

    private void renderSelectFromListField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, DCValue[] dcValues, boolean readonly) throws WingException {
        Object listField = null;
        listField = dcInput.isRepeatable() ? form.addItem().addCheckBox(fieldName) : form.addItem().addRadio(fieldName);
        if (readonly) {
            listField.setDisabled();
        }
        listField.setLabel(dcInput.getLabel());
        listField.setHelp(this.cleanHints(dcInput.getHints()));
        if (dcInput.isRequired()) {
            listField.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                listField.addError(dcInput.getWarning());
            } else {
                listField.addError(T_required_field);
            }
        }
        List pairs = dcInput.getPairs();
        for (int i = 0; i < pairs.size(); i += 2) {
            String display = (String)pairs.get(i);
            String value = (String)pairs.get(i + 1);
            if (listField instanceof CheckBox) {
                listField.addOption(value, display);
                continue;
            }
            if (!(listField instanceof Radio)) continue;
            ((Radio)listField).addOption(value, display);
        }
        for (DCValue dcValue : dcValues) {
            if (listField instanceof CheckBox) {
                listField.setOptionSelected(dcValue.value);
                continue;
            }
            if (!(listField instanceof Radio)) continue;
            ((Radio)listField).setOptionSelected(dcValue.value);
        }
    }

    private void renderOneboxField(org.dspace.app.xmlui.wing.element.List form, String fieldName, DCInput dcInput, DCValue[] dcValues, boolean readonly) throws WingException {
        Text text = form.addItem().addText(fieldName, "submit-text");
        text.setLabel(dcInput.getLabel());
        text.setHelp(this.cleanHints(dcInput.getHints()));
        String fieldKey = MetadataAuthorityManager.makeFieldKey((String)dcInput.getSchema(), (String)dcInput.getElement(), (String)dcInput.getQualifier());
        boolean isAuth = MetadataAuthorityManager.getManager().isAuthorityControlled(fieldKey);
        if (isAuth) {
            text.setAuthorityControlled();
            text.setAuthorityRequired(MetadataAuthorityManager.getManager().isAuthorityRequired(fieldKey));
        }
        if (ChoiceAuthorityManager.getManager().isChoicesConfigured(fieldKey)) {
            text.setChoices(fieldKey);
            text.setChoicesPresentation(ChoiceAuthorityManager.getManager().getPresentation(fieldKey));
            text.setChoicesClosed(ChoiceAuthorityManager.getManager().isClosed(fieldKey));
        }
        if (dcInput.isRequired()) {
            text.setRequired();
        }
        if (this.isFieldInError(fieldName)) {
            if (dcInput.getWarning() != null && dcInput.getWarning().length() > 0) {
                text.addError(dcInput.getWarning());
            } else {
                text.addError(T_required_field);
            }
        }
        if (dcInput.isRepeatable() && !readonly) {
            text.enableAddOperation();
        }
        if ((dcInput.isRepeatable() || dcValues.length > 1) && !readonly) {
            text.enableDeleteOperation();
        }
        if (readonly) {
            text.setDisabled();
        }
        if (dcInput.isRepeatable() || dcValues.length > 1) {
            for (DCValue dcValue : dcValues) {
                Instance ti = text.addInstance();
                ti.setValue(dcValue.value);
                if (!isAuth) continue;
                if (dcValue.authority == null || dcValue.authority.equals("")) {
                    ti.setAuthorityValue("", "blank");
                    continue;
                }
                ti.setAuthorityValue(dcValue.authority, Choices.getConfidenceText((int)dcValue.confidence));
            }
        } else if (dcValues.length == 1) {
            text.setValue(dcValues[0].value);
            if (isAuth) {
                if (dcValues[0].authority == null || dcValues[0].authority.equals("")) {
                    text.setAuthorityValue("", "blank");
                } else {
                    text.setAuthorityValue(dcValues[0].authority, Choices.getConfidenceText((int)dcValues[0].confidence));
                }
            }
        }
    }

    private boolean isFieldInError(String fieldName) {
        return this.errorFields.contains(fieldName);
    }

    private String cleanHints(String dirtyHints) {
        String clean;
        String string = clean = dirtyHints != null ? dirtyHints : "";
        if (clean.startsWith(HINT_HTML_PREFIX)) {
            clean = clean.substring(HINT_HTML_PREFIX.length());
        }
        if (clean.endsWith(HINT_HTML_POSTFIX)) {
            clean = clean.substring(0, clean.length() - HINT_HTML_POSTFIX.length());
        }
        return clean;
    }
}

