/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.generation.AbstractGenerator;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.handle.HandleManager;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.SAXOutputter;
import org.xml.sax.SAXException;

public class DSpaceOREGenerator
extends AbstractGenerator {
    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            Context context = ContextUtil.obtainContext(this.objectModel);
            Item item = this.getItem(context);
            if (item == null) {
                throw new ResourceNotFoundException("Unable to locate object.");
            }
            SAXOutputter out = new SAXOutputter(this.contentHandler);
            DisseminationCrosswalk xwalk = (DisseminationCrosswalk)PluginManager.getNamedPlugin(DisseminationCrosswalk.class, (String)"ore");
            Element ore = xwalk.disseminateElement((DSpaceObject)item);
            out.output(ore);
        }
        catch (JDOMException je) {
            throw new ProcessingException((Exception)((Object)je));
        }
        catch (AuthorizeException ae) {
            throw new ProcessingException((Exception)((Object)ae));
        }
        catch (CrosswalkException ce) {
            throw new ProcessingException((Exception)((Object)ce));
        }
        catch (SQLException sqle) {
            throw new ProcessingException((Exception)sqle);
        }
    }

    private Item getItem(Context context) throws SQLException, CrosswalkException {
        String[] parts;
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String contextPath = request.getContextPath();
        String handle = this.parameters.getParameter("handle", null);
        String internal = this.parameters.getParameter("internal", null);
        if (handle != null) {
            DSpaceObject dso = HandleManager.resolveToObject((Context)context, (String)handle);
            if (dso instanceof Item) {
                return (Item)dso;
            }
            throw new CrosswalkException("ORE dissemination only available for DSpace Items.");
        }
        if (internal != null && (parts = internal.split(":")).length == 2) {
            String type = parts[0];
            int id = Integer.valueOf(parts[1]);
            if ("item".equals(type)) {
                Item item = Item.find((Context)context, (int)id);
                return item;
            }
            throw new CrosswalkException("ORE dissemination only available for DSpace Items.");
        }
        return null;
    }
}

