/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.servlet.multipart.Part;
import org.dspace.app.xmlui.aspect.administrative.FlowCurationUtils;
import org.dspace.app.xmlui.aspect.administrative.FlowResult;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.browse.BrowseException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.curate.Curator;
import org.dspace.eperson.Group;
import org.dspace.harvest.HarvestedCollection;
import org.dspace.harvest.OAIHarvester;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXException;

public class FlowContainerUtils {
    public static final String ROLE_ADMIN = "ADMIN";
    public static final String ROLE_WF_STEP1 = "WF_STEP1";
    public static final String ROLE_WF_STEP2 = "WF_STEP2";
    public static final String ROLE_WF_STEP3 = "WF_STEP3";
    public static final String ROLE_SUBMIT = "SUBMIT";
    public static final String ROLE_DEFAULT_READ = "DEFAULT_READ";

    public static FlowResult processEditCollection(Context context, int collectionID, boolean deleteLogo, Request request) throws SQLException, IOException, AuthorizeException {
        FlowResult result = new FlowResult();
        Collection collection = Collection.find((Context)context, (int)collectionID);
        String name = request.getParameter("name");
        String shortDescription = request.getParameter("short_description");
        String introductoryText = request.getParameter("introductory_text");
        String copyrightText = request.getParameter("copyright_text");
        String sideBarText = request.getParameter("side_bar_text");
        String license = request.getParameter("license");
        String provenanceDescription = request.getParameter("provenance_description");
        if (name == null || name.length() == 0) {
            name = "Untitled";
        }
        if (shortDescription != null && shortDescription.length() == 0) {
            shortDescription = null;
        }
        if (introductoryText != null && introductoryText.length() == 0) {
            introductoryText = null;
        }
        if (copyrightText != null && copyrightText.length() == 0) {
            copyrightText = null;
        }
        if (sideBarText != null && sideBarText.length() == 0) {
            sideBarText = null;
        }
        if (license != null && license.length() == 0) {
            license = null;
        }
        if (provenanceDescription != null && provenanceDescription.length() == 0) {
            provenanceDescription = null;
        }
        collection.setMetadata("name", name);
        collection.setMetadata("short_description", shortDescription);
        collection.setMetadata("introductory_text", introductoryText);
        collection.setMetadata("copyright_text", copyrightText);
        collection.setMetadata("side_bar_text", sideBarText);
        collection.setMetadata("license", license);
        collection.setMetadata("provenance_description", provenanceDescription);
        if (deleteLogo) {
            collection.setLogo(null);
        } else {
            Object object = request.get("logo");
            Part filePart = null;
            if (object instanceof Part) {
                filePart = (Part)object;
            }
            if (filePart != null && filePart.getSize() > 0) {
                InputStream is = filePart.getInputStream();
                collection.setLogo(is);
            }
        }
        collection.update();
        context.commit();
        result.setContinue(true);
        return result;
    }

    public static FlowResult processSetupCollectionHarvesting(Context context, int collectionID, Request request) throws SQLException, IOException, AuthorizeException {
        FlowResult result = new FlowResult();
        HarvestedCollection hc = HarvestedCollection.find((Context)context, (int)collectionID);
        String contentSource = request.getParameter("source");
        if (contentSource.equals("source_normal")) {
            if (hc != null) {
                hc.delete();
            }
            result.setContinue(true);
        } else {
            FlowResult subResult = FlowContainerUtils.testOAISettings(context, request);
            if (hc == null) {
                hc = HarvestedCollection.create((Context)context, (int)collectionID);
            }
            if (!subResult.getErrors().isEmpty()) {
                result.setErrors(subResult.getErrors());
                result.setContinue(false);
                return result;
            }
            String oaiProvider = request.getParameter("oai_provider");
            boolean oaiAllSets = "all".equals(request.getParameter("oai-set-setting"));
            String oaiSetId = oaiAllSets ? "all" : request.getParameter("oai_setid");
            String metadataKey = request.getParameter("metadata_format");
            String harvestType = request.getParameter("harvest_level");
            hc.setHarvestParams(Integer.parseInt(harvestType), oaiProvider, oaiSetId, metadataKey);
            hc.setHarvestStatus(0);
            hc.update();
        }
        context.commit();
        result.setOutcome(true);
        result.setContinue(true);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FlowResult processRunCollectionHarvest(Context context, int collectionID, Request request) throws SQLException, IOException, AuthorizeException, CrosswalkException, ParserConfigurationException, SAXException, TransformerException {
        FlowResult result;
        block6: {
            result = new FlowResult();
            ArrayList<String> testErrors = new ArrayList<String>();
            Collection collection = Collection.find((Context)context, (int)collectionID);
            HarvestedCollection hc = HarvestedCollection.find((Context)context, (int)collectionID);
            try {
                if (!OAIHarvester.HarvestScheduler.hasStatus((int)4)) {
                    Object object = OAIHarvester.HarvestScheduler.lock;
                    synchronized (object) {
                        OAIHarvester.HarvestScheduler.setInterrupt((int)4, (int)collectionID);
                        OAIHarvester.HarvestScheduler.lock.notify();
                        break block6;
                    }
                }
                OAIHarvester harvester = new OAIHarvester(context, (DSpaceObject)collection, hc);
                harvester.runHarvest();
            }
            catch (Exception e) {
                testErrors.add(e.getMessage());
                result.setErrors(testErrors);
                result.setContinue(false);
                return result;
            }
        }
        result.setContinue(true);
        return result;
    }

    public static FlowResult processReimportCollection(Context context, int collectionID, Request request) throws SQLException, IOException, AuthorizeException, CrosswalkException, ParserConfigurationException, SAXException, TransformerException, BrowseException {
        Collection collection = Collection.find((Context)context, (int)collectionID);
        HarvestedCollection hc = HarvestedCollection.find((Context)context, (int)collectionID);
        ItemIterator it = collection.getAllItems();
        while (it.hasNext()) {
            Item item = it.next();
            collection.removeItem(item);
        }
        hc.setHarvestResult(null, "");
        hc.update();
        collection.update();
        context.commit();
        return FlowContainerUtils.processRunCollectionHarvest(context, collectionID, request);
    }

    public static FlowResult testOAISettings(Context context, Request request) {
        FlowResult result = new FlowResult();
        String oaiProvider = request.getParameter("oai_provider");
        String oaiSetId = request.getParameter("oai_setid");
        oaiSetId = request.getParameter("oai-set-setting");
        if (!"all".equals(oaiSetId)) {
            oaiSetId = request.getParameter("oai_setid");
        }
        String metadataKey = request.getParameter("metadata_format");
        String harvestType = request.getParameter("harvest_level");
        int harvestTypeInt = 0;
        if (oaiProvider == null || oaiProvider.length() == 0) {
            result.addError("oai_provider");
        }
        if (oaiSetId == null || oaiSetId.length() == 0) {
            result.addError("oai_setid");
        }
        if (metadataKey == null || metadataKey.length() == 0) {
            result.addError("metadata_format");
        }
        if (harvestType == null || harvestType.length() == 0) {
            result.addError("harvest_level");
        } else {
            harvestTypeInt = Integer.parseInt(harvestType);
        }
        if (result.getErrors() == null) {
            List testErrors = OAIHarvester.verifyOAIharvester((String)oaiProvider, (String)oaiSetId, (String)metadataKey, (harvestTypeInt > 1 ? 1 : 0) != 0);
            result.setErrors(testErrors);
        }
        if (result.getErrors() == null || result.getErrors().isEmpty()) {
            result.setOutcome(true);
            result.setMessage(new Message("default", "Harvesting settings are valid."));
        } else {
            result.setOutcome(false);
            result.setContinue(false);
        }
        return result;
    }

    public static int getTemplateItemID(Context context, int collectionID) throws SQLException, AuthorizeException, IOException {
        Collection collection = Collection.find((Context)context, (int)collectionID);
        Item template = collection.getTemplateItem();
        if (template == null) {
            collection.createTemplateItem();
            template = collection.getTemplateItem();
            collection.update();
            template.update();
            context.commit();
        }
        return template.getID();
    }

    public static int getCollectionRole(Context context, int collectionID, String roleName) throws SQLException, AuthorizeException, IOException {
        Collection collection = Collection.find((Context)context, (int)collectionID);
        Group role = null;
        if (ROLE_ADMIN.equals(roleName)) {
            role = collection.getAdministrators();
            if (role == null) {
                role = collection.createAdministrators();
            }
        } else if (ROLE_SUBMIT.equals(roleName)) {
            role = collection.getSubmitters();
            if (role == null) {
                role = collection.createSubmitters();
            }
        } else if (ROLE_WF_STEP1.equals(roleName)) {
            role = collection.getWorkflowGroup(1);
            if (role == null) {
                role = collection.createWorkflowGroup(1);
            }
        } else if (ROLE_WF_STEP2.equals(roleName)) {
            role = collection.getWorkflowGroup(2);
            if (role == null) {
                role = collection.createWorkflowGroup(2);
            }
        } else if (ROLE_WF_STEP3.equals(roleName) && (role = collection.getWorkflowGroup(3)) == null) {
            role = collection.createWorkflowGroup(3);
        }
        collection.update();
        context.commit();
        if (role != null) {
            return role.getID();
        }
        return -1;
    }

    public static FlowResult processDeleteCollectionRole(Context context, int collectionID, String roleName, int groupID) throws SQLException, UIException, IOException, AuthorizeException {
        FlowResult result = new FlowResult();
        Collection collection = Collection.find((Context)context, (int)collectionID);
        Group role = Group.find((Context)context, (int)groupID);
        if (ROLE_ADMIN.equals(roleName)) {
            collection.removeAdministrators();
        } else if (ROLE_SUBMIT.equals(roleName)) {
            collection.removeSubmitters();
        } else if (ROLE_WF_STEP1.equals(roleName)) {
            collection.setWorkflowGroup(1, null);
        } else if (ROLE_WF_STEP2.equals(roleName)) {
            collection.setWorkflowGroup(2, null);
        } else if (ROLE_WF_STEP3.equals(roleName)) {
            collection.setWorkflowGroup(3, null);
        }
        List policies = AuthorizeManager.getPolicies((Context)context, (DSpaceObject)collection);
        for (ResourcePolicy policy : policies) {
            if (policy.getGroupID() != groupID) continue;
            policy.delete();
        }
        collection.update();
        role.delete();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The role was successfully deleted."));
        return result;
    }

    public static int getCollectionDefaultRead(Context context, int collectionID) throws SQLException, AuthorizeException {
        Collection collection = Collection.find((Context)context, (int)collectionID);
        Group[] itemGroups = AuthorizeManager.getAuthorizedGroups((Context)context, (DSpaceObject)collection, (int)10);
        Group[] bitstreamGroups = AuthorizeManager.getAuthorizedGroups((Context)context, (DSpaceObject)collection, (int)9);
        int itemGroupID = -1;
        if (itemGroups.length == 1 && bitstreamGroups.length == 1) {
            Group itemGroup = itemGroups[0];
            Group bitstreamGroup = bitstreamGroups[0];
            if (itemGroup.getID() == bitstreamGroup.getID()) {
                itemGroupID = itemGroup.getID();
            }
        }
        return itemGroupID;
    }

    public static int createCollectionDefaultReadGroup(Context context, int collectionID) throws SQLException, AuthorizeException, UIException {
        int roleID = FlowContainerUtils.getCollectionDefaultRead(context, collectionID);
        if (roleID != 0) {
            throw new UIException("Unable to create a new default read group because either the group allready exists or multiple groups are assigned the default privleges.");
        }
        Collection collection = Collection.find((Context)context, (int)collectionID);
        Group role = Group.create((Context)context);
        role.setName("COLLECTION_" + collection.getID() + "_DEFAULT_READ");
        AuthorizeManager.removePoliciesActionFilter((Context)context, (DSpaceObject)collection, (int)10);
        AuthorizeManager.removePoliciesActionFilter((Context)context, (DSpaceObject)collection, (int)9);
        AuthorizeManager.addPolicy((Context)context, (DSpaceObject)collection, (int)10, (Group)role);
        AuthorizeManager.addPolicy((Context)context, (DSpaceObject)collection, (int)9, (Group)role);
        role.update();
        context.commit();
        return role.getID();
    }

    public static FlowResult changeCollectionDefaultReadToAnonymous(Context context, int collectionID) throws SQLException, AuthorizeException, UIException {
        FlowResult result = new FlowResult();
        int roleID = FlowContainerUtils.getCollectionDefaultRead(context, collectionID);
        if (roleID < 1) {
            throw new UIException("Unable to delete the default read role because the role is either allready assigned to the anonymous group or multiple groups are assigned the default priveleges.");
        }
        Collection collection = Collection.find((Context)context, (int)collectionID);
        Group role = Group.find((Context)context, (int)roleID);
        Group anonymous = Group.find((Context)context, (int)0);
        role.delete();
        AuthorizeManager.addPolicy((Context)context, (DSpaceObject)collection, (int)10, (Group)anonymous);
        AuthorizeManager.addPolicy((Context)context, (DSpaceObject)collection, (int)9, (Group)anonymous);
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "All new items submitted to this collection will default to anonymous read."));
        return result;
    }

    public static FlowResult processDeleteCollection(Context context, int collectionID) throws SQLException, AuthorizeException, IOException {
        Community[] parents;
        FlowResult result = new FlowResult();
        Collection collection = Collection.find((Context)context, (int)collectionID);
        for (Community parent : parents = collection.getCommunities()) {
            parent.removeCollection(collection);
            parent.update();
        }
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The collection was successfully deleted."));
        return result;
    }

    public static FlowResult processCreateCollection(Context context, int communityID, Request request) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        Community parent = Community.find((Context)context, (int)communityID);
        Collection newCollection = parent.createCollection();
        String name = request.getParameter("name");
        String shortDescription = request.getParameter("short_description");
        String introductoryText = request.getParameter("introductory_text");
        String copyrightText = request.getParameter("copyright_text");
        String sideBarText = request.getParameter("side_bar_text");
        String license = request.getParameter("license");
        String provenanceDescription = request.getParameter("provenance_description");
        if (name == null || name.length() == 0) {
            name = "Untitled";
        }
        if (shortDescription != null && shortDescription.length() == 0) {
            shortDescription = null;
        }
        if (introductoryText != null && introductoryText.length() == 0) {
            introductoryText = null;
        }
        if (copyrightText != null && copyrightText.length() == 0) {
            copyrightText = null;
        }
        if (sideBarText != null && sideBarText.length() == 0) {
            sideBarText = null;
        }
        if (license != null && license.length() == 0) {
            license = null;
        }
        if (provenanceDescription != null && provenanceDescription.length() == 0) {
            provenanceDescription = null;
        }
        newCollection.setMetadata("name", name);
        newCollection.setMetadata("short_description", shortDescription);
        newCollection.setMetadata("introductory_text", introductoryText);
        newCollection.setMetadata("copyright_text", copyrightText);
        newCollection.setMetadata("side_bar_text", sideBarText);
        newCollection.setMetadata("license", license);
        newCollection.setMetadata("provenance_description", provenanceDescription);
        Object object = request.get("logo");
        Part filePart = null;
        if (object instanceof Part) {
            filePart = (Part)object;
        }
        if (filePart != null && filePart.getSize() > 0) {
            InputStream is = filePart.getInputStream();
            newCollection.setLogo(is);
        }
        newCollection.update();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The collection was successfully created."));
        result.setParameter("collectionID", newCollection.getID());
        return result;
    }

    public static FlowResult processCreateCommunity(Context context, int communityID, Request request) throws AuthorizeException, IOException, SQLException {
        FlowResult result = new FlowResult();
        Community parent = Community.find((Context)context, (int)communityID);
        Community newCommunity = parent != null ? parent.createSubcommunity() : Community.create(null, (Context)context);
        String name = request.getParameter("name");
        String shortDescription = request.getParameter("short_description");
        String introductoryText = request.getParameter("introductory_text");
        String copyrightText = request.getParameter("copyright_text");
        String sideBarText = request.getParameter("side_bar_text");
        if (name == null || name.length() == 0) {
            name = "Untitled";
        }
        if (shortDescription != null && shortDescription.length() == 0) {
            shortDescription = null;
        }
        if (introductoryText != null && introductoryText.length() == 0) {
            introductoryText = null;
        }
        if (copyrightText != null && copyrightText.length() == 0) {
            copyrightText = null;
        }
        if (sideBarText != null && sideBarText.length() == 0) {
            sideBarText = null;
        }
        newCommunity.setMetadata("name", name);
        newCommunity.setMetadata("short_description", shortDescription);
        newCommunity.setMetadata("introductory_text", introductoryText);
        newCommunity.setMetadata("copyright_text", copyrightText);
        newCommunity.setMetadata("side_bar_text", sideBarText);
        Object object = request.get("logo");
        Part filePart = null;
        if (object instanceof Part) {
            filePart = (Part)object;
        }
        if (filePart != null && filePart.getSize() > 0) {
            InputStream is = filePart.getInputStream();
            newCommunity.setLogo(is);
        }
        newCommunity.update();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The community was successfully created."));
        result.setParameter("communityID", newCommunity.getID());
        return result;
    }

    public static FlowResult processEditCommunity(Context context, int communityID, boolean deleteLogo, Request request) throws AuthorizeException, IOException, SQLException {
        FlowResult result = new FlowResult();
        Community community = Community.find((Context)context, (int)communityID);
        String name = request.getParameter("name");
        String shortDescription = request.getParameter("short_description");
        String introductoryText = request.getParameter("introductory_text");
        String copyrightText = request.getParameter("copyright_text");
        String sideBarText = request.getParameter("side_bar_text");
        if (name == null || name.length() == 0) {
            name = "Untitled";
        }
        if (shortDescription != null && shortDescription.length() == 0) {
            shortDescription = null;
        }
        if (introductoryText != null && introductoryText.length() == 0) {
            introductoryText = null;
        }
        if (copyrightText != null && copyrightText.length() == 0) {
            copyrightText = null;
        }
        if (sideBarText != null && sideBarText.length() == 0) {
            sideBarText = null;
        }
        community.setMetadata("name", name);
        community.setMetadata("short_description", shortDescription);
        community.setMetadata("introductory_text", introductoryText);
        community.setMetadata("copyright_text", copyrightText);
        community.setMetadata("side_bar_text", sideBarText);
        if (deleteLogo) {
            community.setLogo(null);
        } else {
            Object object = request.get("logo");
            Part filePart = null;
            if (object instanceof Part) {
                filePart = (Part)object;
            }
            if (filePart != null && filePart.getSize() > 0) {
                InputStream is = filePart.getInputStream();
                community.setLogo(is);
            }
        }
        community.update();
        context.commit();
        result.setContinue(true);
        return result;
    }

    public static FlowResult processDeleteCommunity(Context context, int communityID) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        Community community = Community.find((Context)context, (int)communityID);
        community.delete();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The community was successfully deleted."));
        return result;
    }

    public static int getCommunityRole(Context context, int communityID, String roleName) throws SQLException, AuthorizeException, IOException {
        Community community = Community.find((Context)context, (int)communityID);
        Group role = null;
        if (ROLE_ADMIN.equals(roleName) && (role = community.getAdministrators()) == null) {
            role = community.createAdministrators();
        }
        community.update();
        context.commit();
        if (role != null) {
            return role.getID();
        }
        return -1;
    }

    public static FlowResult processDeleteCommunityRole(Context context, int communityID, String roleName, int groupID) throws SQLException, UIException, IOException, AuthorizeException {
        FlowResult result = new FlowResult();
        Community community = Community.find((Context)context, (int)communityID);
        Group role = Group.find((Context)context, (int)groupID);
        if (ROLE_ADMIN.equals(roleName)) {
            community.removeAdministrators();
        }
        List policies = AuthorizeManager.getPolicies((Context)context, (DSpaceObject)community);
        for (ResourcePolicy policy : policies) {
            if (policy.getGroupID() != groupID) continue;
            policy.delete();
        }
        community.update();
        role.delete();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        result.setMessage(new Message("default", "The role was successfully deleted."));
        return result;
    }

    public static FlowResult processDeleteTemplateItem(Context context, int collectionID) throws SQLException, AuthorizeException, IOException {
        FlowResult result = new FlowResult();
        Collection collection = Collection.find((Context)context, (int)collectionID);
        collection.removeTemplateItem();
        context.commit();
        result.setContinue(true);
        result.setOutcome(true);
        return result;
    }

    public static FlowResult processCurateCollection(Context context, int dsoID, Request request) throws AuthorizeException, IOException, SQLException, Exception {
        String task = request.getParameter("curate_task");
        Curator curator = FlowCurationUtils.getCurator(task);
        Collection collection = Collection.find((Context)context, (int)dsoID);
        if (collection != null) {
            curator.curate((DSpaceObject)collection);
        }
        return FlowCurationUtils.getRunFlowResult(task, curator);
    }

    public static FlowResult processQueueCollection(Context context, int dsoID, Request request) throws AuthorizeException, IOException, SQLException, Exception {
        String task = request.getParameter("curate_task");
        Curator curator = FlowCurationUtils.getCurator(task);
        String objId = String.valueOf(dsoID);
        String taskQueueName = ConfigurationManager.getProperty((String)"curate", (String)"ui.queuename");
        boolean status = false;
        Collection collection = Collection.find((Context)context, (int)dsoID);
        if (collection != null) {
            objId = collection.getHandle();
            try {
                curator.queue(context, objId, taskQueueName);
                status = true;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return FlowCurationUtils.getQueueFlowResult(task, status, objId, taskQueueName);
    }

    public static FlowResult processCurateCommunity(Context context, int dsoID, Request request) throws AuthorizeException, IOException, SQLException, Exception {
        String task = request.getParameter("curate_task");
        Curator curator = FlowCurationUtils.getCurator(task);
        Community community = Community.find((Context)context, (int)dsoID);
        if (community != null) {
            curator.curate((DSpaceObject)community);
        }
        return FlowCurationUtils.getRunFlowResult(task, curator);
    }

    public static FlowResult processQueueCommunity(Context context, int dsoID, Request request) throws AuthorizeException, IOException, SQLException, Exception {
        String task = request.getParameter("curate_task");
        Curator curator = FlowCurationUtils.getCurator(task);
        String objId = String.valueOf(dsoID);
        String taskQueueName = ConfigurationManager.getProperty((String)"curate", (String)"ui.queuename");
        boolean status = false;
        Community community = Community.find((Context)context, (int)dsoID);
        if (community != null) {
            objId = community.getHandle();
            try {
                curator.queue(context, objId, taskQueueName);
                status = true;
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        return FlowCurationUtils.getQueueFlowResult(task, status, objId, taskQueueName);
    }

    public static String checkXMLFragment(String value) {
        value = FlowContainerUtils.escapeXMLEntities(value);
        String xml = "<?xml version='1.0' encoding='UTF-8'?><fragment>" + value + "</fragment>";
        ByteArrayInputStream inputStream = null;
        try {
            inputStream = new ByteArrayInputStream(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            inputStream = new ByteArrayInputStream(xml.getBytes());
        }
        SAXBuilder builder = new SAXBuilder();
        try {
            builder.build((InputStream)inputStream);
        }
        catch (JDOMException jdome) {
            return jdome.getMessage();
        }
        catch (IOException ioe) {
            return ioe.getMessage();
        }
        return null;
    }

    public static String escapeXMLEntities(String value) {
        if (value == null) {
            return null;
        }
        int amp = -1;
        while ((amp = value.indexOf(38, amp + 1)) > -1) {
            if (FlowContainerUtils.substringCompare(value, amp + 1, '#')) continue;
            if (FlowContainerUtils.substringCompare(value, amp + 1, 'a', 'm', 'p', ';')) continue;
            if (FlowContainerUtils.substringCompare(value, amp + 1, 'a', 'p', 'o', 's', ';')) continue;
            if (FlowContainerUtils.substringCompare(value, amp + 1, 'q', 'u', 'o', 't', ';')) continue;
            if (FlowContainerUtils.substringCompare(value, amp + 1, 'l', 't', ';')) continue;
            if (FlowContainerUtils.substringCompare(value, amp + 1, 'g', 't', ';')) continue;
            value = value.substring(0, amp) + "&amp;" + value.substring(amp + 1);
        }
        return value;
    }

    private static boolean substringCompare(String string, int index, char ... characters) {
        if (string.length() <= index + characters.length) {
            return false;
        }
        for (char character : characters) {
            if (string.charAt(index) != character) {
                return false;
            }
            ++index;
        }
        return false;
    }
}

