/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.community;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Community;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class CurateCommunityForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = CurateCommunityForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_community_trail = CurateCommunityForm.message((String)"xmlui.administrative.community.general.community_trail");
    private static final Message T_options_metadata = CurateCommunityForm.message((String)"xmlui.administrative.community.general.options_metadata");
    private static final Message T_options_roles = CurateCommunityForm.message((String)"xmlui.administrative.community.general.options_roles");
    private static final Message T_options_curate = CurateCommunityForm.message((String)"xmlui.administrative.community.general.options_curate");
    private static final Message T_submit_perform = CurateCommunityForm.message((String)"xmlui.general.perform");
    private static final Message T_submit_queue = CurateCommunityForm.message((String)"xmlui.general.queue");
    private static final Message T_submit_return = CurateCommunityForm.message((String)"xmlui.general.return");
    private static final Message T_main_head = CurateCommunityForm.message((String)"xmlui.administrative.community.CurateCommunityForm.main_head");
    private static final Message T_title = CurateCommunityForm.message((String)"xmlui.administrative.community.CurateCommunityForm.title");
    private static final Message T_trail = CurateCommunityForm.message((String)"xmlui.administrative.community.CurateCommunityForm.trail");
    private static final Message T_label_name = CurateCommunityForm.message((String)"xmlui.administrative.community.CurateCommunityForm.label_name");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_community_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException, AuthorizeException, UnsupportedEncodingException {
        int communityID = this.parameters.getParameterAsInteger("communityID", -1);
        Community thisCommunity = Community.find((Context)this.context, (int)communityID);
        String baseURL = this.contextPath + "/admin/community?administrative-continue=" + this.knot.getId();
        Division main = body.addInteractiveDivision("community-curate", this.contextPath + "/admin/community", "multipart", "primary administrative community");
        main.setHead(T_main_head.parameterize(new Object[]{thisCommunity.getName()}));
        org.dspace.app.xmlui.wing.element.List options = main.addList("options", "simple", "horizontal");
        options.addItem().addXref(baseURL + "&submit_metadata", T_options_metadata);
        options.addItem().addXref(baseURL + "&submit_roles", T_options_roles);
        options.addItem().addHighlight("bold").addXref(baseURL + "&submit_curate", T_options_curate);
        org.dspace.app.xmlui.wing.element.List curationTaskList = main.addList("curationTaskList", "form");
        curationTaskList.addLabel(T_label_name);
        Select select = curationTaskList.addItem().addSelect("curate_task");
        select = this.getCurationOptions(select);
        select.setSize(1);
        select.setRequired();
        Para buttonList = main.addPara();
        buttonList.addButton("submit_curate_task").setValue(T_submit_perform);
        buttonList.addButton("submit_queue_task").setValue(T_submit_queue);
        buttonList.addButton("submit_return").setValue(T_submit_return);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    private Select getCurationOptions(Select select) throws WingException, UnsupportedEncodingException {
        String tasksString = ConfigurationManager.getProperty((String)"curate", (String)"ui.tasknames");
        String[] tasks = tasksString.split(",");
        List<String> taskList = Arrays.asList(tasks);
        for (String task : taskList) {
            String[] keyValuePair = task.split("=");
            select.addOption(URLDecoder.decode(keyValuePair[0].trim(), "UTF-8"), URLDecoder.decode(keyValuePair[1].trim(), "UTF-8"));
        }
        return select;
    }
}

