/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.artifactbrowser.BrowseParams;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.HandleUtil;
import org.dspace.app.xmlui.utils.RequestUtils;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.BrowseEngine;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseIndex;
import org.dspace.browse.BrowseInfo;
import org.dspace.browse.BrowseItem;
import org.dspace.browse.BrowserScope;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DCDate;
import org.dspace.content.DSpaceObject;
import org.dspace.content.authority.ChoiceAuthorityManager;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;
import org.xml.sax.SAXException;

public class ConfigurableBrowse
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Logger log = Logger.getLogger(ConfigurableBrowse.class);
    private static final Message T_dspace_home = ConfigurableBrowse.message((String)"xmlui.general.dspace_home");
    private static final Message T_go = ConfigurableBrowse.message((String)"xmlui.general.go");
    private static final Message T_update = ConfigurableBrowse.message((String)"xmlui.general.update");
    private static final Message T_choose_month = ConfigurableBrowse.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.choose_month");
    private static final Message T_choose_year = ConfigurableBrowse.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.choose_year");
    private static final Message T_jump_year = ConfigurableBrowse.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.jump_year");
    private static final Message T_jump_year_help = ConfigurableBrowse.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.jump_year_help");
    private static final Message T_jump_select = ConfigurableBrowse.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.jump_select");
    private static final Message T_starts_with = ConfigurableBrowse.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.starts_with");
    private static final Message T_starts_with_help = ConfigurableBrowse.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.starts_with_help");
    private static final Message T_sort_by = ConfigurableBrowse.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.sort_by");
    private static final Message T_order = ConfigurableBrowse.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.order");
    private static final Message T_no_results = ConfigurableBrowse.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.no_results");
    private static final Message T_rpp = ConfigurableBrowse.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.general.rpp");
    private static final Message T_order_asc = ConfigurableBrowse.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.order.asc");
    private static final Message T_order_desc = ConfigurableBrowse.message((String)"xmlui.ArtifactBrowser.ConfigurableBrowse.order.desc");
    private static final String BROWSE_URL_BASE = "browse";
    private static final int ONE_YEAR_LIMIT = 10;
    private static final int FIVE_YEAR_LIMIT = 30;
    private static final int TEN_YEAR_LIMIT = 100;
    private static final int[] RESULTS_PER_PAGE_PROGRESSION = new int[]{5, 10, 20, 40, 60, 80, 100};
    private SourceValidity validity;
    private BrowseParams userParams;
    private BrowseInfo browseInfo;
    private Message titleMessage = null;
    private Message trailMessage = null;

    public Serializable getKey() {
        try {
            BrowseParams params = this.getUserParams();
            String key = params.getKey();
            if (key != null) {
                DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
                if (dso != null) {
                    key = key + "-" + dso.getHandle();
                }
                return Long.valueOf(HashUtil.hash((String)key));
            }
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            return "0";
        }
        return "0";
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                BrowseInfo info;
                DSpaceValidity validity = new DSpaceValidity();
                DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
                if (dso != null) {
                    validity.add(dso);
                }
                if (this.isItemBrowse(info = this.getBrowseInfo())) {
                    for (BrowseItem item : info.getResults()) {
                        validity.add((DSpaceObject)item);
                    }
                } else {
                    for (String[] singleEntry : this.browseInfo.getStringResults()) {
                        validity.add(singleEntry[0] + "#" + singleEntry[1]);
                    }
                }
                this.validity = validity.complete();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                return null;
            }
            if (this.validity != null) {
                log.info((Object)LogManager.getHeader((Context)this.context, (String)BROWSE_URL_BASE, (String)this.validity.toString()));
            }
        }
        return this.validity;
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        BrowseInfo info = this.getBrowseInfo();
        pageMeta.addMetadata("title").addContent(this.getTitleMessage(info));
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        if (dso != null) {
            HandleUtil.buildHandleTrail(dso, pageMeta, this.contextPath);
        }
        pageMeta.addTrail().addContent(this.getTrailMessage(info));
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        BrowseParams params = this.getUserParams();
        BrowseInfo info = this.getBrowseInfo();
        String type = info.getBrowseIndex().getName();
        Division div = body.addDivision("browse-by-" + type, "primary");
        div.setHead(this.getTitleMessage(info));
        this.addBrowseJumpNavigation(div, info, params);
        this.addBrowseControls(div, info, params);
        Division results = div.addDivision("browse-by-" + type + "-results", "primary");
        int itemsTotal = info.getTotal();
        if (itemsTotal > 0) {
            results.setSimplePagination(itemsTotal, this.browseInfo.getOverallPosition() + 1, this.browseInfo.getOverallPosition() + this.browseInfo.getResultCount(), this.getPreviousPageURL(params, info), this.getNextPageURL(params, info));
            ReferenceSet referenceSet = results.addReferenceSet("browse-by-" + type, "summaryList", type, null);
            if (this.isItemBrowse(info)) {
                for (BrowseItem item : info.getResults()) {
                    referenceSet.addReference((Object)item);
                }
            } else {
                Table singleTable = results.addTable("browse-by-" + type + "-results", this.browseInfo.getResultCount() + 1, 1);
                singleTable.addRow("header").addCell().addContent(ConfigurableBrowse.message((String)("xmlui.ArtifactBrowser.ConfigurableBrowse." + type + ".column_heading")));
                for (String[] singleEntry : this.browseInfo.getStringResults()) {
                    HashMap<String, String> queryParams = new HashMap<String, String>();
                    queryParams.put("type", ConfigurableBrowse.encodeForURL(type));
                    if (singleEntry[1] != null) {
                        queryParams.put(BrowseParams.FILTER_VALUE[1], ConfigurableBrowse.encodeForURL(singleEntry[1]));
                    } else {
                        queryParams.put(BrowseParams.FILTER_VALUE[0], ConfigurableBrowse.encodeForURL(singleEntry[0]));
                    }
                    Cell cell = singleTable.addRow().addCell();
                    cell.addXref(AbstractDSpaceTransformer.generateURL(BROWSE_URL_BASE, queryParams), singleEntry[0]);
                }
            }
        } else {
            results.addPara(T_no_results);
        }
    }

    @Override
    public void recycle() {
        this.validity = null;
        this.userParams = null;
        this.browseInfo = null;
        this.titleMessage = null;
        this.trailMessage = null;
        super.recycle();
    }

    private void addBrowseJumpNavigation(Division div, BrowseInfo info, BrowseParams params) throws WingException {
        HashMap<String, String> queryParamsGET = new HashMap<String, String>();
        queryParamsGET.putAll(params.getCommonParametersEncoded());
        queryParamsGET.putAll(params.getControlParameters());
        HashMap<String, String> queryParamsPOST = new HashMap<String, String>();
        queryParamsPOST.putAll(params.getCommonParameters());
        queryParamsPOST.putAll(params.getControlParameters());
        Division jump = div.addInteractiveDivision("browse-navigation", BROWSE_URL_BASE, "post", "secondary navigation");
        for (Map.Entry param : queryParamsPOST.entrySet()) {
            jump.addHidden((String)param.getKey()).setValue((String)param.getValue());
        }
        if (this.isSortedByDate(info)) {
            int currentYear;
            Para jumpForm = jump.addPara();
            jumpForm.addContent(T_jump_select);
            Select month = jumpForm.addSelect("month");
            month.addOption(false, "-1", T_choose_month);
            for (int i = 1; i <= 12; ++i) {
                month.addOption(false, String.valueOf(i), DCDate.getMonthName((int)i, (Locale)Locale.getDefault()));
            }
            Select year = jumpForm.addSelect("year");
            year.addOption(false, "-1", T_choose_year);
            int i = currentYear = DCDate.getCurrent().getYear();
            int oneYearBreak = (currentYear - 10) / 5 * 5;
            int fiveYearBreak = (currentYear - 30) / 10 * 10;
            int tenYearBreak = currentYear - 100;
            do {
                year.addOption(false, String.valueOf(i), String.valueOf(i));
                if (i <= fiveYearBreak) {
                    i -= 10;
                    continue;
                }
                if (i <= oneYearBreak) {
                    i -= 5;
                    continue;
                }
                --i;
            } while (i > tenYearBreak);
            jumpForm = jump.addPara();
            jumpForm.addContent(T_jump_year);
            jumpForm.addText("starts_with").setHelp(T_jump_year_help);
            jumpForm.addButton("submit").setValue(T_go);
        } else {
            List jumpList = jump.addList("jump-list", "simple", "alphabet");
            HashMap<String, String> letterQuery = new HashMap<String, String>(queryParamsGET);
            for (String valueKey : BrowseParams.FILTER_VALUE) {
                letterQuery.remove(valueKey);
            }
            letterQuery.put("starts_with", "0");
            jumpList.addItemXref(AbstractDSpaceTransformer.generateURL(BROWSE_URL_BASE, letterQuery), "0-9");
            for (char c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                letterQuery.put("starts_with", Character.toString(c));
                jumpList.addItemXref(AbstractDSpaceTransformer.generateURL(BROWSE_URL_BASE, letterQuery), Character.toString(c));
            }
            Para jumpForm = jump.addPara();
            jumpForm.addContent(T_starts_with);
            jumpForm.addText("starts_with").setHelp(T_starts_with_help);
            jumpForm.addButton("submit").setValue(T_go);
        }
    }

    private void addBrowseControls(Division div, BrowseInfo info, BrowseParams params) throws WingException {
        HashMap<String, String> queryParams = new HashMap<String, String>();
        queryParams.putAll(params.getCommonParameters());
        Division controls = div.addInteractiveDivision("browse-controls", BROWSE_URL_BASE, "post", "browse controls");
        for (Map.Entry param : queryParams.entrySet()) {
            controls.addHidden((String)param.getKey()).setValue((String)param.getValue());
        }
        Para controlsForm = controls.addPara();
        if (this.isItemBrowse(info)) {
            try {
                Set sortOptions = SortOption.getSortOptions();
                if (sortOptions.size() > 1) {
                    controlsForm.addContent(T_sort_by);
                    Select sortSelect = controlsForm.addSelect("sort_by");
                    for (SortOption so : sortOptions) {
                        if (!so.isVisible()) continue;
                        sortSelect.addOption(so.equals(info.getSortOption()), so.getNumber(), ConfigurableBrowse.message((String)("xmlui.ArtifactBrowser.ConfigurableBrowse.sort_by." + so.getName())));
                    }
                }
            }
            catch (SortException se) {
                throw new WingException("Unable to get sort options", (Throwable)se);
            }
        }
        controlsForm.addContent(T_order);
        Select orderSelect = controlsForm.addSelect("order");
        orderSelect.addOption("ASC".equals(params.scope.getOrder()), "ASC", T_order_asc);
        orderSelect.addOption("DESC".equals(params.scope.getOrder()), "DESC", T_order_desc);
        controlsForm.addContent(T_rpp);
        Select rppSelect = controlsForm.addSelect("rpp");
        for (int i : RESULTS_PER_PAGE_PROGRESSION) {
            rppSelect.addOption(i == info.getResultsPerPage(), i, Integer.toString(i));
        }
        controlsForm.addButton("update").setValue(T_update);
    }

    private String getPreviousPageURL(BrowseParams params, BrowseInfo info) throws SQLException, UIException {
        if (info.isFirst()) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(params.getCommonParametersEncoded());
        parameters.putAll(params.getControlParameters());
        if (info.hasPrevPage()) {
            parameters.put("offset", ConfigurableBrowse.encodeForURL(String.valueOf(info.getPrevOffset())));
        }
        return AbstractDSpaceTransformer.generateURL(BROWSE_URL_BASE, parameters);
    }

    private String getNextPageURL(BrowseParams params, BrowseInfo info) throws SQLException, UIException {
        if (info.isLast()) {
            return null;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.putAll(params.getCommonParametersEncoded());
        parameters.putAll(params.getControlParameters());
        if (info.hasNextPage()) {
            parameters.put("offset", ConfigurableBrowse.encodeForURL(String.valueOf(info.getNextOffset())));
        }
        return AbstractDSpaceTransformer.generateURL(BROWSE_URL_BASE, parameters);
    }

    private BrowseParams getUserParams() throws SQLException, UIException {
        if (this.userParams != null) {
            return this.userParams;
        }
        Context context = ContextUtil.obtainContext(this.objectModel);
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        BrowseParams params = new BrowseParams();
        params.month = request.getParameter("month");
        params.year = request.getParameter("year");
        params.etAl = RequestUtils.getIntParameter(request, "etal");
        params.scope = new BrowserScope(context);
        DSpaceObject dso = HandleUtil.obtainHandle(this.objectModel);
        if (dso instanceof Community) {
            params.scope.setCommunity((Community)dso);
        }
        if (dso instanceof Collection) {
            params.scope.setCollection((Collection)dso);
        }
        try {
            String type = request.getParameter("type");
            int sortBy = RequestUtils.getIntParameter(request, "sort_by");
            BrowseIndex bi = BrowseIndex.getBrowseIndex((String)type);
            if (bi == null) {
                throw new BrowseException("There is no browse index of the type: " + type);
            }
            if (sortBy == -1) {
                SortOption so = bi.getSortOption();
                if (so != null) {
                    sortBy = so.getNumber();
                }
            } else if (bi.isItemIndex() && !bi.isInternalIndex()) {
                try {
                    BrowseIndex newBi;
                    SortOption bso = bi.getSortOption();
                    SortOption so = SortOption.getSortOption((int)sortBy);
                    if (bso != null && bso.equals(so) && (newBi = BrowseIndex.getBrowseIndex((SortOption)so)) != null) {
                        bi = newBi;
                        type = bi.getName();
                    }
                }
                catch (SortException se) {
                    throw new UIException("Unable to get sort options", se);
                }
            }
            params.scope.setBrowseIndex(bi);
            params.scope.setSortBy(sortBy);
            params.scope.setJumpToItem(RequestUtils.getIntParameter(request, "focus"));
            params.scope.setOrder(request.getParameter("order"));
            int offset = RequestUtils.getIntParameter(request, "offset");
            params.scope.setOffset(offset > 0 ? offset : 0);
            params.scope.setResultsPerPage(RequestUtils.getIntParameter(request, "rpp"));
            params.scope.setStartsWith(ConfigurableBrowse.decodeFromURL(request.getParameter("starts_with")));
            String filterValue = request.getParameter(BrowseParams.FILTER_VALUE[0]);
            if (filterValue == null) {
                filterValue = request.getParameter(BrowseParams.FILTER_VALUE[1]);
                params.scope.setAuthorityValue(filterValue);
            }
            params.scope.setFilterValue(filterValue);
            params.scope.setJumpToValue(ConfigurableBrowse.decodeFromURL(request.getParameter("vfocus")));
            params.scope.setJumpToValueLang(ConfigurableBrowse.decodeFromURL(request.getParameter("vfocus_lang")));
            params.scope.setFilterValueLang(ConfigurableBrowse.decodeFromURL(request.getParameter("value_lang")));
            if (params.scope.getFilterValue() != null) {
                params.scope.setBrowseLevel(1);
            }
            if (params.year != null && !"".equals(params.year) && !"-1".equals(params.year)) {
                String startsWith = params.year;
                if (params.month != null && !"-1".equals(params.month) && !"".equals(params.month)) {
                    if ("ASC".equals(params.scope.getOrder())) {
                        params.month = Integer.toString(Integer.parseInt(params.month) - 1);
                    }
                    if (params.month.length() == 1) {
                        params.month = "0" + params.month;
                    }
                    startsWith = params.year + "-" + params.month;
                    if ("ASC".equals(params.scope.getOrder())) {
                        startsWith = startsWith + "-32";
                    }
                }
                params.scope.setStartsWith(startsWith);
            }
        }
        catch (BrowseException bex) {
            throw new UIException("Unable to create browse parameters", bex);
        }
        this.userParams = params;
        return params;
    }

    private BrowseInfo getBrowseInfo() throws SQLException, UIException {
        if (this.browseInfo != null) {
            return this.browseInfo;
        }
        Context context = ContextUtil.obtainContext(this.objectModel);
        BrowseParams params = this.getUserParams();
        try {
            BrowseEngine be = new BrowseEngine(context);
            this.browseInfo = be.browse(params.scope);
            if (params.etAl < 0) {
                int etAl = ConfigurationManager.getIntProperty((String)"webui.browse.author-limit");
                if (etAl != 0) {
                    this.browseInfo.setEtAl(etAl);
                }
            } else if (params.etAl == 0) {
                this.browseInfo.setEtAl(-1);
            } else {
                this.browseInfo.setEtAl(params.etAl);
            }
        }
        catch (BrowseException bex) {
            throw new UIException("Unable to process browse", bex);
        }
        return this.browseInfo;
    }

    private boolean isItemBrowse(BrowseInfo info) {
        return info.getBrowseIndex().isItemIndex() || info.isSecondLevel();
    }

    private boolean isSortedByDate(BrowseInfo info) {
        return info.getSortOption().isDate() || info.getBrowseIndex().isDate() && info.getSortOption().isDefault();
    }

    private Message getTitleMessage(BrowseInfo info) {
        if (this.titleMessage == null) {
            BrowseIndex bix = info.getBrowseIndex();
            String value = "";
            if (info.hasValue()) {
                if (bix.isAuthorityIndex()) {
                    ChoiceAuthorityManager cm = ChoiceAuthorityManager.getManager();
                    String fk = ChoiceAuthorityManager.makeFieldKey((String)bix.getMetadata(0));
                    value = "\"" + cm.getLabel(fk, info.getValue(), null) + "\"";
                } else {
                    value = "\"" + info.getValue() + "\"";
                }
            }
            String scopeName = "";
            scopeName = info.getBrowseContainer() != null ? info.getBrowseContainer().getName() : "";
            this.titleMessage = bix.isMetadataIndex() ? ConfigurableBrowse.message((String)("xmlui.ArtifactBrowser.ConfigurableBrowse.title.metadata." + bix.getName())).parameterize(new Object[]{scopeName, value}) : (info.getSortOption() != null ? ConfigurableBrowse.message((String)("xmlui.ArtifactBrowser.ConfigurableBrowse.title.item." + info.getSortOption().getName())).parameterize(new Object[]{scopeName, value}) : ConfigurableBrowse.message((String)("xmlui.ArtifactBrowser.ConfigurableBrowse.title.item." + bix.getSortOption().getName())).parameterize(new Object[]{scopeName, value}));
        }
        return this.titleMessage;
    }

    private Message getTrailMessage(BrowseInfo info) {
        if (this.trailMessage == null) {
            BrowseIndex bix = info.getBrowseIndex();
            String scopeName = "";
            scopeName = info.getBrowseContainer() != null ? info.getBrowseContainer().getName() : "";
            this.trailMessage = bix.isMetadataIndex() ? ConfigurableBrowse.message((String)("xmlui.ArtifactBrowser.ConfigurableBrowse.trail.metadata." + bix.getName())).parameterize(new Object[]{scopeName}) : (info.getSortOption() != null ? ConfigurableBrowse.message((String)("xmlui.ArtifactBrowser.ConfigurableBrowse.trail.item." + info.getSortOption().getName())).parameterize(new Object[]{scopeName}) : ConfigurableBrowse.message((String)("xmlui.ArtifactBrowser.ConfigurableBrowse.trail.item." + bix.getSortOption().getName())).parameterize(new Object[]{scopeName}));
        }
        return this.trailMessage;
    }
}

