/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.general;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingConstants;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.authorize.AuthorizeException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PageNotFoundTransformer
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_title = PageNotFoundTransformer.message((String)"xmlui.PageNotFound.title");
    private static final Message T_head = PageNotFoundTransformer.message((String)"xmlui.PageNotFound.head");
    private static final Message T_para1 = PageNotFoundTransformer.message((String)"xmlui.PageNotFound.para1");
    private static final Message T_go_home = PageNotFoundTransformer.message((String)"xmlui.general.go_home");
    private static final Message T_dspace_home = PageNotFoundTransformer.message((String)"xmlui.general.dspace_home");
    private SAXEvent bodyEvent;
    private boolean bodyEmpty;

    public Serializable getKey() {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        return Long.valueOf(HashUtil.hash((String)request.getSitemapURI()));
    }

    public SourceValidity getValidity() {
        return NOPValidity.SHARED_INSTANCE;
    }

    public void startDocument() throws SAXException {
        this.bodyEvent = null;
        this.bodyEmpty = false;
        super.startDocument();
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.bodyEvent != null) {
            this.sendEvent(this.bodyEvent);
            this.bodyEvent = null;
        }
        if (WingConstants.DRI.URI.equals(namespaceURI) && "body".equals(localName)) {
            this.bodyEvent = SAXEvent.startElement(namespaceURI, localName, qName, attributes);
            return;
        }
        super.startElement(namespaceURI, localName, qName, attributes);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this.bodyEvent != null && WingConstants.DRI.URI.equals(namespaceURI) && "body".equals(localName)) {
            this.bodyEmpty = true;
            this.sendEvent(this.bodyEvent);
            this.bodyEvent = null;
        }
        super.endElement(namespaceURI, localName, qName);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        if (this.bodyEmpty) {
            Division notFound = body.addDivision("page-not-found", "primary");
            notFound.setHead(T_head);
            notFound.addPara(T_para1);
            notFound.addPara().addXref(this.contextPath + "/", T_go_home);
            HttpServletResponse response = (HttpServletResponse)this.objectModel.get("httpresponse");
            response.setStatus(404);
        }
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        if (this.bodyEmpty) {
            pageMeta.addMetadata("title").addContent(T_title);
            pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        }
    }

    public void sendEvent(SAXEvent event) throws SAXException {
        if (event.type == SAXEvent.EventType.START) {
            super.startElement(event.namespaceURI, event.localName, event.qName, event.attributes);
        } else if (event.type == SAXEvent.EventType.END) {
            super.endElement(event.namespaceURI, event.localName, event.qName);
        }
    }

    private static class SAXEvent {
        protected EventType type = null;
        protected String namespaceURI = null;
        protected String localName = null;
        protected String qName = null;
        protected Attributes attributes = null;

        private SAXEvent() {
        }

        public static SAXEvent startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
            SAXEvent event = new SAXEvent();
            event.type = EventType.START;
            event.namespaceURI = namespaceURI;
            event.localName = localName;
            event.qName = qName;
            event.attributes = attributes;
            return event;
        }

        public static SAXEvent endElement(String namespaceURI, String localName, String qName) {
            SAXEvent event = new SAXEvent();
            event.type = EventType.END;
            event.namespaceURI = namespaceURI;
            event.localName = localName;
            event.qName = qName;
            return event;
        }

        public static enum EventType {
            START,
            END;

        }
    }
}

