/**
 * The contents of this file are subject to the license and copyright
 * detailed in the LICENSE and NOTICE files at the root of the source
 * tree and available online at
 *
 * http://www.dspace.org/license/
 */
package org.dspace.app.xmlui.aspect.administrative.community;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.Arrays;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Community;
import org.dspace.core.ConfigurationManager;

/**
 *
 * @author wbossons
 */
public class CurateCommunityForm extends AbstractDSpaceTransformer   {

        /** Common Package Language Strings */
	private static final Message T_dspace_home = message("xmlui.general.dspace_home");

	private static final Message T_community_trail = message("xmlui.administrative.community.general.community_trail");
	private static final Message T_options_metadata = message("xmlui.administrative.community.general.options_metadata");
	private static final Message T_options_roles = message("xmlui.administrative.community.general.options_roles");
        private static final Message T_options_curate = message("xmlui.administrative.community.general.options_curate");
        private static final Message T_submit_perform = message("xmlui.general.perform");
        private static final Message T_submit_queue = message("xmlui.general.queue");
        private static final Message T_submit_return = message("xmlui.general.return");
        // End common package language strings

        // Page/Form specific language strings
        private static final Message T_main_head = message("xmlui.administrative.community.CurateCommunityForm.main_head");
        private static final Message T_title = message("xmlui.administrative.community.CurateCommunityForm.title");
        private static final Message T_trail = message("xmlui.administrative.community.CurateCommunityForm.trail");

        private static final Message T_label_name = message("xmlui.administrative.community.CurateCommunityForm.label_name");

        /**
         * common package method for initializing form gui elements
         * Could be refactored.
         * 
         * @param pageMeta
         * @throws WingException
         */
        public void addPageMeta(PageMeta pageMeta) throws WingException
    {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_community_trail);
        pageMeta.addTrail().addContent(T_trail);
    }
        /** addBody
     *
     * @param body
     * @throws WingException
     * @throws SQLException
     * @throws AuthorizeException
     */
        public void addBody(Body body)
                                    throws WingException, SQLException,
                                                        AuthorizeException, UnsupportedEncodingException
	{
		int communityID = parameters.getParameterAsInteger("communityID", -1);
		Community thisCommunity = Community.find(context, communityID);

		String baseURL = contextPath + "/admin/community?administrative-continue=" + knot.getId();


		// DIVISION: main
	    Division main = body.addInteractiveDivision("community-curate",contextPath+"/admin/community",Division.METHOD_MULTIPART,"primary administrative community");
	    main.setHead(T_main_head.parameterize(thisCommunity.getName()));

            List options = main.addList("options",List.TYPE_SIMPLE,"horizontal");
            options.addItem().addXref(baseURL+"&submit_metadata",T_options_metadata);
            options.addItem().addXref(baseURL+"&submit_roles",T_options_roles);
            options.addItem().addHighlight("bold").addXref(baseURL+"&submit_curate",T_options_curate);

	    List curationTaskList = main.addList("curationTaskList", "form");
	    curationTaskList.addLabel(T_label_name);
            Select select = curationTaskList.addItem().addSelect("curate_task");
            select = getCurationOptions(select);
            select.setSize(1);
            select.setRequired();
            
            // need submit_curate_task and submit_return
	    Para buttonList = main.addPara();
            buttonList.addButton("submit_curate_task").setValue(T_submit_perform);
            buttonList.addButton("submit_queue_task").setValue(T_submit_queue);
	    buttonList.addButton("submit_return").setValue(T_submit_return);
            main.addHidden("administrative-continue").setValue(knot.getId());

    }

        private Select getCurationOptions(Select select)
                                            throws WingException, UnsupportedEncodingException {
            String tasksString = ConfigurationManager.getProperty("curate", "ui.tasknames");
            String[] tasks = tasksString.split(",");
            java.util.List<String> taskList = Arrays.asList(tasks);
            for (String task : taskList)
            {
                String[] keyValuePair = task.split("=");
                select.addOption(URLDecoder.decode(keyValuePair[0].trim(), "UTF-8"), URLDecoder.decode(keyValuePair[1].trim(), "UTF-8"));
            }
            return select;
        }

        // Add a method here to build it into the dspace.cfg ... ui.curation_tasks = estimate = "Estate"
        // Mapping the task name to either the description or the mapping key

        


}
