/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.authorization;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.core.Context;

public class AuthorizationMain
extends AbstractDSpaceTransformer {
    private static final Message T_title = AuthorizationMain.message((String)"xmlui.administrative.authorization.AuthorizationMain.title");
    private static final Message T_authorize_trail = AuthorizationMain.message((String)"xmlui.administrative.authorization.general.authorize_trail");
    private static final Message T_main_head = AuthorizationMain.message((String)"xmlui.administrative.authorization.AuthorizationMain.main_head");
    private static final Message T_actions_head = AuthorizationMain.message((String)"xmlui.administrative.authorization.AuthorizationMain.actions_head");
    private static final Message T_actions_item_lookup = AuthorizationMain.message((String)"xmlui.administrative.authorization.AuthorizationMain.actions_item_lookup");
    private static final Message T_bad_name = AuthorizationMain.message((String)"xmlui.administrative.authorization.AuthorizationMain.bad_name");
    private static final Message T_search_help = AuthorizationMain.message((String)"xmlui.administrative.authorization.AuthorizationMain.search_help");
    private static final Message T_submit_find = AuthorizationMain.message((String)"xmlui.administrative.authorization.AuthorizationMain.submit_find");
    private static final Message T_actions_advanced = AuthorizationMain.message((String)"xmlui.administrative.authorization.AuthorizationMain.actions_advanced");
    private static final Message T_actions_advanced_link = AuthorizationMain.message((String)"xmlui.administrative.authorization.AuthorizationMain.actions_advanced_link");
    private static final Message T_containerList_head = AuthorizationMain.message((String)"xmlui.administrative.authorization.AuthorizationMain.containerList_head");
    private static final Message T_containerList_para = AuthorizationMain.message((String)"xmlui.administrative.authorization.AuthorizationMain.containerList_para");
    private static final Message T_dspace_home = AuthorizationMain.message((String)"xmlui.general.dspace_home");
    private static final Message T_untitled = AuthorizationMain.message((String)"xmlui.general.untitled");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/authorize", T_authorize_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException {
        String query = AuthorizationMain.decodeFromURL(this.parameters.getParameter("query", null));
        String baseURL = this.contextPath + "/admin/epeople?administrative-continue=" + this.knot.getId();
        String errorString = this.parameters.getParameter("errors", null);
        ArrayList<String> errors = new ArrayList<String>();
        if (errorString != null) {
            for (String error : errorString.split(",")) {
                errors.add(error);
            }
        }
        Division main = body.addInteractiveDivision("authorization-main", this.contextPath + "/admin/authorize", "post", "primary administrative authorization");
        main.setHead(T_main_head);
        Division actions = main.addDivision("authorization-actions");
        actions.setHead(T_actions_head);
        List actionsList = actions.addList("actions");
        actionsList.addLabel(T_actions_item_lookup);
        Item actionItem = actionsList.addItem();
        Text queryField = actionItem.addText("identifier");
        if (query != null) {
            queryField.setValue(query);
        }
        if (errors.contains("identifier")) {
            queryField.addError(T_bad_name);
        }
        queryField.setHelp(T_search_help);
        actionItem.addButton("submit_edit").setValue(T_submit_find);
        actionsList.addLabel(T_actions_advanced);
        actionsList.addItemXref(baseURL + "&submit_wildcard", T_actions_advanced_link);
        Division containers = main.addDivision("authorization-containerList");
        containers.setHead(T_containerList_head);
        containers.addPara(T_containerList_para);
        List containerList = containers.addList("containerList");
        this.containerListBuilder(baseURL, containerList, null);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    private void containerListBuilder(String baseURL, List parentList, Community currentCommunity) throws SQLException, WingException {
        if (currentCommunity == null) {
            for (Community topLevel : Community.findAllTop((Context)this.context)) {
                this.containerListBuilder(baseURL, parentList, topLevel);
            }
        } else {
            parentList.addItem().addHighlight("bold").addXref(baseURL + "&submit_edit&community_id=" + currentCommunity.getID(), currentCommunity.getMetadata("name"));
            List containerSubList = null;
            for (Collection collection : currentCommunity.getCollections()) {
                String name;
                if (containerSubList == null) {
                    containerSubList = parentList.addList("subList" + currentCommunity.getID());
                }
                if ((name = collection.getMetadata("name")) == null || name.length() == 0) {
                    containerSubList.addItemXref(baseURL + "&submit_edit&collection_id=" + collection.getID(), T_untitled);
                    continue;
                }
                containerSubList.addItemXref(baseURL + "&submit_edit&collection_id=" + collection.getID(), name);
            }
            for (Collection collection : currentCommunity.getSubcommunities()) {
                if (containerSubList == null) {
                    containerSubList = parentList.addList("subList" + currentCommunity.getID());
                }
                this.containerListBuilder(baseURL, containerSubList, (Community)collection);
            }
        }
    }
}

