/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.item;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.core.Context;
import org.xml.sax.SAXException;

public class EditBitstreamForm
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = EditBitstreamForm.message((String)"xmlui.general.dspace_home");
    private static final Message T_submit_save = EditBitstreamForm.message((String)"xmlui.general.save");
    private static final Message T_submit_cancel = EditBitstreamForm.message((String)"xmlui.general.cancel");
    private static final Message T_item_trail = EditBitstreamForm.message((String)"xmlui.administrative.item.general.item_trail");
    private static final Message T_title = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.title");
    private static final Message T_trail = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.trail");
    private static final Message T_head1 = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.head1");
    private static final Message T_file_label = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.file_label");
    private static final Message T_primary_label = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.primary_label");
    private static final Message T_primary_option_yes = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.primary_option_yes");
    private static final Message T_primary_option_no = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.primary_option_no");
    private static final Message T_description_label = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.description_label");
    private static final Message T_description_help = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.description_help");
    private static final Message T_para1 = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.para1");
    private static final Message T_format_label = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.format_label");
    private static final Message T_format_default = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.format_default");
    private static final Message T_para2 = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.para2");
    private static final Message T_user_label = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.user_label");
    private static final Message T_user_help = EditBitstreamForm.message((String)"xmlui.administrative.item.EditBitstreamForm.user_help");

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/item", T_item_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        int bitstreamID = this.parameters.getParameterAsInteger("bitstreamID", -1);
        Bitstream bitstream = Bitstream.find((Context)this.context, (int)bitstreamID);
        BitstreamFormat currentFormat = bitstream.getFormat();
        BitstreamFormat[] bitstreamFormats = AuthorizeManager.isAdmin((Context)this.context) ? BitstreamFormat.findAll((Context)this.context) : BitstreamFormat.findNonInternal((Context)this.context);
        boolean primaryBitstream = false;
        Bundle[] bundles = bitstream.getBundles();
        if (bundles != null && bundles.length > 0 && bitstreamID == bundles[0].getPrimaryBitstreamID()) {
            primaryBitstream = true;
        }
        String fileUrl = this.contextPath + "/bitstream/id/" + bitstream.getID() + "/" + bitstream.getName();
        String fileName = bitstream.getName();
        Division div = body.addInteractiveDivision("edit-bitstream", this.contextPath + "/admin/item", "multipart", "primary administrative item");
        div.setHead(T_head1);
        List edit = div.addList("edit-bitstream-list", "form");
        edit.addLabel(T_file_label);
        edit.addItem().addXref(fileUrl, fileName);
        Select primarySelect = edit.addItem().addSelect("primary");
        primarySelect.setLabel(T_primary_label);
        primarySelect.addOption(primaryBitstream, "yes", T_primary_option_yes);
        primarySelect.addOption(!primaryBitstream, "no", T_primary_option_no);
        Text description = edit.addItem().addText("description");
        description.setLabel(T_description_label);
        description.setHelp(T_description_help);
        description.setValue(bitstream.getDescription());
        edit.addItem(T_para1);
        Select format = edit.addItem().addSelect("formatID");
        format.setLabel(T_format_label);
        int unknownFormatID = BitstreamFormat.findUnknown((Context)this.context).getID();
        format.addOption(-1, T_format_default);
        for (BitstreamFormat bitstreamFormat : bitstreamFormats) {
            if (bitstreamFormat.getID() == unknownFormatID) continue;
            String supportLevel = "Unknown";
            if (bitstreamFormat.getSupportLevel() == 1) {
                supportLevel = "known";
            } else if (bitstreamFormat.getSupportLevel() == 2) {
                supportLevel = "Supported";
            }
            String name = bitstreamFormat.getShortDescription() + " (" + supportLevel + ")";
            if (bitstreamFormat.isInternal()) {
                name = name + " (Internal)";
            }
            int id = bitstreamFormat.getID();
            format.addOption(id, name);
        }
        if (currentFormat != null) {
            format.setOptionSelected(currentFormat.getID());
        } else {
            format.setOptionSelected(-1);
        }
        edit.addItem(T_para2);
        Text userFormat = edit.addItem().addText("user_format");
        userFormat.setLabel(T_user_label);
        userFormat.setHelp(T_user_help);
        userFormat.setValue(bitstream.getUserFormatDescription());
        Item actions = edit.addItem();
        actions.addButton("submit_save").setValue(T_submit_save);
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
        div.addHidden("administrative-continue").setValue(this.knot.getId());
    }
}

