/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.util.Util;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.aspect.submission.submit.EditFileStep;
import org.dspace.app.xmlui.aspect.submission.submit.ReviewStep;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.File;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Radio;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.workflow.WorkflowItem;
import org.xml.sax.SAXException;

public class UploadStep
extends AbstractSubmissionStep {
    protected static final Message T_head = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.head");
    protected static final Message T_file = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.file");
    protected static final Message T_file_help = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.file_help");
    protected static final Message T_file_error = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.file_error");
    protected static final Message T_upload_error = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.upload_error");
    protected static final Message T_virus_checker_error = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.virus_checker_error");
    protected static final Message T_virus_error = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.virus_error");
    protected static final Message T_description = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.description");
    protected static final Message T_description_help = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.description_help");
    protected static final Message T_submit_upload = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.submit_upload");
    protected static final Message T_head2 = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.head2");
    protected static final Message T_column0 = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.column0");
    protected static final Message T_column1 = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.column1");
    protected static final Message T_column2 = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.column2");
    protected static final Message T_column3 = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.column3");
    protected static final Message T_column4 = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.column4");
    protected static final Message T_column5 = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.column5");
    protected static final Message T_column6 = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.column6");
    protected static final Message T_unknown_name = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.unknown_name");
    protected static final Message T_unknown_format = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.unknown_format");
    protected static final Message T_supported = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.supported");
    protected static final Message T_known = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.known");
    protected static final Message T_unsupported = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.unsupported");
    protected static final Message T_submit_edit = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.submit_edit");
    protected static final Message T_checksum = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.checksum");
    protected static final Message T_submit_remove = UploadStep.message((String)"xmlui.Submission.submit.UploadStep.submit_remove");
    private EditFileStep editFile = null;

    public UploadStep() {
        this.requireSubmission = true;
        this.requireStep = true;
    }

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        if (this.errorFlag == 20) {
            this.editFile = new EditFileStep();
            this.editFile.setup(resolver, objectModel, src, parameters);
        } else {
            this.editFile = null;
        }
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        if (this.editFile != null) {
            this.editFile.addBody(body);
            return;
        }
        Item item = this.submission.getItem();
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        boolean workflow = this.submission instanceof WorkflowItem;
        Bundle[] bundles = item.getBundles("ORIGINAL");
        Bitstream[] bitstreams = new Bitstream[]{};
        if (bundles.length > 0) {
            bitstreams = bundles[0].getBitstreams();
        }
        Division div = body.addInteractiveDivision("submit-upload", actionURL, "multipart", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        List upload = null;
        if (!workflow) {
            upload = div.addList("submit-upload-new", "form");
            upload.setHead(T_head);
            File file = upload.addItem().addFile("file");
            file.setLabel(T_file);
            file.setHelp(T_file_help);
            file.setRequired();
            if (this.errorFlag == 5) {
                file.addError(T_file_error);
            }
            if (this.errorFlag == 2) {
                file.addError(T_upload_error);
            }
            if (this.errorFlag == 14) {
                file.addError(T_virus_checker_error);
            }
            if (this.errorFlag == 16) {
                file.addError(T_virus_error);
            }
            Text description = upload.addItem().addText("description");
            description.setLabel(T_description);
            description.setHelp(T_description_help);
            Button uploadSubmit = upload.addItem().addButton("submit_upload");
            uploadSubmit.setValue(T_submit_upload);
        }
        if (bitstreams.length > 0 || workflow) {
            Table summary = div.addTable("submit-upload-summary", bitstreams.length * 2 + 2, 7);
            summary.setHead(T_head2);
            Row header = summary.addRow("header");
            header.addCellContent(T_column0);
            header.addCellContent(T_column1);
            header.addCellContent(T_column2);
            header.addCellContent(T_column3);
            header.addCellContent(T_column4);
            header.addCellContent(T_column5);
            header.addCellContent(T_column6);
            for (Bitstream bitstream : bitstreams) {
                int id = bitstream.getID();
                String name = bitstream.getName();
                String url = this.makeBitstreamLink(item, bitstream);
                long bytes = bitstream.getSize();
                String desc = bitstream.getDescription();
                String algorithm = bitstream.getChecksumAlgorithm();
                String checksum = bitstream.getChecksum();
                Row row = summary.addRow();
                Radio primary = row.addCell().addRadio("primary_bitstream_id");
                primary.addOption(String.valueOf(id));
                if (bundles[0].getPrimaryBitstreamID() == id) {
                    primary.setOptionSelected(String.valueOf(id));
                }
                if (!workflow) {
                    CheckBox remove = row.addCell().addCheckBox("remove");
                    remove.setLabel("remove");
                    remove.addOption(id);
                } else {
                    row.addCell();
                }
                row.addCell().addXref(url, name);
                row.addCellContent(bytes + " bytes");
                if (desc == null || desc.length() == 0) {
                    row.addCellContent(T_unknown_name);
                } else {
                    row.addCellContent(desc);
                }
                BitstreamFormat format = bitstream.getFormat();
                if (format == null) {
                    row.addCellContent(T_unknown_format);
                } else {
                    int support = format.getSupportLevel();
                    Cell cell = row.addCell();
                    cell.addContent(format.getMIMEType());
                    cell.addContent(" ");
                    switch (support) {
                        case 1: {
                            cell.addContent(T_supported);
                            break;
                        }
                        case 2: {
                            cell.addContent(T_known);
                            break;
                        }
                        case 3: {
                            cell.addContent(T_unsupported);
                        }
                    }
                }
                Button edit = row.addCell().addButton("submit_edit_" + id);
                edit.setValue(T_submit_edit);
                Row checksumRow = summary.addRow();
                checksumRow.addCell();
                Cell checksumCell = checksumRow.addCell(null, null, 0, 6, null);
                checksumCell.addHighlight("bold").addContent(T_checksum);
                checksumCell.addContent(" ");
                checksumCell.addContent(algorithm + ":" + checksum);
            }
            if (!workflow) {
                Row actionRow = summary.addRow();
                actionRow.addCell();
                Button removeSeleceted = actionRow.addCell(null, null, 0, 6, null).addButton("submit_remove_selected");
                removeSeleceted.setValue(T_submit_remove);
            }
            upload = div.addList("submit-upload-new-part2", "form");
        }
        this.addControlButtons(upload);
    }

    @Override
    public List addReviewSection(List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        List uploadSection = reviewList.addList("submit-review-" + this.stepAndPage, "form");
        uploadSection.setHead(T_head);
        Item item = this.submission.getItem();
        Bundle[] bundles = item.getBundles("ORIGINAL");
        Bitstream[] bitstreams = new Bitstream[]{};
        if (bundles.length > 0) {
            bitstreams = bundles[0].getBitstreams();
        }
        for (Bitstream bitstream : bitstreams) {
            BitstreamFormat bitstreamFormat = bitstream.getFormat();
            String name = bitstream.getName();
            String url = this.makeBitstreamLink(item, bitstream);
            String format = bitstreamFormat.getShortDescription();
            Message support = ReviewStep.T_unknown;
            if (bitstreamFormat.getSupportLevel() == 1) {
                support = T_known;
            } else if (bitstreamFormat.getSupportLevel() == 2) {
                support = T_supported;
            }
            org.dspace.app.xmlui.wing.element.Item file = uploadSection.addItem();
            file.addXref(url, name);
            file.addContent(" - " + format + " ");
            file.addContent(support);
        }
        return uploadSection;
    }

    private String makeBitstreamLink(Item item, Bitstream bitstream) {
        String name = bitstream.getName();
        StringBuilder result = new StringBuilder(this.contextPath);
        result.append("/bitstream/item/").append(String.valueOf(item.getID()));
        try {
            if (name != null) {
                result.append("/").append(Util.encodeBitstreamName((String)name, (String)"UTF-8"));
            }
        }
        catch (UnsupportedEncodingException uee) {
            // empty catch block
        }
        result.append("?sequence=").append(String.valueOf(bitstream.getSequenceID()));
        return result.toString();
    }
}

