/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.xmlworkflow.actions.processingaction;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.aspect.xmlworkflow.AbstractXMLUIAction;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.TextArea;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.xmlworkflow.state.actions.Action;
import org.xml.sax.SAXException;

public class ReviewAction
extends AbstractXMLUIAction {
    private static final Message T_HEAD = ReviewAction.message((String)"xmlui.XMLWorkflow.workflow.AcceptAction.head");
    protected static final Message T_info1 = ReviewAction.message((String)"xmlui.XMLWorkflow.workflow.AcceptAction.info1");
    protected static final Message T_info2 = ReviewAction.message((String)"xmlui.Submission.workflow.RejectTaskStep.info1");
    protected static final Message T_approve_help = ReviewAction.message((String)"xmlui.XMLWorkflow.workflow.AcceptAction.approve_help");
    protected static final Message T_approve_submit = ReviewAction.message((String)"xmlui.XMLWorkflow.workflow.AcceptAction.approve_submit");
    protected static final Message T_reject_help = ReviewAction.message((String)"xmlui.XMLWorkflow.workflow.AcceptAction.reject_help");
    protected static final Message T_reject_submit = ReviewAction.message((String)"xmlui.XMLWorkflow.workflow.AcceptAction.reject_submit");
    protected static final Message T_reason_required = ReviewAction.message((String)"xmlui.Submission.workflow.RejectTaskStep.reason_required");
    protected static final Message T_reason = ReviewAction.message((String)"xmlui.Submission.workflow.RejectTaskStep.reason");
    protected static final Message T_submit_reject = ReviewAction.message((String)"xmlui.Submission.workflow.RejectTaskStep.submit_reject");
    protected static final Message T_submit_cancel = ReviewAction.message((String)"xmlui.general.cancel");
    protected static final Message T_cancel_submit = ReviewAction.message((String)"xmlui.general.cancel");

    @Override
    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        Item item = this.workflowItem.getItem();
        Collection collection = this.workflowItem.getCollection();
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/xmlworkflow";
        int page = 0;
        if (request.getAttribute("page") != null) {
            page = Integer.parseInt(request.getAttribute("page").toString());
        }
        Division div = body.addInteractiveDivision("perform-task", actionURL, "post", "primary workflow");
        div.setHead(T_HEAD);
        this.addWorkflowItemInformation(div, item, request);
        switch (page) {
            case 0: {
                this.renderMainPage(div);
                break;
            }
            case 1: {
                this.renderRejectPage(div);
            }
        }
        div.addHidden("submission-continue").setValue(this.knot.getId());
    }

    private void renderMainPage(Division div) throws WingException {
        Table table = div.addTable("workflow-actions", 1, 1);
        table.setHead(T_info1);
        Row row = table.addRow();
        row.addCellContent(T_approve_help);
        row.addCell().addButton("submit_approve").setValue(T_approve_submit);
        row = table.addRow();
        row.addCellContent(T_reject_help);
        row.addCell().addButton("submit_reject").setValue(T_reject_submit);
        row = table.addRow();
        row.addCell(0, 2).addButton("submit_leave").setValue(T_cancel_submit);
        div.addHidden("page").setValue(0);
    }

    private void renderRejectPage(Division div) throws WingException {
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        List form = div.addList("reject-workflow", "form");
        form.addItem(T_info2);
        TextArea reason = form.addItem().addTextArea("reason");
        reason.setLabel(T_reason);
        reason.setRequired();
        reason.setSize(15, 50);
        if (Action.getErrorFields((HttpServletRequest)request).contains("reason")) {
            reason.addError(T_reason_required);
        }
        div.addHidden("page").setValue(1);
        org.dspace.app.xmlui.wing.element.Item actions = form.addItem();
        actions.addButton("submit_reject").setValue(T_submit_reject);
        actions.addButton("submit_cancel").setValue(T_submit_cancel);
    }
}

