/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.general;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.avalon.framework.parameters.ParameterException;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Composite;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Hidden;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCPersonName;
import org.dspace.content.authority.ChoiceAuthorityManager;
import org.dspace.core.ConfigurationManager;
import org.xml.sax.SAXException;

public class ChoiceLookupTransformer
extends AbstractDSpaceTransformer {
    private static final String CONFIG_PREFIX = "xmlui.lookup.field.";
    private static final String MESSAGE_PREFIX = "xmlui.ChoiceLookupTransformer.";
    private static final Message T_title = ChoiceLookupTransformer.message((String)"xmlui.ChoiceLookupTransformer.title");
    private static final Message T_add = ChoiceLookupTransformer.message((String)"xmlui.ChoiceLookupTransformer.add");
    private static final Message T_accept = ChoiceLookupTransformer.message((String)"xmlui.ChoiceLookupTransformer.accept");
    private static final Message T_more = ChoiceLookupTransformer.message((String)"xmlui.ChoiceLookupTransformer.more");
    private static final Message T_cancel = ChoiceLookupTransformer.message((String)"xmlui.ChoiceLookupTransformer.cancel");
    private static final Message T_results = ChoiceLookupTransformer.message((String)"xmlui.ChoiceLookupTransformer.results");
    private static final Message T_fail = ChoiceLookupTransformer.message((String)"xmlui.ChoiceLookupTransformer.fail");

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        String field = null;
        String value = null;
        String formID = null;
        String confIndicatorID = null;
        boolean isName = false;
        boolean isRepeating = false;
        String valueInput = null;
        String authorityInput = null;
        int start = 0;
        int limit = 0;
        String collection = null;
        try {
            String sLimit;
            field = this.parameters.getParameter("field");
            value = this.parameters.getParameter("value");
            formID = this.parameters.getParameter("formID");
            confIndicatorID = this.parameters.getParameter("confIndicatorID");
            isName = this.parameters.getParameterAsBoolean("isName", false);
            isRepeating = this.parameters.getParameterAsBoolean("isRepeating", false);
            valueInput = this.parameters.getParameter("valueInput");
            authorityInput = this.parameters.getParameter("authorityInput");
            String sStart = this.parameters.getParameter("start");
            if (sStart != null) {
                start = this.atoi(sStart);
            }
            if ((sLimit = this.parameters.getParameter("limit")) != null) {
                limit = this.atoi(sLimit);
            }
            if ((collection = this.parameters.getParameter("collection")) == null) {
                collection = "-1";
            }
        }
        catch (ParameterException e) {
            throw new UIException("Missing a required parameter", e);
        }
        Division idiv = body.addInteractiveDivision("lookup", "", "get", "popup");
        if (this.isFieldMessage(field, "title")) {
            idiv.setHead(this.getFieldMessage(field, "title"));
        } else {
            idiv.setHead(this.getFieldLabel(field, "title"));
        }
        List fl = idiv.addList("choicesList", "form", "choices-lookup");
        fl.setHead(T_results);
        Item selectItem = fl.addItem("select", "choices-lookup");
        Select s = selectItem.addSelect("chooser", "choices-lookup");
        s.setSize(ConfigurationManager.getIntProperty((String)"xmlui.lookup.select.size", (int)12));
        Hidden h = selectItem.addHidden("paramField");
        h.setValue(field);
        h = selectItem.addHidden("paramValue");
        h.setValue(value);
        h = selectItem.addHidden("paramIsName");
        h.setValue(String.valueOf(isName));
        h = selectItem.addHidden("paramIsRepeating");
        h.setValue(String.valueOf(isRepeating));
        h = selectItem.addHidden("paramValueInput");
        h.setValue(valueInput);
        h = selectItem.addHidden("paramAuthorityInput");
        h.setValue(authorityInput);
        h = selectItem.addHidden("paramStart");
        h.setValue(String.valueOf(start));
        h = selectItem.addHidden("paramLimit");
        h.setValue(String.valueOf(limit));
        h = selectItem.addHidden("paramFormID");
        h.setValue(formID);
        h = selectItem.addHidden("paramConfIndicatorID");
        h.setValue(confIndicatorID);
        h = selectItem.addHidden("paramFail");
        h.setValue(T_fail);
        boolean isClosed = ChoiceAuthorityManager.getManager().isClosed(field);
        h = selectItem.addHidden("paramIsClosed");
        h.setValue(String.valueOf(isClosed));
        h = selectItem.addHidden("paramCollection");
        h.setValue(String.valueOf(collection));
        if (!isClosed) {
            h = selectItem.addHidden("paramNonAuthority");
            if (this.isFieldMessage(field, "nonauthority")) {
                h.setValue(this.getFieldMessage(field, "nonauthority"));
            } else {
                h.setValue(this.getFieldLabel(field, "nonauthority"));
            }
        }
        h = selectItem.addHidden("contextPath");
        h.setValue(this.contextPath);
        Item ti = fl.addItem("textFields", "choices-lookup");
        Composite textItem = ti.addComposite("textFieldsComp", "choices-lookup");
        Text t1 = textItem.addText("text1", "choices-lookup");
        if (isName) {
            Object m;
            Text t2 = textItem.addText("text2", "choices-lookup");
            DCPersonName dp = new DCPersonName(value);
            t1.setValue(dp.getLastName());
            t2.setValue(dp.getFirstNames());
            if (this.isFieldMessage(field, "help.last")) {
                m = this.getFieldMessage(field, "help.last");
                t1.setLabel(m);
                t1.setHelp(m);
            } else {
                m = this.getFieldLabel(field, "help.last");
                t1.setLabel((String)m);
                t1.setHelp((String)m);
            }
            if (this.isFieldMessage(field, "help.first")) {
                m = this.getFieldMessage(field, "help.first");
                t2.setLabel(m);
                t2.setHelp(m);
            } else {
                m = this.getFieldLabel(field, "help.first");
                t2.setLabel((String)m);
                t2.setHelp((String)m);
            }
        } else {
            Object m;
            t1.setValue(value);
            if (this.isFieldMessage(field, "help")) {
                m = this.getFieldMessage(field, "help");
                t1.setLabel(m);
                t1.setHelp(m);
            } else {
                m = this.getFieldLabel(field, "help");
                t1.setLabel((String)m);
                t1.setHelp((String)m);
            }
        }
        Item buttItem = fl.addItem("confirmation", "choices-lookup");
        Button accept = buttItem.addButton("accept", "choices-lookup");
        accept.setValue(isRepeating ? T_add : T_accept);
        Button more = buttItem.addButton("more", "choices-lookup");
        more.setDisabled();
        more.setValue(T_more);
        Button cancel = buttItem.addButton("cancel", "choices-lookup");
        cancel.setValue(T_cancel);
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addMetadata("framing", "popup").addContent("true");
    }

    private boolean isFieldMessage(String field, String name) {
        String cv = this.getFieldLabel(field, name);
        return cv == null || cv.startsWith("xmlui.");
    }

    private String getFieldLabel(String field, String name) {
        return ConfigurationManager.getProperty((String)(CONFIG_PREFIX + field + "." + name));
    }

    private Message getFieldMessage(String field, String name) {
        String cv = this.getFieldLabel(field, name);
        if (cv == null) {
            return ChoiceLookupTransformer.message((String)("xmlui.ChoiceLookupTransformer.field." + field + "." + name));
        }
        return ChoiceLookupTransformer.message((String)cv);
    }

    private int atoi(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

