/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.submission.submit;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.aspect.submission.AbstractSubmissionStep;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.CheckBox;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.LicenseUtils;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.xml.sax.SAXException;

public class LicenseStep
extends AbstractSubmissionStep {
    private static final Logger log = Logger.getLogger(LicenseStep.class);
    protected static final Message T_head = LicenseStep.message((String)"xmlui.Submission.submit.LicenseStep.head");
    protected static final Message T_info1 = LicenseStep.message((String)"xmlui.Submission.submit.LicenseStep.info1");
    protected static final Message T_info2 = LicenseStep.message((String)"xmlui.Submission.submit.LicenseStep.info2");
    protected static final Message T_info3 = LicenseStep.message((String)"xmlui.Submission.submit.LicenseStep.info3");
    protected static final Message T_decision_label = LicenseStep.message((String)"xmlui.Submission.submit.LicenseStep.decision_label");
    protected static final Message T_decision_checkbox = LicenseStep.message((String)"xmlui.Submission.submit.LicenseStep.decision_checkbox");
    protected static final Message T_decision_error = LicenseStep.message((String)"xmlui.Submission.submit.LicenseStep.decision_error");
    protected static final Message T_submit_remove = LicenseStep.message((String)"xmlui.Submission.submit.LicenseStep.submit_remove");
    protected static final Message T_submit_complete = LicenseStep.message((String)"xmlui.Submission.submit.LicenseStep.submit_complete");

    public LicenseStep() {
        this.requireSubmission = true;
        this.requireStep = true;
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Collection collection = this.submission.getCollection();
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/submit/" + this.knot.getId() + ".continue";
        String licenseText = LicenseUtils.getLicenseText((Locale)this.context.getCurrentLocale(), (Collection)collection, (Item)this.submission.getItem(), (EPerson)this.submission.getSubmitter());
        Division div = body.addInteractiveDivision("submit-license", actionURL, "post", "primary submission");
        div.setHead(T_submission_head);
        this.addSubmissionProgressList(div);
        Division inner = div.addDivision("submit-license-inner");
        inner.setHead(T_head);
        inner.addPara(T_info1);
        inner.addPara(T_info2);
        Division displayLicense = inner.addDivision("submit-license-standard-text", "license-text");
        displayLicense.addSimpleHTMLFragment(true, licenseText);
        inner.addPara(T_info3);
        List controls = inner.addList("submit-review", "form");
        CheckBox decision = controls.addItem().addCheckBox("decision");
        decision.setLabel(T_decision_label);
        decision.addOption("accept", T_decision_checkbox);
        if (this.errorFlag == 1) {
            log.info((Object)LogManager.getHeader((Context)this.context, (String)"reject_license", (String)this.submissionInfo.getSubmissionLogInfo()));
            decision.addError(T_decision_error);
        }
        this.addControlButtons(controls);
    }

    @Override
    public List addReviewSection(List reviewList) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        return null;
    }
}

