/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.authorization;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Radio;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Select;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.Group;

public class EditPolicyForm
extends AbstractDSpaceTransformer {
    private static final Message T_title = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.title");
    private static final Message T_trail = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.trail");
    private static final Message T_authorize_trail = EditPolicyForm.message((String)"xmlui.administrative.authorization.general.authorize_trail");
    private static final Message T_policyList_trail = EditPolicyForm.message((String)"xmlui.administrative.authorization.general.policyList_trail");
    private static final Message T_main_head_new = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.main_head_new");
    private static final Message T_main_head_edit = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.main_head_edit");
    private static final Message T_error_no_group = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.error_no_group");
    private static final Message T_error_no_action = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.error_no_action");
    private static final Message T_no_results = EditPolicyForm.message((String)"xmlui.administrative.group.EditGroupForm.no_results");
    private static final Message T_groups_column1 = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.groups_column1");
    private static final Message T_groups_column2 = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.groups_column2");
    private static final Message T_groups_column3 = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.groups_column3");
    private static final Message T_groups_column4 = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.groups_column4");
    private static final Message T_submit_save = EditPolicyForm.message((String)"xmlui.general.save");
    private static final Message T_submit_cancel = EditPolicyForm.message((String)"xmlui.general.cancel");
    private static final Message T_set_group = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.set_group");
    private static final Message T_current_group = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.current_group");
    private static final Message T_groups_head = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.groups_head");
    private static final Message T_policy_currentGroup = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.policy_currentGroup");
    private static final Message T_label_search = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.label_search");
    private static final Message T_submit_search_groups = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.submit_search_groups");
    private static final Message T_label_action = EditPolicyForm.message((String)"xmlui.administrative.authorization.EditPolicyForm.label_action");
    private static final Message T_dspace_home = EditPolicyForm.message((String)"xmlui.general.dspace_home");
    private static final int RESULTS_PER_PAGE = 10;

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrailLink(this.contextPath + "/admin/authorize", T_authorize_trail);
        pageMeta.addTrail().addContent(T_policyList_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException {
        Community dso;
        int objectType = this.parameters.getParameterAsInteger("objectType", -1);
        int objectID = this.parameters.getParameterAsInteger("objectID", -1);
        int policyID = this.parameters.getParameterAsInteger("policyID", -1);
        int groupID = this.parameters.getParameterAsInteger("groupID", -1);
        int actionID = this.parameters.getParameterAsInteger("actionID", -1);
        int page = this.parameters.getParameterAsInteger("page", 0);
        String query = EditPolicyForm.decodeFromURL(this.parameters.getParameter("query", "-1"));
        ResourcePolicy policy = ResourcePolicy.find((Context)this.context, (int)policyID);
        Group currentGroup = groupID != -1 ? Group.find((Context)this.context, (int)groupID) : (policy != null ? policy.getGroup() : null);
        if (policy != null && actionID == -1) {
            actionID = policy.getAction();
        }
        String errorString = this.parameters.getParameter("errors", null);
        ArrayList<String> errors = new ArrayList<String>();
        if (errorString != null) {
            for (String error : errorString.split(",")) {
                errors.add(error);
            }
        }
        switch (objectType) {
            case 4: {
                dso = Community.find((Context)this.context, (int)objectID);
                break;
            }
            case 3: {
                dso = Collection.find((Context)this.context, (int)objectID);
                break;
            }
            case 2: {
                dso = Item.find((Context)this.context, (int)objectID);
                break;
            }
            case 1: {
                dso = Bundle.find((Context)this.context, (int)objectID);
                break;
            }
            case 0: {
                dso = Bitstream.find((Context)this.context, (int)objectID);
                break;
            }
            default: {
                dso = null;
            }
        }
        Division main = body.addInteractiveDivision("edit-policy", this.contextPath + "/admin/authorize", "post", "primary administrative authorization");
        if (policyID >= 0) {
            objectID = policy.getResourceID();
            objectType = policy.getResourceType();
            main.setHead(T_main_head_edit.parameterize(new Object[]{policyID, Constants.typeText[objectType], objectID}));
        } else {
            main.setHead(T_main_head_new.parameterize(new Object[]{Constants.typeText[objectType], objectID}));
        }
        int resourceRelevance = 1 << objectType;
        Division actions = main.addDivision("edit-policy-actions");
        List actionsList = actions.addList("actions", "form");
        actionsList.addLabel(T_label_action);
        org.dspace.app.xmlui.wing.element.Item actionSelectItem = actionsList.addItem();
        Radio actionSelect = actionSelectItem.addRadio("action_id");
        actionSelect.setLabel(T_label_action);
        for (int i = 0; i < Constants.actionText.length; ++i) {
            if ((Constants.actionTypeRelevance[i] & resourceRelevance) <= 0) continue;
            if (actionID == i) {
                actionSelect.addOption(true, i, Constants.actionText[i]);
                continue;
            }
            actionSelect.addOption(i, Constants.actionText[i]);
        }
        if (errors.contains("action_id")) {
            actionSelect.addError(T_error_no_action);
        }
        actionsList.addLabel(T_policy_currentGroup);
        Select groupSelect = actionsList.addItem().addSelect("group_id");
        groupSelect.setSize(5);
        for (Group group : Group.findAll((Context)this.context, (int)1)) {
            if (group == currentGroup) {
                groupSelect.addOption(true, group.getID(), group.getName());
                continue;
            }
            groupSelect.addOption(group.getID(), group.getName());
        }
        if (errors.contains("group_id")) {
            groupSelect.addError(T_error_no_group);
        }
        actionsList.addLabel(T_label_search);
        org.dspace.app.xmlui.wing.element.Item searchItem = actionsList.addItem();
        Text searchText = searchItem.addText("query");
        if (!query.equals("-1")) {
            searchText.setValue(query);
        }
        searchItem.addButton("submit_search_groups").setValue(T_submit_search_groups);
        actionsList.addLabel();
        org.dspace.app.xmlui.wing.element.Item buttons = actionsList.addItem();
        buttons.addButton("submit_save").setValue(T_submit_save);
        buttons.addButton("submit_cancel").setValue(T_submit_cancel);
        if (!query.equals("-1")) {
            Division groupsList = main.addDivision("edit-policy-groupsList");
            groupsList.setHead(T_groups_head);
            this.addGroupSearch(groupsList, currentGroup, (DSpaceObject)dso, query, page);
        }
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    private void addGroupSearch(Division div, Group sourceGroup, DSpaceObject dso, String query, int page) throws WingException, SQLException {
        Group[] groups = Group.search((Context)this.context, (String)query, (int)(page * 10), (int)((page + 1) * 10));
        int totalResults = Group.searchResultCount((Context)this.context, (String)query);
        ArrayList otherPolicies = (ArrayList)AuthorizeManager.getPolicies((Context)this.context, (DSpaceObject)dso);
        if (totalResults > 10) {
            int firstIndex = page * 10 + 1;
            int lastIndex = page * 10 + groups.length;
            String baseURL = this.contextPath + "/admin/authorize?administrative-continue=" + this.knot.getId();
            String nextURL = null;
            String prevURL = null;
            if (page < (totalResults - 1) / 10) {
                nextURL = baseURL + "&page=" + (page + 1);
            }
            if (page > 0) {
                prevURL = baseURL + "&page=" + (page - 1);
            }
            div.setSimplePagination(totalResults, firstIndex, lastIndex, prevURL, nextURL);
        }
        Table table = div.addTable("policy-edit-search-group", groups.length + 1, 1);
        Row header = table.addRow("header");
        header = table.addRow("header");
        header.addCell().addContent(T_groups_column1);
        header.addCell().addContent(T_groups_column2);
        header.addCell().addContent(T_groups_column3);
        header.addCell().addContent(T_groups_column4);
        for (Group group : groups) {
            String groupID = String.valueOf(group.getID());
            String name = group.getName();
            this.url = this.contextPath + "/admin/groups?administrative-continue=" + this.knot.getId() + "&submit_edit_group&group_id=" + groupID;
            Row row = table.addRow();
            row.addCell().addContent(groupID);
            row.addCell().addXref(this.url, name);
            StringBuilder otherAuthorizations = new StringBuilder();
            int groupsMatched = 0;
            for (ResourcePolicy otherPolicy : otherPolicies) {
                if (otherPolicy.getGroup() != group) continue;
                otherAuthorizations.append(otherPolicy.getActionText()).append(", ");
                ++groupsMatched;
            }
            if (groupsMatched > 0) {
                row.addCell().addContent(otherAuthorizations.substring(0, otherAuthorizations.lastIndexOf(", ")));
            } else {
                row.addCell().addContent("-");
            }
            if (group != sourceGroup) {
                row.addCell().addButton("submit_group_id_" + groupID).setValue(T_set_group);
                continue;
            }
            row.addCell().addContent(T_current_group);
        }
        if (groups.length <= 0) {
            table.addRow().addCell(1, 4).addContent(T_no_results);
        }
    }
}

