/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.artifactbrowser;

import java.io.IOException;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.HashUtil;
import org.apache.excalibur.source.SourceValidity;
import org.apache.log4j.Logger;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.utils.DSpaceValidity;
import org.dspace.app.xmlui.utils.UIException;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Reference;
import org.dspace.app.xmlui.wing.element.ReferenceSet;
import org.dspace.authorize.AuthorizeException;
import org.dspace.browse.ItemCountException;
import org.dspace.browse.ItemCounter;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.xml.sax.SAXException;

public class CommunityBrowser
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static Logger log = Logger.getLogger(CommunityBrowser.class);
    public static final Message T_dspace_home = CommunityBrowser.message((String)"xmlui.general.dspace_home");
    public static final Message T_title = CommunityBrowser.message((String)"xmlui.ArtifactBrowser.CommunityBrowser.title");
    public static final Message T_trail = CommunityBrowser.message((String)"xmlui.ArtifactBrowser.CommunityBrowser.trail");
    public static final Message T_head = CommunityBrowser.message((String)"xmlui.ArtifactBrowser.CommunityBrowser.head");
    public static final Message T_select = CommunityBrowser.message((String)"xmlui.ArtifactBrowser.CommunityBrowser.select");
    protected boolean excludeCollections = false;
    private static final int DEFAULT_DEPTH = 999;
    protected int depth = 999;
    protected TreeNode root;
    private SourceValidity validity;

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.depth = parameters.getParameterAsInteger("depth", 999);
        this.excludeCollections = parameters.getParameterAsBoolean("exclude-collections", false);
    }

    public Serializable getKey() {
        boolean full = ConfigurationManager.getBooleanProperty((String)"xmlui.community-list.render.full", (boolean)true);
        return Long.valueOf(HashUtil.hash((String)(this.depth + "-" + this.excludeCollections + "-" + (full ? "true" : "false"))));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            try {
                DSpaceValidity validity = new DSpaceValidity();
                TreeNode root = this.buildTree(Community.findAllTop((Context)this.context));
                Stack<TreeNode> stack = new Stack<TreeNode>();
                stack.push(root);
                while (!stack.empty()) {
                    TreeNode node = (TreeNode)stack.pop();
                    validity.add(node.getDSO());
                    boolean useCache = ConfigurationManager.getBooleanProperty((String)"webui.strengths.cache");
                    if (useCache) {
                        try {
                            int size = new ItemCounter(this.context).getCount(node.getDSO());
                            validity.add("size:" + size);
                        }
                        catch (ItemCountException e) {
                            // empty catch block
                        }
                    }
                    for (TreeNode child : node.getChildren()) {
                        stack.push(child);
                    }
                }
                String assumeCacheValidity = ConfigurationManager.getProperty((String)"xmlui.community-list.cache");
                if (assumeCacheValidity != null) {
                    validity.setAssumedValidityDelay(assumeCacheValidity);
                }
                this.validity = validity.complete();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            log.info((Object)LogManager.getHeader((Context)this.context, (String)"view_community_list", (String)""));
        }
        return this.validity;
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws SAXException, WingException, UIException, SQLException, IOException, AuthorizeException {
        Division division = body.addDivision("comunity-browser", "primary");
        division.setHead(T_head);
        division.addPara(T_select);
        TreeNode root = this.buildTree(Community.findAllTop((Context)this.context));
        boolean full = ConfigurationManager.getBooleanProperty((String)"xmlui.community-list.render.full", (boolean)true);
        if (full) {
            ReferenceSet referenceSet = division.addReferenceSet("community-browser", "summaryList", null, "hierarchy");
            List<TreeNode> rootNodes = root.getChildrenOfType(4);
            for (TreeNode node : rootNodes) {
                this.buildReferenceSet(referenceSet, node);
            }
        } else {
            org.dspace.app.xmlui.wing.element.List list = division.addList("comunity-browser");
            List<TreeNode> rootNodes = root.getChildrenOfType(4);
            for (TreeNode node : rootNodes) {
                this.buildList(list, node);
            }
        }
    }

    public void buildReferenceSet(ReferenceSet referenceSet, TreeNode node) throws WingException {
        List<TreeNode> communityNodes;
        DSpaceObject dso = node.getDSO();
        Reference objectInclude = referenceSet.addReference((Object)dso);
        List<TreeNode> collectionNodes = node.getChildrenOfType(3);
        if (collectionNodes != null && collectionNodes.size() > 0) {
            ReferenceSet collectionSet = objectInclude.addReferenceSet("summaryList");
            for (TreeNode collectionNode : collectionNodes) {
                collectionSet.addReference((Object)collectionNode.getDSO());
            }
        }
        if ((communityNodes = node.getChildrenOfType(4)) != null && communityNodes.size() > 0) {
            ReferenceSet communitySet = objectInclude.addReferenceSet("summaryList");
            for (TreeNode communityNode : communityNodes) {
                this.buildReferenceSet(communitySet, communityNode);
            }
        }
    }

    public void buildList(org.dspace.app.xmlui.wing.element.List list, TreeNode node) throws WingException {
        List<TreeNode> communityNodes;
        DSpaceObject dso = node.getDSO();
        String name = null;
        if (dso instanceof Community) {
            name = ((Community)dso).getMetadata("name");
        } else if (dso instanceof Collection) {
            name = ((Collection)dso).getMetadata("name");
        }
        String url = this.contextPath + "/handle/" + dso.getHandle();
        list.addItem().addHighlight("bold").addXref(url, name);
        org.dspace.app.xmlui.wing.element.List subList = null;
        List<TreeNode> collectionNodes = node.getChildrenOfType(3);
        if (collectionNodes != null && collectionNodes.size() > 0) {
            subList = list.addList("sub-list-" + dso.getID());
            for (TreeNode collectionNode : collectionNodes) {
                String collectionName = ((Collection)collectionNode.getDSO()).getMetadata("name");
                String collectionUrl = this.contextPath + "/handle/" + collectionNode.getDSO().getHandle();
                subList.addItemXref(collectionUrl, collectionName);
            }
        }
        if ((communityNodes = node.getChildrenOfType(4)) != null && communityNodes.size() > 0) {
            if (subList == null) {
                subList = list.addList("sub-list-" + dso.getID());
            }
            for (TreeNode communityNode : communityNodes) {
                this.buildList(subList, communityNode);
            }
        }
    }

    @Override
    public void recycle() {
        this.root = null;
        this.validity = null;
        super.recycle();
    }

    private TreeNode buildTree(Community[] communities) throws SQLException {
        if (this.root != null) {
            return this.root;
        }
        TreeNode newRoot = new TreeNode();
        Stack<TreeNode> stack = new Stack<TreeNode>();
        for (Community community : communities) {
            stack.push(newRoot.addChild((DSpaceObject)community));
        }
        while (!stack.empty()) {
            TreeNode node = (TreeNode)stack.pop();
            if (node.getLevel() >= this.depth) continue;
            Community community = (Community)node.getDSO();
            for (Community community2 : community.getSubcommunities()) {
                stack.push(node.addChild((DSpaceObject)community2));
            }
            if (this.excludeCollections) continue;
            for (Community community3 : community.getCollections()) {
                node.addChild((DSpaceObject)community3);
            }
        }
        this.root = newRoot;
        return this.root;
    }

    protected static class TreeNode {
        private DSpaceObject dso;
        private int level = 0;
        private List<TreeNode> children = new ArrayList<TreeNode>();

        public DSpaceObject getDSO() {
            return this.dso;
        }

        public TreeNode addChild(DSpaceObject dso) {
            TreeNode child = new TreeNode();
            child.dso = dso;
            child.level = this.level + 1;
            this.children.add(child);
            return child;
        }

        public int getLevel() {
            return this.level;
        }

        public List<TreeNode> getChildren() {
            return this.children;
        }

        public List<TreeNode> getChildrenOfType(int type) {
            ArrayList<TreeNode> results = new ArrayList<TreeNode>();
            for (TreeNode node : this.children) {
                if (node.dso.getType() != type) continue;
                results.add(node);
            }
            return results;
        }
    }
}

