/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.xmlworkflow.actions.processingaction;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.dspace.app.xmlui.aspect.xmlworkflow.AbstractXMLUIAction;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.app.xmlui.wing.element.Text;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.eperson.EPerson;
import org.xml.sax.SAXException;

public class SelectReviewerAction
extends AbstractXMLUIAction {
    private static final Message T_HEAD = SelectReviewerAction.message((String)"xmlui.XMLWorkflow.workflow.SelectReviewerAction.head");
    private static final Message T_epeople_column1 = SelectReviewerAction.message((String)"xmlui.administrative.group.EditGroupForm.epeople_column1");
    private static final Message T_epeople_column2 = SelectReviewerAction.message((String)"xmlui.administrative.group.EditGroupForm.epeople_column2");
    private static final Message T_epeople_column3 = SelectReviewerAction.message((String)"xmlui.administrative.group.EditGroupForm.epeople_column3");
    private static final Message T_epeople_column4 = SelectReviewerAction.message((String)"xmlui.administrative.group.EditGroupForm.epeople_column4");
    protected static final Message T_submit_cancel = SelectReviewerAction.message((String)"xmlui.general.cancel");
    private static final Message T_search_reviewer_label = SelectReviewerAction.message((String)"xmlui.XMLWorkflow.workflow.SelectReviewerAction.search.label");
    private static final Message T_search_reviewer_button = SelectReviewerAction.message((String)"xmlui.XMLWorkflow.workflow.SelectReviewerAction.search.button");
    private static final Message T_select_reviewer_button = SelectReviewerAction.message((String)"xmlui.XMLWorkflow.workflow.SelectReviewerAction.select-reviewer.button");
    private static final Message T_task_help = SelectReviewerAction.message((String)"xmlui.XMLWorkflow.workflow.SelectReviewerAction.help");

    @Override
    public void addBody(Body body) throws SAXException, WingException, SQLException, IOException, AuthorizeException {
        Item item = this.workflowItem.getItem();
        Collection collection = this.workflowItem.getCollection();
        Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
        String actionURL = this.contextPath + "/handle/" + collection.getHandle() + "/xmlworkflow";
        Division viewItemDiv = body.addInteractiveDivision("view-item", actionURL, "post", "primary workflow");
        viewItemDiv.setHead(T_HEAD);
        this.addWorkflowItemInformation(viewItemDiv, item, request);
        viewItemDiv.addHidden("submission-continue").setValue(this.knot.getId());
        Division actionsDiv = body.addInteractiveDivision("perform-task", actionURL, "post", "primary workflow");
        actionsDiv.addPara().addContent(T_task_help);
        Para selectUserPara = actionsDiv.addPara();
        selectUserPara.addContent(T_search_reviewer_label);
        Text queryBox = selectUserPara.addText("query");
        if (request.getParameter("query") != null) {
            queryBox.setValue(request.getParameter("query"));
        }
        selectUserPara.addButton("submit_search").setValue(T_search_reviewer_button);
        int page = 0;
        if (request.getAttribute("page") != null) {
            page = Integer.parseInt(request.getAttribute("page").toString());
        }
        if (page == 1) {
            this.renderSearchResults(request, actionURL, actionsDiv);
        }
        Para actionsPara = actionsDiv.addPara();
        actionsPara.addButton("submit_cancel").setValue(T_submit_cancel);
        actionsDiv.addHidden("submission-continue").setValue(this.knot.getId());
    }

    private void renderSearchResults(Request request, String actionUrl, Division div) throws WingException {
        EPerson[] epeople = (EPerson[])request.getAttribute("eperson-results");
        int resultCount = (Integer)request.getAttribute("eperson-result-count");
        int page = (Integer)request.getAttribute("result-page");
        Division results = div.addDivision("results");
        if (resultCount > 5) {
            String baseURL = actionUrl + "?submission-continue=" + this.knot.getId() + "&submit_search=search";
            baseURL = baseURL + "&query=" + request.getParameter("query");
            int firstIndex = page * 5 + 1;
            int lastIndex = page * 5 + epeople.length;
            String nextURL = null;
            String prevURL = null;
            if (page < resultCount / 5) {
                nextURL = baseURL + "&result-page=" + (page + 1);
            }
            if (page > 0) {
                prevURL = baseURL + "&result-page=" + (page - 1);
            }
            results.setSimplePagination(resultCount, firstIndex, lastIndex, prevURL, nextURL);
        }
        Table table = results.addTable("group-edit-search-eperson", epeople.length + 1, 1);
        Row header = table.addRow("header");
        header.addCell().addContent(T_epeople_column1);
        header.addCell().addContent(T_epeople_column2);
        header.addCell().addContent(T_epeople_column3);
        header.addCell().addContent(T_epeople_column4);
        for (EPerson person : epeople) {
            String epersonID = String.valueOf(person.getID());
            String fullName = person.getFullName();
            String email = person.getEmail();
            Row personData = table.addRow();
            personData.addCell().addContent(person.getID());
            personData.addCell().addContent(fullName);
            personData.addCell().addContent(email);
            personData.addCell().addButton("submit_select_reviewer_" + epersonID).setValue(T_select_reviewer_button);
        }
    }
}

