/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.cocoon;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.Map;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.cocoon.util.HashUtil;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.ExpiresValidity;
import org.dspace.app.util.OpenSearch;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.app.xmlui.utils.FeedUtils;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.search.DSQuery;
import org.dspace.search.QueryArgs;
import org.dspace.search.QueryResults;
import org.dspace.sort.SortOption;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class OpenSearchGenerator
extends AbstractGenerator
implements CacheableProcessingComponent,
Recyclable {
    private ExpiresValidity validity = null;
    private String format = null;
    private String query = null;
    private String scope = null;
    private int sort = 0;
    private String sortOrder = null;
    private int rpp = 0;
    private int start = 0;
    private String type = null;
    private Document resultsDoc = null;

    public Serializable getKey() {
        StringBuffer key = new StringBuffer("key:");
        if (this.scope != null) {
            key.append(this.scope);
        }
        key.append(this.query);
        if (this.format != null) {
            key.append(this.format);
        }
        key.append(this.sort);
        key.append(this.start);
        key.append(this.rpp);
        key.append(this.sortOrder);
        return Long.valueOf(HashUtil.hash((String)key.toString()));
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            long expiry = System.currentTimeMillis() + ConfigurationManager.getLongProperty((String)"websvc.opensearch.validity") * 60L * 60L * 1000L;
            this.validity = new ExpiresValidity(expiry);
        }
        return this.validity;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        this.query = request.getParameter("query");
        if (this.query == null) {
            this.query = "";
        }
        this.query = URLDecoder.decode(this.query, "UTF-8");
        this.format = request.getParameter("format");
        if (this.format == null || this.format.length() == 0) {
            this.format = "atom";
        }
        this.scope = request.getParameter("scope");
        String srt = request.getParameter("sort_by");
        this.sort = srt == null || srt.length() == 0 ? 0 : Integer.valueOf(srt);
        String order = request.getParameter("order");
        this.sortOrder = order == null || order.length() == 0 || order.toLowerCase().startsWith("asc") ? "ASC" : "DESC";
        String st = request.getParameter("start");
        this.start = st == null || st.length() == 0 ? 0 : Integer.valueOf(st);
        String pp = request.getParameter("rpp");
        this.rpp = pp == null || pp.length() == 0 ? 0 : Integer.valueOf(pp);
        try {
            this.type = par.getParameter("type");
        }
        catch (ParameterException e) {
            this.type = "results";
        }
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Document retDoc = null;
        try {
            if (this.type != null && this.type.equals("description")) {
                retDoc = OpenSearch.getDescriptionDoc((String)this.scope);
            } else if (this.resultsDoc != null) {
                retDoc = this.resultsDoc;
            } else {
                Context context = ContextUtil.obtainContext(this.objectModel);
                QueryArgs qArgs = new QueryArgs();
                if (this.start < 0) {
                    this.start = 0;
                }
                qArgs.setStart(this.start);
                if (this.rpp > 0) {
                    qArgs.setPageSize(this.rpp);
                }
                qArgs.setSortOrder(this.sortOrder);
                if (this.sort > 0) {
                    try {
                        qArgs.setSortOption(SortOption.getSortOption((int)this.sort));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                qArgs.setSortOrder(this.sortOrder);
                DSpaceObject container = null;
                if (this.scope != null && !this.scope.equals("")) {
                    container = HandleManager.resolveToObject((Context)context, (String)this.scope);
                }
                qArgs.setQuery(this.query);
                QueryResults qResults = null;
                if (container == null) {
                    qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs);
                } else if (container instanceof Collection) {
                    qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Collection)((Collection)container));
                } else if (container instanceof Community) {
                    qResults = DSQuery.doQuery((Context)context, (QueryArgs)qArgs, (Community)((Community)container));
                } else {
                    throw new IllegalStateException("Invalid container for search context");
                }
                DSpaceObject[] results = new DSpaceObject[qResults.getHitHandles().size()];
                for (int i = 0; i < qResults.getHitHandles().size(); ++i) {
                    String myHandle = (String)qResults.getHitHandles().get(i);
                    DSpaceObject dso = HandleManager.resolveToObject((Context)context, (String)myHandle);
                    if (dso == null) {
                        throw new SQLException("Query \"" + this.query + "\" returned unresolvable handle: " + myHandle);
                    }
                    results[i] = dso;
                }
                this.resultsDoc = OpenSearch.getResultsDoc((String)this.format, (String)this.query, (QueryResults)qResults, (DSpaceObject)container, (DSpaceObject[])results, FeedUtils.i18nLabels);
                FeedUtils.unmangleI18N(this.resultsDoc);
                retDoc = this.resultsDoc;
            }
            if (retDoc != null) {
                DOMStreamer streamer = new DOMStreamer(this.contentHandler, this.lexicalHandler);
                streamer.stream((Node)retDoc);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        catch (SQLException sqle) {
            throw new SAXException(sqle);
        }
    }

    public void recycle() {
        this.format = null;
        this.query = null;
        this.scope = null;
        this.sort = 0;
        this.rpp = 0;
        this.start = 0;
        this.type = null;
        this.sortOrder = null;
        this.resultsDoc = null;
        this.validity = null;
        super.recycle();
    }
}

