/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.eperson;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.dspace.app.xmlui.aspect.eperson.EPersonUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.Item;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Text;
import org.xml.sax.SAXException;

public class StartRegistration
extends AbstractDSpaceTransformer
implements CacheableProcessingComponent {
    private static final Message T_title = StartRegistration.message((String)"xmlui.EPerson.StartRegistration.title");
    private static final Message T_dspace_home = StartRegistration.message((String)"xmlui.general.dspace_home");
    private static final Message T_trail_new_registration = StartRegistration.message((String)"xmlui.EPerson.trail_new_registration");
    private static final Message T_head1 = StartRegistration.message((String)"xmlui.EPerson.StartRegistration.head1");
    private static final Message T_para1 = StartRegistration.message((String)"xmlui.EPerson.StartRegistration.para1");
    private static final Message T_reset_password_for = StartRegistration.message((String)"xmlui.EPerson.StartRegistration.reset_password_for");
    private static final Message T_submit_reset = StartRegistration.message((String)"xmlui.EPerson.StartRegistration.submit_reset");
    private static final Message T_head2 = StartRegistration.message((String)"xmlui.EPerson.StartRegistration.head2");
    private static final Message T_para2 = StartRegistration.message((String)"xmlui.EPerson.StartRegistration.para2");
    private static final Message T_email_address = StartRegistration.message((String)"xmlui.EPerson.StartRegistration.email_address");
    private static final Message T_email_address_help = StartRegistration.message((String)"xmlui.EPerson.StartRegistration.email_address_help");
    private static final Message T_error_bad_email = StartRegistration.message((String)"xmlui.EPerson.StartRegistration.error_bad_email");
    private static final Message T_submit_register = StartRegistration.message((String)"xmlui.EPerson.StartRegistration.submit_register");
    private String email;
    private List<String> errors;
    private boolean accountExists;

    @Override
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        this.email = parameters.getParameter("email", "");
        this.accountExists = parameters.getParameterAsBoolean("accountExists", false);
        String errors = parameters.getParameter("errors", "");
        this.errors = errors.length() > 0 ? Arrays.asList(errors.split(",")) : new ArrayList<String>();
    }

    public Serializable getKey() {
        if (this.email == null && !this.accountExists && this.errors != null && this.errors.size() == 0) {
            return "1";
        }
        return "0";
    }

    public SourceValidity getValidity() {
        if (this.email == null && !this.accountExists && this.errors != null && this.errors.size() == 0) {
            return NOPValidity.SHARED_INSTANCE;
        }
        return null;
    }

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_trail_new_registration);
    }

    @Override
    public void addBody(Body body) throws WingException {
        org.dspace.app.xmlui.wing.element.List form;
        if (this.accountExists) {
            Division exists = body.addInteractiveDivision("register-account-exists", this.contextPath + "/register", "post", "primary");
            exists.setHead(T_head1);
            exists.addPara(T_para1);
            form = exists.addList("form");
            form.addLabel(T_reset_password_for);
            form.addItem(this.email);
            form.addLabel();
            Item submit = form.addItem();
            submit.addButton("submit_forgot").setValue(T_submit_reset);
            exists.addHidden("email").setValue(this.email);
            exists.addHidden("eperson-continue").setValue(this.knot.getId());
        }
        Division register = body.addInteractiveDivision("register", this.contextPath + "/register", "post", "primary");
        register.setHead(T_head2);
        EPersonUtils.registrationProgressList(register, 1);
        register.addPara(T_para2);
        form = register.addList("form", "form");
        Text email = form.addItem().addText("email");
        email.setRequired();
        email.setLabel(T_email_address);
        email.setHelp(T_email_address_help);
        email.setValue(this.email);
        if (this.errors.contains("email")) {
            email.addError(T_error_bad_email);
        }
        Item submit = form.addItem();
        submit.addButton("submit").setValue(T_submit_register);
        register.addHidden("eperson-continue").setValue(this.knot.getId());
    }

    @Override
    public void recycle() {
        this.email = null;
        this.errors = null;
        super.recycle();
    }
}

