/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.utils;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RequestInfo {
    private final String authType;
    private final String contextPath;
    private final String method;
    private final String pathInfo;
    private final String pathTranslated;
    private final String queryString;
    private final String requestURI;
    private final StringBuffer requestURL;
    private final String servletPath;
    private final String scheme;
    private final boolean secure;
    private final Map<String, String[]> parameters;

    public RequestInfo(HttpServletRequest request) {
        this.authType = request.getAuthType();
        this.contextPath = request.getContextPath();
        this.method = request.getMethod();
        this.pathInfo = request.getPathInfo();
        this.pathTranslated = request.getPathTranslated();
        this.queryString = request.getQueryString();
        this.requestURI = request.getRequestURI();
        this.requestURL = request.getRequestURL();
        this.servletPath = request.getServletPath();
        this.scheme = request.getScheme();
        this.secure = request.isSecure();
        this.parameters = new HashMap<String, String[]>();
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String[] values = request.getParameterValues(key);
            this.parameters.put(key, values);
        }
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getActualPath() {
        return this.pathInfo + (this.queryString == null || this.queryString.length() == 0 ? "" : "?" + this.queryString);
    }

    public HttpServletRequest wrapRequest(HttpServletRequest request) {
        return new RequestWrapper(request);
    }

    class RequestWrapper
    extends HttpServletRequestWrapper {
        public RequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getAuthType() {
            return RequestInfo.this.authType;
        }

        public String getContextPath() {
            return RequestInfo.this.contextPath;
        }

        public String getMethod() {
            return RequestInfo.this.method;
        }

        public String getPathInfo() {
            return RequestInfo.this.pathInfo;
        }

        public String getPathTranslated() {
            return RequestInfo.this.pathTranslated;
        }

        public String getQueryString() {
            return RequestInfo.this.queryString;
        }

        public String getRequestURI() {
            return RequestInfo.this.requestURI;
        }

        public StringBuffer getRequestURL() {
            return RequestInfo.this.requestURL;
        }

        public String getServletPath() {
            return RequestInfo.this.servletPath;
        }

        public String getParameter(String arg0) {
            String[] values = (String[])RequestInfo.this.parameters.get(arg0);
            if (values == null || values.length == 0) {
                return null;
            }
            return values[0];
        }

        public Map getParameterMap() {
            return RequestInfo.this.parameters;
        }

        public Enumeration getParameterNames() {
            Iterator parameterIterator = RequestInfo.this.parameters.keySet().iterator();
            return new EnumIterator(parameterIterator);
        }

        public String[] getParameterValues(String arg0) {
            return (String[])RequestInfo.this.parameters.get(arg0);
        }

        public String getScheme() {
            return RequestInfo.this.scheme;
        }

        public boolean isSecure() {
            return RequestInfo.this.secure;
        }

        class EnumIterator
        implements Enumeration {
            private Iterator iterator;

            public EnumIterator(Iterator i) {
                this.iterator = i;
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            public Object nextElement() {
                return this.iterator.next();
            }
        }
    }
}

