/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.maven.reports;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.siterenderer.Renderer;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;

public class I18nReport
extends AbstractMavenReport {
    private File outputDirectory;
    private Renderer siteRenderer;
    private MavenProject project;
    private ArtifactFactory artifactFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeReport(Locale arg0) throws MavenReportException {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader contextClassloader = this.getClassLoader(currentClassLoader);
            ResourceBundle messages = ResourceBundle.getBundle("Messages", Locale.getDefault(), contextClassloader);
            Sink sink = this.getSink();
            Locale[] locales = I18nReport.getExistingLocales(contextClassloader, "Messages");
            for (int i = 0; i < locales.length; ++i) {
                ResourceBundle localeRB = ResourceBundle.getBundle("Messages", locales[i], contextClassloader);
                if (localeRB.getLocale().equals(messages.getLocale())) continue;
                sink.section1();
                sink.sectionTitle();
                sink.text(localeRB.getLocale().getDisplayName());
                sink.sectionTitle_();
                sink.table();
                sink.tableRow();
                sink.tableHeaderCell();
                sink.text("Key");
                sink.tableHeaderCell_();
                sink.tableHeaderCell();
                sink.text("English Value");
                sink.tableHeaderCell_();
                sink.tableHeaderCell();
                sink.text("Correction");
                sink.tableHeaderCell_();
                sink.tableRow_();
                Enumeration<String> e = messages.getKeys();
                while (e.hasMoreElements()) {
                    String localValue;
                    String key = e.nextElement();
                    String value = messages.getString(key);
                    if (!value.equals(localValue = localeRB.getString(key))) continue;
                    sink.tableRow();
                    sink.tableCell();
                    sink.text(key);
                    sink.tableCell_();
                    sink.tableCell();
                    sink.text(localValue);
                    sink.tableCell_();
                    sink.tableCell();
                    sink.rawText("<input type='text' name='" + localeRB.getLocale() + key + "'/>");
                    sink.tableCell_();
                    sink.tableRow_();
                }
                sink.table_();
                sink.section1_();
            }
        }
        catch (MojoExecutionException e) {
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public static Locale[] getExistingLocales(ClassLoader loader, String baseName) {
        Locale[] locales = Locale.getAvailableLocales();
        TreeSet<Locale> existing = new TreeSet<Locale>(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (arg0 instanceof Locale && arg1 instanceof Locale) {
                    return ((Locale)arg0).getDisplayName().compareTo(((Locale)arg1).getDisplayName());
                }
                return arg0.toString().compareTo(arg1.toString());
            }
        });
        existing.add(new Locale(""));
        String bundleName = null;
        String localeSuffix = null;
        Locale l = null;
        for (int i = 0; i < locales.length; ++i) {
            l = locales[i];
            bundleName = baseName;
            localeSuffix = l.toString();
            if (localeSuffix.length() > 0) {
                bundleName = bundleName + "_" + localeSuffix;
            } else if (locales[i].getVariant().length() > 0) {
                bundleName = bundleName + "___" + locales[i].getVariant();
            }
            if (!I18nReport.verifyBundle(loader, bundleName)) continue;
            existing.add(locales[i]);
        }
        return existing.toArray(new Locale[1]);
    }

    private static boolean verifyBundle(final ClassLoader loader, String bundleName) {
        try {
            Class<?> bundleClass = loader != null ? loader.loadClass(bundleName) : Class.forName(bundleName);
            if (ResourceBundle.class.isAssignableFrom(bundleClass)) {
                return true;
            }
        }
        catch (Exception e) {
        }
        catch (LinkageError e) {
            // empty catch block
        }
        final String resName = bundleName.replace('.', '/') + ".properties";
        Object result = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (loader != null) {
                    return loader.getResource(resName);
                }
                return ClassLoader.getSystemResource(resName);
            }
        });
        return result != null;
    }

    public String getOutputName() {
        return "i18n/index";
    }

    public String getName(Locale arg0) {
        return "I18N Properties report";
    }

    public String getDescription(Locale arg0) {
        return "Report on the missing I18N properties.";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    public Renderer getSiteRenderer() {
        return this.siteRenderer;
    }

    protected MavenProject getProject() {
        return this.project;
    }

    private ClassLoader getClassLoader(ClassLoader parent) throws MojoExecutionException {
        ArrayList classpathURLs = new ArrayList();
        this.addRelevantProjectDependenciesToClasspath(classpathURLs);
        return new URLClassLoader(classpathURLs.toArray(new URL[classpathURLs.size()]), parent);
    }

    private void addRelevantProjectDependenciesToClasspath(List path) throws MojoExecutionException {
        try {
            this.getLog().debug((CharSequence)"Project Dependencies will be included.");
            URL mainClasses = new File(this.project.getBuild().getOutputDirectory()).toURL();
            this.getLog().debug((CharSequence)("Adding to classpath : " + mainClasses));
            path.add(mainClasses);
            Set dependencies = this.project.getArtifacts();
            dependencies.addAll(this.getSystemScopeDependencies());
            for (Artifact classPathElement : dependencies) {
                this.getLog().debug((CharSequence)("Adding project dependency artifact: " + classPathElement.getArtifactId() + " to classpath"));
                path.add(classPathElement.getFile().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error during setting up classpath", (Exception)e);
        }
    }

    private Collection getSystemScopeDependencies() throws MojoExecutionException {
        ArrayList<Artifact> systemScopeArtifacts = new ArrayList<Artifact>();
        for (Artifact artifact : this.getAllDependencies()) {
            if (!artifact.getScope().equals("system")) continue;
            systemScopeArtifacts.add(artifact);
        }
        return systemScopeArtifacts;
    }

    private Collection getAllDependencies() throws MojoExecutionException {
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Dependency dependency : this.project.getDependencies()) {
            VersionRange versionRange;
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            try {
                versionRange = VersionRange.createFromVersionSpec((String)dependency.getVersion());
            }
            catch (InvalidVersionSpecificationException e) {
                throw new MojoExecutionException("unable to parse version", (Exception)((Object)e));
            }
            String type = dependency.getType();
            if (type == null) {
                type = "jar";
            }
            String classifier = dependency.getClassifier();
            boolean optional = dependency.isOptional();
            String scope = dependency.getScope();
            if (scope == null) {
                scope = "compile";
            }
            Artifact art = this.artifactFactory.createDependencyArtifact(groupId, artifactId, versionRange, type, classifier, scope, optional);
            if (scope.equalsIgnoreCase("system")) {
                art.setFile(new File(dependency.getSystemPath()));
            }
            ArrayList<String> exclusions = new ArrayList<String>();
            for (Exclusion e : dependency.getExclusions()) {
                exclusions.add(e.getGroupId() + ":" + e.getArtifactId());
            }
            ExcludesArtifactFilter newFilter = new ExcludesArtifactFilter(exclusions);
            art.setDependencyFilter((ArtifactFilter)newFilter);
            artifacts.add(art);
        }
        return artifacts;
    }
}

