/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.packager.IMSCPManifest;
import org.dspace.content.packager.PackageDisseminator;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public abstract class AbstractIMSCPDisseminator
implements PackageDisseminator {
    private static Logger log = Logger.getLogger(AbstractIMSCPDisseminator.class);

    public void disseminate(Context context, DSpaceObject dso, PackageParameters params, OutputStream pkg) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException {
        ZipOutputStream zip;
        if (dso.getType() == 2) {
            IMSCPManifest manifest = null;
            try {
                manifest = (IMSCPManifest)this.getManifestClass().newInstance();
            }
            catch (Exception e) {
                throw new PackageException((Throwable)e);
            }
            Item item = (Item)dso;
            zip = new ZipOutputStream(pkg);
            zip.setComment("IMSCP package created by DSpace for item " + item.getHandle());
            ZipEntry me = new ZipEntry("imsmanifest.xml");
            zip.putNextEntry(me);
            BitstreamFormat mbsf = manifest.getManifestBitstreamFormat(context);
            Bitstream manifestBs = null;
            if (mbsf != null) {
                manifestBs = PackageUtils.getBitstreamByFormat((Item)item, (BitstreamFormat)mbsf, (String)"METADATA");
            }
            if (manifestBs == null) {
                Document manifestDoc = this.makeManifest(context, item, params);
                XMLOutputter outputPretty = new XMLOutputter(Format.getPrettyFormat());
                outputPretty.output(manifestDoc, (OutputStream)zip);
            } else {
                Utils.copy((InputStream)manifestBs.retrieve(), (OutputStream)zip);
            }
            zip.closeEntry();
            Bundle[] bundles = item.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                if (!bundles[i].getName().equals("ORIGINAL") && !bundles[i].getName().equals("METADATA")) continue;
                Bitstream[] bitstreams = bundles[i].getBitstreams();
                for (int k = 0; k < bitstreams.length; ++k) {
                    String zname = bitstreams[k].getName();
                    if (zname.equals("imsmanifest.xml")) continue;
                    ZipEntry ze = new ZipEntry(zname);
                    ze.setSize(bitstreams[k].getSize());
                    zip.putNextEntry(ze);
                    Utils.copy((InputStream)bitstreams[k].retrieve(), (OutputStream)zip);
                    zip.closeEntry();
                }
            }
        } else {
            throw new PackageValidationException("Can only disseminate an Item now.");
        }
        zip.close();
    }

    public String getMIMEType(PackageParameters params) {
        return params != null && params.getProperty("metadataOnly") != null ? "text/xml" : "application/zip";
    }

    public abstract Document makeManifest(Context var1, Item var2, PackageParameters var3) throws PackageException;

    public abstract Class getManifestClass();
}

