/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.packager.IMSCPManifest;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public abstract class AbstractIMSCPIngester
implements PackageIngester {
    private static Logger log = Logger.getLogger(AbstractIMSCPIngester.class);
    private static final boolean validateDefault = false;

    public WorkspaceItem ingest(Context context, Collection collection, InputStream pkg, PackageParameters params, String license) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException {
        ZipInputStream zip = new ZipInputStream(pkg);
        HashMap fileIdToBitstream = new HashMap();
        WorkspaceItem wi = null;
        boolean success = false;
        HashSet<String> packageFiles = new HashSet<String>();
        boolean validate = params.getBooleanProperty("validate", false);
        try {
            Iterator mi;
            StringBuffer msg;
            ZipEntry ze;
            IMSCPManifest manifest = null;
            try {
                manifest = (IMSCPManifest)this.getManifestClass().newInstance();
            }
            catch (Exception e) {
                throw new PackageException((Throwable)e);
            }
            wi = WorkspaceItem.create((Context)context, (Collection)collection, (boolean)false);
            Item item = wi.getItem();
            Bundle contentBundle = item.createBundle("ORIGINAL");
            Bundle mdBundle = item.createBundle("METADATA");
            while ((ze = zip.getNextEntry()) != null) {
                if (ze.isDirectory()) continue;
                Bitstream bs = null;
                String fname = ze.getName();
                if (fname.equals("imsmanifest.xml")) {
                    bs = mdBundle.createBitstream((InputStream)new PackageUtils.UnclosableInputStream((InputStream)zip));
                    bs.setName(fname);
                    bs.setFormat(manifest.getManifestBitstreamFormat(context));
                    manifest.parse(bs.retrieve(), validate);
                } else {
                    bs = contentBundle.createBitstream((InputStream)new PackageUtils.UnclosableInputStream((InputStream)zip));
                    bs.setName(fname);
                    bs.setFormat(FormatIdentifier.guessFormat((Context)context, (Bitstream)bs));
                }
                packageFiles.add(fname);
                bs.setSource(fname);
                bs.update();
            }
            zip.close();
            manifest.checkManifest();
            HashSet<String> missingFiles = new HashSet<String>();
            for (String path : manifest.getContentFiles()) {
                if (packageFiles.contains(path)) {
                    packageFiles.remove(path);
                    continue;
                }
                missingFiles.add(path);
            }
            for (String path : manifest.getMetadataFiles()) {
                Bitstream mdbs;
                if (packageFiles.contains(path)) {
                    packageFiles.remove(path);
                } else {
                    missingFiles.add(path);
                }
                if ((mdbs = contentBundle.getBitstreamByName(path)) == null) continue;
                mdBundle.addBitstream(mdbs);
                contentBundle.removeBitstream(mdbs);
            }
            if (packageFiles.contains("imsmanifest.xml")) {
                packageFiles.remove("imsmanifest.xml");
            }
            this.checkPackageFiles(packageFiles, missingFiles, manifest);
            if (!missingFiles.isEmpty()) {
                msg = new StringBuffer("Package is unacceptable: it is missing these files listed in Manifest:");
                mi = missingFiles.iterator();
                while (mi.hasNext()) {
                    msg.append("\n\t" + (String)mi.next());
                }
                throw new PackageValidationException(msg.toString());
            }
            if (!packageFiles.isEmpty()) {
                msg = new StringBuffer("Package is malformed, but still acceptable:  it contains extra files NOT in manifest:");
                mi = packageFiles.iterator();
                while (mi.hasNext()) {
                    msg.append("\n\t" + (String)mi.next());
                }
                log.warn((Object)msg);
            }
            this.crosswalk(context, item, manifest, validate);
            PackageUtils.checkMetadata((Item)item);
            String pbsPath = manifest.getPrimaryBitstreamPath();
            if (pbsPath == null) {
                log.warn((Object)"Failed to find primary bitstream path in Manifest.");
            } else {
                Bitstream pbs = contentBundle.getBitstreamByName(pbsPath);
                if (pbs == null) {
                    log.error((Object)("Got Primary Bitstream file path=" + pbsPath + ", but found no corresponding bitstream."));
                } else {
                    contentBundle.setPrimaryBitstreamID(pbs.getID());
                }
            }
            this.addLicense(context, collection, item, manifest, license);
            this.finishItem(context, item, collection);
            contentBundle.update();
            mdBundle.update();
            wi.update();
            success = true;
            log.info((Object)LogManager.getHeader((Context)context, (String)"ingest", (String)("Created new Item, db ID=" + String.valueOf(item.getID()) + ", WorkspaceItem ID=" + String.valueOf(wi.getID()))));
            WorkspaceItem workspaceItem = wi;
            return workspaceItem;
        }
        catch (SQLException se) {
            wi = null;
            throw se;
        }
        finally {
            if (!success && wi != null) {
                wi.deleteAll();
            }
        }
    }

    public Item replace(Context ctx, Item item, InputStream pckage, PackageParameters params) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        throw new UnsupportedOperationException("The replace operation is not implemented.");
    }

    public abstract Class getManifestClass();

    public abstract void checkPackageFiles(Set var1, Set var2, IMSCPManifest var3) throws PackageValidationException, CrosswalkException;

    public abstract void crosswalk(Context var1, Item var2, IMSCPManifest var3, boolean var4) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException;

    public abstract void addLicense(Context var1, Collection var2, Item var3, IMSCPManifest var4, String var5) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException;

    public abstract void finishItem(Context var1, Item var2, Collection var3) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException;
}

