/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.Context;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public abstract class IMSCPManifest {
    public static final String MANIFEST_FILE = "imsmanifest.xml";
    protected Element manifest = null;
    protected Namespace imscp_ns = null;
    private static Logger log = Logger.getLogger(IMSCPManifest.class);
    private String base = null;
    private Set contentFiles = null;

    public void parse(InputStream docStream, boolean validate) throws MetadataValidationException, IOException {
        try {
            SAXBuilder builder = new SAXBuilder(validate);
            if (validate) {
                builder.setFeature("http://apache.org/xml/features/validation/schema", true);
            }
            Document mdoc = builder.build(docStream);
            this.manifest = mdoc.getRootElement();
            this.imscp_ns = this.manifest.getNamespace();
        }
        catch (JDOMException je) {
            throw new MetadataValidationException("IMSCP Manifest is invalid: " + je.toString());
        }
    }

    public String getBase() {
        if (this.base != null) {
            return this.base;
        }
        if (this.manifest != null) {
            this.base = this.manifest.getAttributeValue("base", Namespace.XML_NAMESPACE);
            if (this.base == null) {
                this.base = "";
            }
            return this.base;
        }
        return "";
    }

    public Element getMetadata() throws MetadataValidationException {
        Element md = null;
        if (this.manifest != null) {
            md = this.manifest.getChild("metadata", this.imscp_ns);
        }
        if (md == null) {
            throw new MetadataValidationException("Manifest is invalid, missing \"metadata\" element.");
        }
        return md;
    }

    public void checkManifest() throws MetadataValidationException {
        if (this.manifest == null) {
            throw new MetadataValidationException("IMSCP Manifest is missing or was not parsed.");
        }
        if (!this.manifest.getName().equals("manifest")) {
            throw new MetadataValidationException("Invalid IMSCP Manifest: Root element of Manifest is not \"manifest\"");
        }
    }

    public Set getContentFiles() throws PackageValidationException {
        if (this.contentFiles != null) {
            return this.contentFiles;
        }
        this.contentFiles = new HashSet();
        Element rs = this.manifest.getChild("resources", this.imscp_ns);
        if (rs == null) {
            throw new PackageValidationException("Malformed IMSCP manifest: no \"resources\" element.");
        }
        for (Element r : rs.getChildren("resource", this.imscp_ns)) {
            String hpath = r.getAttributeValue("href");
            if (hpath != null && !hpath.startsWith("http:") && !hpath.startsWith("https:")) {
                this.contentFiles.add(this.getBase() + hpath);
                log.debug((Object)("Got resource@href path=" + hpath));
            }
            for (Element f : r.getChildren("file", this.imscp_ns)) {
                hpath = f.getAttributeValue("href");
                if (hpath == null || hpath.startsWith("http:") || hpath.startsWith("https:")) continue;
                this.contentFiles.add(this.getBase() + hpath);
                log.debug((Object)("Got resource/file@href path=" + hpath));
            }
        }
        return this.contentFiles;
    }

    public Set getMetadataFiles() throws MetadataValidationException {
        return new HashSet();
    }

    abstract String getPrimaryBitstreamPath() throws MetadataValidationException;

    public abstract BitstreamFormat getManifestBitstreamFormat(Context var1) throws SQLException, AuthorizeException, IOException;
}

