/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.AbstractIMSCPIngester;
import org.dspace.content.packager.IMSCPManifest;
import org.dspace.content.packager.OCWIMSCPManifest;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.dspace.license.CreativeCommons;
import org.dspace.search.DSQuery;
import org.dspace.search.QueryArgs;
import org.dspace.search.QueryResults;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

public class OCWIMSCPIngester
extends AbstractIMSCPIngester {
    private static Logger log = Logger.getLogger(OCWIMSCPIngester.class);
    private static final Namespace ADLCP_NS = Namespace.getNamespace((String)"adlcp", (String)"http://www.adlnet.org/xsd/adlcp_rootv1p2");

    public Class getManifestClass() {
        return OCWIMSCPManifest.class;
    }

    public void checkPackageFiles(Set packageFiles, Set missingFiles, IMSCPManifest manifest) throws PackageValidationException, CrosswalkException {
    }

    public void crosswalk(Context context, Item item, IMSCPManifest manifest, boolean validate) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException {
        IngestionCrosswalk xwalk;
        Document mdd;
        Element md = manifest.getMetadata();
        String loc = md.getChildTextNormalize("location", ADLCP_NS);
        if (loc == null) {
            throw new PackageValidationException("Invalid OCW-IMSCP manifest: Cannot find item LOM metadata, no element at manifest/metadata/adlcp:location.");
        }
        loc = manifest.getBase() + loc;
        Bundle[] bns = item.getBundles("METADATA");
        if (bns != null && bns.length > 0) {
            Bitstream mbs = bns[0].getBitstreamByName(loc);
            if (mbs == null) {
                throw new PackageValidationException("Invalid OCW-IMSCP manifest: LOM metadata file \"" + loc + "\" does not seem to be in the package.");
            }
            mdd = null;
            try {
                SAXBuilder parser = new SAXBuilder(validate);
                if (validate) {
                    parser.setFeature("http://apache.org/xml/features/validation/schema", true);
                }
                mdd = parser.build(mbs.retrieve());
            }
            catch (JDOMException je) {
                throw new MetadataValidationException("Error parsing or validating metadata section referenced by adlcp:location from file=\"" + loc + "\", exception=" + je.toString());
            }
            String xwalkName = ConfigurationManager.getProperty((String)"cwspace.crosswalk.ingest.lom");
            if (xwalkName == null) {
                throw new PackageException("Configuration error: no value for \"cwspace.crosswalk.ingest.lom\"");
            }
            xwalk = (IngestionCrosswalk)PluginManager.getNamedPlugin(IngestionCrosswalk.class, (String)xwalkName);
            if (xwalk == null) {
                throw new PackageException("Configuration error: cannot load ingestion crosswalk for " + xwalkName);
            }
        } else {
            throw new PackageValidationException("Unacceptable OCW-IMSCP manifest: Cannot find bitstream of LOM metadata: " + loc);
        }
        xwalk.ingest(context, (DSpaceObject)item, mdd.getRootElement());
    }

    public void addLicense(Context context, Collection collection, Item item, IMSCPManifest manifest, String license) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException {
        PackageUtils.addDepositLicense((Context)context, (String)license, (Item)item, (Collection)collection);
        String ccURL = ConfigurationManager.getProperty((String)"cwspace.ocw.creativecommons.url");
        if (ccURL != null) {
            CreativeCommons.setLicense((Context)context, (Item)item, (String)ccURL);
        }
    }

    public void finishItem(Context context, Item item, Collection collection) throws PackageException, CrosswalkException, AuthorizeException, SQLException, IOException {
        this.OCWDuplicateCheck(context, item, collection);
        Bundle[] bns = item.getBundles("ORIGINAL");
        if (bns != null && bns.length > 0) {
            if (bns[0].getPrimaryBitstreamID() < 0) {
                throw new PackageValidationException("Invalid IMSCP manifest: Could not determine \"primary bitstream\" (home page) from manifest.");
            }
        } else {
            throw new PackageValidationException("Invalid IMSCP package: no content bitstreams.");
        }
    }

    private void OCWDuplicateCheck(Context context, Item item, Collection collection) throws PackageException, IOException, SQLException {
        Bitstream manifest;
        String idPrefix = "IMSCP-MD5-";
        Bundle[] mdb = item.getBundles("METADATA");
        if (mdb.length > 0 && (manifest = mdb[0].getBitstreamByName("imsmanifest.xml")) != null) {
            String uniqueId = "IMSCP-MD5-" + manifest.getChecksum();
            log.debug((Object)("Looking for duplicate Item of IMSCP package ID=" + uniqueId));
            QueryArgs qa = new QueryArgs();
            qa.setQuery(uniqueId);
            QueryResults qr = DSQuery.doQuery((Context)context, (QueryArgs)qa, (Collection)collection);
            if (qr.getHitCount() > 0) {
                List hh = qr.getHitHandles();
                String hdl = (String)hh.get(0);
                throw new PackageException("Duplicate Item Rejected: There is apparently already a duplicate of this Item in the target collection, handle=" + hdl);
            }
            item.addMetadata("dc", "identifier", "other", null, uniqueId);
        }
    }
}

