/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.IMSCPManifest;
import org.dspace.content.packager.PackageUtils;
import org.dspace.core.Context;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.xpath.XPath;

public class OCWIMSCPManifest
extends IMSCPManifest {
    private static Logger log = Logger.getLogger(OCWIMSCPManifest.class);
    public static final String CWSP_NS_URI = "http://www.dspace.org/xmlns/cwspace_imscp";
    public static final Namespace CWSP_NS = Namespace.getNamespace((String)"cwsp", (String)"http://www.dspace.org/xmlns/cwspace_imscp");
    public static final String OCW_NS_URI = "http://ocw.mit.edu/xmlns/ocw_imscp";
    public static final Namespace OCW_NS = Namespace.getNamespace((String)"ocw", (String)"http://ocw.mit.edu/xmlns/ocw_imscp");
    public static final String ADLCP_NS_URI = "http://www.adlnet.org/xsd/adlcp_rootv1p2";
    public static final Namespace ADLCP_NS = Namespace.getNamespace((String)"adlcp", (String)"http://www.adlnet.org/xsd/adlcp_rootv1p2");
    public static final String LOM_NS_URI = "http://ocw.mit.edu/xmlns/LOM";
    public static final Namespace LOM_NS = Namespace.getNamespace((String)"lom", (String)"http://ocw.mit.edu/xmlns/LOM");
    private static final String MD_SCHEMA = "IMS Content";
    private static final String MD_SCHEMAVERSION = "1.1";
    private static final String CWSP_SCHEMA = "CWSpace";
    private static final String CWSP_SCHEMAVERSION = "0.1";
    private static final String MANIFEST_FMT_NAME = "MIT OCW IMSCP Manifest";
    private Set metadataFiles = null;

    public void checkManifest() throws MetadataValidationException {
        super.checkManifest();
        Element md = this.getMetadata();
        String schema = md.getChildTextNormalize("schema", this.imscp_ns);
        String schemaVersion = md.getChildTextNormalize("schemaversion", this.imscp_ns);
        if (schema == null || schemaVersion == null || !schema.equals(MD_SCHEMA) || !schemaVersion.equals(MD_SCHEMAVERSION)) {
            throw new MetadataValidationException("Manifest is invalid, wrong or missing schema, schemaversion (expect \"IMS Content\", 1.1)");
        }
        Element cwmd = md.getChild("packageMetadata", CWSP_NS);
        if (cwmd == null) {
            throw new MetadataValidationException("Manifest is invalid, no cwsp:packageMetadata element in metadata.");
        }
        String cwProfile = cwmd.getChildTextNormalize("profile", CWSP_NS);
        String cwProfileVersion = cwmd.getChildTextNormalize("profileVersion", CWSP_NS);
        if (cwProfile == null || cwProfileVersion == null || !cwProfile.equals(CWSP_SCHEMA) || !cwProfileVersion.equals(CWSP_SCHEMAVERSION)) {
            throw new MetadataValidationException("Manifest is invalid, wrong or missing CWSpace profile, profileVersion (expect \"CWSpace\", 0.1)");
        }
    }

    public Set getMetadataFiles() throws MetadataValidationException {
        Element rs;
        if (this.metadataFiles != null) {
            return this.metadataFiles;
        }
        this.metadataFiles = new HashSet();
        Element md = this.getMetadata();
        String mdloc = md.getChildTextNormalize("location", ADLCP_NS);
        if (mdloc != null && !mdloc.startsWith("http:") && !mdloc.startsWith("https:")) {
            this.metadataFiles.add(this.getBase() + mdloc);
        }
        if ((rs = this.manifest.getChild("resources", this.imscp_ns)) == null) {
            throw new MetadataValidationException("Malformed IMSCP manifest: no \"resources\" element.");
        }
        for (Element resource : rs.getChildren("resource", this.imscp_ns)) {
            for (Element m : resource.getChildren("metadata", this.imscp_ns)) {
                String path = m.getChildTextNormalize("location", ADLCP_NS);
                if (path == null || path.startsWith("http:") || path.startsWith("https:")) continue;
                this.metadataFiles.add(this.getBase() + path);
                log.debug((Object)("Got metadata/adlcp:location path=" + path));
            }
        }
        return this.metadataFiles;
    }

    public String getPrimaryBitstreamPath() throws MetadataValidationException {
        Element orgs = this.manifest.getChild("organizations", this.imscp_ns);
        if (orgs == null) {
            throw new MetadataValidationException("Malformed IMSCP manifest: no \"organizations\" element.");
        }
        String defaultOrg = orgs.getAttributeValue("default");
        Element firstItem = null;
        try {
            String orgPath = "imscp:organization/imscp:item[1]";
            if (defaultOrg != null) {
                orgPath = "imscp:organization[@identifier='" + defaultOrg + "']/imscp:item[1]";
            }
            XPath orgXPath = XPath.newInstance((String)orgPath);
            orgXPath.addNamespace("imscp", this.imscp_ns.getURI());
            firstItem = (Element)orgXPath.selectSingleNode((Object)orgs);
        }
        catch (JDOMException je) {
            throw new MetadataValidationException((Throwable)je);
        }
        if (firstItem == null) {
            throw new MetadataValidationException("Malformed IMSCP manifest: Failed to locate \"home page\" for primary bitstream, because either default organization or its first item cannot be found. Check validity of organizations element.");
        }
        String resId = firstItem.getAttributeValue("identifierref");
        if (resId != null) {
            try {
                String resPath = "/imscp:manifest/imscp:resources/imscp:resource[@identifier='" + resId + "']/imscp:file/@href";
                XPath resXPath = XPath.newInstance((String)resPath);
                resXPath.addNamespace("imscp", this.imscp_ns.getURI());
                Attribute href = (Attribute)resXPath.selectSingleNode((Object)this.manifest);
                if (href != null) {
                    return this.getBase() + href.getValue();
                }
                throw new MetadataValidationException("Malformed IMSCP manifest: No resource found for indicated identifierref, XPath=" + resPath);
            }
            catch (JDOMException je) {
                throw new MetadataValidationException((Throwable)je);
            }
        }
        throw new MetadataValidationException("Malformed IMSCP manifest: first item in the default organization has no identifierref attribute: " + firstItem.toString());
    }

    public BitstreamFormat getManifestBitstreamFormat(Context context) throws SQLException, AuthorizeException, IOException {
        return PackageUtils.findOrCreateBitstreamFormat((Context)context, (String)MANIFEST_FMT_NAME, (String)"application/xml", (String)MANIFEST_FMT_NAME);
    }
}

