/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.discovery;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.discovery.DiscoverFacetField;
import org.dspace.discovery.DiscoverQuery;
import org.dspace.discovery.DiscoverResult;
import org.dspace.discovery.SearchUtils;
import org.dspace.discovery.configuration.DiscoveryConfiguration;
import org.dspace.discovery.configuration.DiscoveryConfigurationParameters;
import org.dspace.discovery.configuration.DiscoverySearchFilterFacet;
import org.dspace.discovery.configuration.DiscoverySortConfiguration;
import org.dspace.discovery.configuration.DiscoverySortFieldConfiguration;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;

/*
 * Exception performing whole class analysis ignored.
 */
public class DiscoverUtility {
    private static Logger log = Logger.getLogger(DiscoverUtility.class);
    public static final int TYPE_FACETS = 1;
    public static final int TYPE_TAGCLOUD = 2;

    public static DSpaceObject getSearchScope(Context context, HttpServletRequest request) throws IllegalStateException, SQLException {
        String location = request.getParameter("location");
        if (location == null) {
            if (UIUtil.getCollectionLocation((HttpServletRequest)request) != null) {
                return UIUtil.getCollectionLocation((HttpServletRequest)request);
            }
            if (UIUtil.getCommunityLocation((HttpServletRequest)request) != null) {
                return UIUtil.getCommunityLocation((HttpServletRequest)request);
            }
            return null;
        }
        HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
        DSpaceObject scope = handleService.resolveToObject(context, location);
        return scope;
    }

    public static DiscoverQuery getDiscoverQuery(Context context, HttpServletRequest request, DSpaceObject scope, boolean enableFacet) {
        DiscoverQuery queryArgs = new DiscoverQuery();
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)scope);
        List userFilters = DiscoverUtility.setupBasicQuery((Context)context, (DiscoveryConfiguration)discoveryConfiguration, (HttpServletRequest)request, (DiscoverQuery)queryArgs);
        DiscoverUtility.setPagination((HttpServletRequest)request, (DiscoverQuery)queryArgs, (DiscoveryConfiguration)discoveryConfiguration);
        if (enableFacet && !"submit_export_metadata".equals(UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit"))) {
            DiscoverUtility.setFacet((Context)context, (HttpServletRequest)request, (DSpaceObject)scope, (DiscoverQuery)queryArgs, (DiscoveryConfiguration)discoveryConfiguration, (List)userFilters, (List)discoveryConfiguration.getSidebarFacets(), (int)1);
        }
        return queryArgs;
    }

    public static DiscoverQuery getTagCloudDiscoverQuery(Context context, HttpServletRequest request, DSpaceObject scope, boolean enableFacet) {
        DiscoverQuery queryArgs = new DiscoverQuery();
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration((DSpaceObject)scope);
        List userFilters = DiscoverUtility.setupBasicQuery((Context)context, (DiscoveryConfiguration)discoveryConfiguration, (HttpServletRequest)request, (DiscoverQuery)queryArgs);
        DiscoverUtility.setPagination((HttpServletRequest)request, (DiscoverQuery)queryArgs, (DiscoveryConfiguration)discoveryConfiguration);
        if (enableFacet && !"submit_export_metadata".equals(UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit"))) {
            DiscoverUtility.setFacet((Context)context, (HttpServletRequest)request, (DSpaceObject)scope, (DiscoverQuery)queryArgs, (DiscoveryConfiguration)discoveryConfiguration, (List)userFilters, (List)discoveryConfiguration.getTagCloudFacetConfiguration().getTagCloudFacets(), (int)2);
        }
        return queryArgs;
    }

    public static DiscoverQuery getDiscoverAutocomplete(Context context, HttpServletRequest request, DSpaceObject scope) {
        int limit;
        DiscoverQuery queryArgs = new DiscoverQuery();
        DiscoveryConfiguration discoveryConfiguration = SearchUtils.getDiscoveryConfiguration();
        DiscoverUtility.setupBasicQuery((Context)context, (DiscoveryConfiguration)discoveryConfiguration, (HttpServletRequest)request, (DiscoverQuery)queryArgs);
        String autoIndex = request.getParameter("auto_idx");
        String autoQuery = request.getParameter("auto_query");
        String sort = request.getParameter("auto_sort");
        String autoType = request.getParameter("auto_type");
        autoType = "contains".equals(autoType) || "notcontains".equals(autoType) ? "standard" : ("authority".equals(autoType) || "notauthority".equals(autoType) ? "authority" : "ac");
        DiscoveryConfigurationParameters.SORT sortBy = DiscoveryConfigurationParameters.SORT.VALUE;
        if (StringUtils.isNotBlank((String)sort)) {
            sortBy = "count".equalsIgnoreCase(sort) ? DiscoveryConfigurationParameters.SORT.COUNT : DiscoveryConfigurationParameters.SORT.VALUE;
        } else if ("".equals(autoQuery)) {
            sortBy = DiscoveryConfigurationParameters.SORT.COUNT;
        }
        if (autoIndex == null) {
            autoIndex = "all";
        }
        if (autoQuery == null) {
            autoQuery = "";
        }
        if ((limit = UIUtil.getIntParameter((HttpServletRequest)request, (String)"autocomplete.limit")) == -1) {
            limit = 10;
        }
        DiscoverFacetField autocompleteField = new DiscoverFacetField(autoIndex, autoType, limit, sortBy, autoQuery.toLowerCase());
        queryArgs.addFacetField(autocompleteField);
        queryArgs.setMaxResults(0);
        queryArgs.setFacetMinCount(1);
        return queryArgs;
    }

    private static List<String> setupBasicQuery(Context context, DiscoveryConfiguration discoveryConfiguration, HttpServletRequest request, DiscoverQuery queryArgs) {
        List defaultFilterQueries;
        String query = request.getParameter("query");
        if (StringUtils.isNotBlank((String)query)) {
            query = DiscoverUtility.escapeQueryChars((String)query);
            queryArgs.setQuery(query);
        }
        if ((defaultFilterQueries = discoveryConfiguration.getDefaultFilterQueries()) != null) {
            for (String f : defaultFilterQueries) {
                queryArgs.addFilterQueries(new String[]{f});
            }
        }
        List filters = DiscoverUtility.getFilters((HttpServletRequest)request);
        ArrayList<String> userFilters = new ArrayList<String>();
        for (String[] f : filters) {
            try {
                String newFilterQuery = SearchUtils.getSearchService().toFilterQuery(context, f[0], f[1], f[2]).getFilterQuery();
                if (newFilterQuery == null) continue;
                queryArgs.addFilterQueries(new String[]{newFilterQuery});
                userFilters.add(newFilterQuery);
            }
            catch (SQLException e) {
                log.error((Object)LogManager.getHeader((Context)context, (String)"Error in discovery while setting up user facet query", (String)("filter_field: " + f[0] + ",filter_type:" + f[1] + ",filer_value:" + f[2])), (Throwable)e);
            }
        }
        return userFilters;
    }

    private static String escapeQueryChars(String query) {
        return StringUtils.replace((String)query, (String)": ", (String)"\\: ");
    }

    private static void setPagination(HttpServletRequest request, DiscoverQuery queryArgs, DiscoveryConfiguration discoveryConfiguration) {
        int start = UIUtil.getIntParameter((HttpServletRequest)request, (String)"start");
        if (start < 0) {
            start = 0;
        }
        String sortBy = request.getParameter("sort_by");
        String sortOrder = request.getParameter("order");
        DiscoverySortConfiguration searchSortConfiguration = discoveryConfiguration.getSearchSortConfiguration();
        if (sortBy == null) {
            sortBy = "score";
            if (searchSortConfiguration != null) {
                for (DiscoverySortFieldConfiguration sortFieldConfiguration : searchSortConfiguration.getSortFields()) {
                    if (!sortFieldConfiguration.equals((Object)searchSortConfiguration.getDefaultSort())) continue;
                    sortBy = SearchUtils.getSearchService().toSortFieldIndex(sortFieldConfiguration.getMetadataField(), sortFieldConfiguration.getType());
                }
            }
        }
        if (sortOrder == null && searchSortConfiguration != null) {
            sortOrder = searchSortConfiguration.getDefaultSortOrder().toString();
        }
        if (sortBy != null) {
            if ("asc".equalsIgnoreCase(sortOrder)) {
                queryArgs.setSortField(sortBy, DiscoverQuery.SORT_ORDER.asc);
            } else {
                queryArgs.setSortField(sortBy, DiscoverQuery.SORT_ORDER.desc);
            }
        }
        int rpp = UIUtil.getIntParameter((HttpServletRequest)request, (String)"rpp");
        if ("submit_export_metadata".equals(UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit"))) {
            queryArgs.setStart(0);
            queryArgs.setMaxResults(Integer.MAX_VALUE);
            queryArgs.addFilterQueries(new String[]{"search.resourcetype:2"});
        } else {
            if (rpp > 0) {
                queryArgs.setMaxResults(rpp);
            } else {
                queryArgs.setMaxResults(discoveryConfiguration.getDefaultRpp());
            }
            queryArgs.setStart(start);
        }
    }

    private static void setFacet(Context context, HttpServletRequest request, DSpaceObject scope, DiscoverQuery queryArgs, DiscoveryConfiguration discoveryConfiguration, List<String> userFilters, List<DiscoverySearchFilterFacet> facets, int type) {
        log.info((Object)("facets for scope, " + scope + ": " + (facets != null ? Integer.valueOf(facets.size()) : null)));
        if (facets != null) {
            queryArgs.setFacetMinCount(1);
        }
        if (facets != null) {
            queryArgs.setFacetMinCount(1);
            for (DiscoverySearchFilterFacet facet : facets) {
                if (facet.getType().equals("date")) {
                    String dateFacet = facet.getIndexFieldName() + ".year";
                    List filterQueriesList = queryArgs.getFilterQueries();
                    String[] filterQueries = new String[]{};
                    if (filterQueriesList != null) {
                        filterQueries = new String[filterQueries.length];
                        filterQueries = filterQueriesList.toArray(filterQueries);
                    }
                    try {
                        int oldestYear = -1;
                        int newestYear = -1;
                        for (String filterQuery : filterQueries) {
                            if (!filterQuery.startsWith(dateFacet + ":")) continue;
                            Pattern pattern = Pattern.compile("\\[(.*? TO .*?)\\]");
                            Matcher matcher = pattern.matcher(filterQuery);
                            boolean hasPattern = matcher.find();
                            if (hasPattern) {
                                filterQuery = matcher.group(0);
                                int tempOldYear = Integer.parseInt(filterQuery.split(" TO ")[0].replace("[", "").trim());
                                int tempNewYear = Integer.parseInt(filterQuery.split(" TO ")[1].replace("]", "").trim());
                                if (tempNewYear >= newestYear && oldestYear >= tempOldYear && newestYear != -1) continue;
                                oldestYear = tempOldYear;
                                newestYear = tempNewYear;
                                continue;
                            }
                            if (filterQuery.indexOf(" OR ") != -1) {
                                filterQuery = filterQuery.split(" OR ")[0];
                            }
                            newestYear = oldestYear = Integer.parseInt(filterQuery.split(":")[1].trim());
                            break;
                        }
                        if (oldestYear == -1 && newestYear == -1) {
                            List searchDocuments;
                            List searchDocuments2;
                            DiscoverQuery yearRangeQuery = new DiscoverQuery();
                            yearRangeQuery.setFacetMinCount(1);
                            yearRangeQuery.setMaxResults(1);
                            yearRangeQuery.addFieldPresentQueries(new String[]{dateFacet});
                            yearRangeQuery.setSortField(dateFacet + "_sort", DiscoverQuery.SORT_ORDER.asc);
                            yearRangeQuery.addFilterQueries(filterQueries);
                            yearRangeQuery.addSearchField(dateFacet);
                            DiscoverResult lastYearResult = SearchUtils.getSearchService().search(context, scope, yearRangeQuery);
                            if (0 < lastYearResult.getDspaceObjects().size() && 0 < (searchDocuments2 = lastYearResult.getSearchDocument((DSpaceObject)lastYearResult.getDspaceObjects().get(0))).size() && 0 < ((DiscoverResult.SearchDocument)searchDocuments2.get(0)).getSearchFieldValues(dateFacet).size()) {
                                oldestYear = Integer.parseInt((String)((DiscoverResult.SearchDocument)searchDocuments2.get(0)).getSearchFieldValues(dateFacet).get(0));
                            }
                            yearRangeQuery.setSortField(dateFacet + "_sort", DiscoverQuery.SORT_ORDER.desc);
                            DiscoverResult firstYearResult = SearchUtils.getSearchService().search(context, scope, yearRangeQuery);
                            if (0 < firstYearResult.getDspaceObjects().size() && 0 < (searchDocuments = firstYearResult.getSearchDocument((DSpaceObject)firstYearResult.getDspaceObjects().get(0))).size() && 0 < ((DiscoverResult.SearchDocument)searchDocuments.get(0)).getSearchFieldValues(dateFacet).size()) {
                                newestYear = Integer.parseInt((String)((DiscoverResult.SearchDocument)searchDocuments.get(0)).getSearchFieldValues(dateFacet).get(0));
                            }
                            if (newestYear == -1 || oldestYear == -1) continue;
                        }
                        int gap = 1;
                        int yearDifference = newestYear - oldestYear;
                        if (yearDifference != 0) {
                            while (10.0 < (double)yearDifference / (double)gap) {
                                gap *= 10;
                            }
                        }
                        int topYear = (int)(Math.ceil((float)newestYear / (float)gap) * (double)gap);
                        if (gap == 1) {
                            queryArgs.addFacetField(new DiscoverFacetField(facet.getIndexFieldName(), facet.getType(), 10, facet.getSortOrderSidebar()));
                            continue;
                        }
                        ArrayList<String> facetQueries = new ArrayList<String>();
                        for (int year = topYear; year > oldestYear && facetQueries.size() < 11; year -= gap) {
                            int bottomYear = year - gap;
                            if (bottomYear < oldestYear) {
                                bottomYear = oldestYear;
                            }
                            int currentTop = year;
                            currentTop = year == topYear ? newestYear : --currentTop;
                            facetQueries.add(dateFacet + ":[" + bottomYear + " TO " + currentTop + "]");
                        }
                        for (String facetQuery : facetQueries) {
                            queryArgs.addFacetQuery(facetQuery);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        log.error((Object)LogManager.getHeader((Context)context, (String)"Error in discovery while setting up date facet range", (String)("date facet: " + dateFacet)), (Throwable)e);
                        continue;
                    }
                }
                int facetLimit = type == 1 ? facet.getFacetLimit() : -1;
                int facetPage = UIUtil.getIntParameter((HttpServletRequest)request, (String)(facet.getIndexFieldName() + "_page"));
                if (facetPage < 0) {
                    facetPage = 0;
                }
                int alreadySelected = userFilters.size();
                int limit = 0;
                limit = type == 1 ? facetLimit + 1 + alreadySelected : facetLimit;
                queryArgs.addFacetField(new DiscoverFacetField(facet.getIndexFieldName(), "text", limit, facet.getSortOrderSidebar(), facetPage * facetLimit));
            }
        }
    }

    public static List<String[]> getFilters(HttpServletRequest request) {
        String op;
        String submit = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        int ignore = -1;
        if (submit.startsWith("submit_filter_remove_")) {
            ignore = Integer.parseInt(submit.substring("submit_filter_remove_".length()));
        }
        ArrayList<String[]> appliedFilters = new ArrayList<String[]>();
        ArrayList<String> filterValue = new ArrayList<String>();
        ArrayList<String> filterOp = new ArrayList<String>();
        ArrayList<String> filterField = new ArrayList<String>();
        int idx = 1;
        while (!StringUtils.isBlank((String)(op = request.getParameter("filter_type_" + idx)))) {
            if (idx != ignore) {
                filterOp.add(op);
                filterField.add(request.getParameter("filter_field_" + idx));
                filterValue.add(request.getParameter("filter_value_" + idx));
            }
            ++idx;
        }
        String op2 = request.getParameter("filtertype");
        if (StringUtils.isNotBlank((String)op2)) {
            filterOp.add(op2);
            filterField.add(request.getParameter("filtername"));
            filterValue.add(request.getParameter("filterquery"));
        }
        for (int idx2 = 0; idx2 < filterOp.size(); ++idx2) {
            appliedFilters.add(new String[]{(String)filterField.get(idx2), (String)filterOp.get(idx2), (String)filterValue.get(idx2)});
        }
        return appliedFilters;
    }
}

