/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CommunityService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class CommunityListServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(CommunityListServlet.class);
    private final transient CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        HashMap colMap = new HashMap();
        HashMap commMap = new HashMap();
        log.info((Object)LogManager.getHeader((Context)context, (String)"view_community_list", (String)""));
        List communities = this.communityService.findAllTop(context);
        for (Community c : communities) {
            this.build(c, colMap, commMap);
        }
        if (this.authorizeService.isAdmin(context)) {
            request.setAttribute("admin_button", (Object)Boolean.TRUE);
        }
        request.setAttribute("communities", (Object)communities);
        request.setAttribute("collections.map", colMap);
        request.setAttribute("subcommunities.map", commMap);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/community-list.jsp");
    }

    private void build(Community c, Map<String, List<Collection>> colMap, Map<String, List<Community>> commMap) throws SQLException {
        String comID = c.getID().toString();
        List colls = c.getCollections();
        colMap.put(comID, colls);
        List comms = c.getSubcommunities();
        if (comms.size() > 0) {
            commMap.put(comID, comms);
            for (Community sub : comms) {
                this.build(sub, colMap, commMap);
            }
        }
    }
}

