/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.EPersonService;

public class EditProfileServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(EditProfileServlet.class);
    protected transient EPersonService personService = EPersonServiceFactory.getInstance().getEPersonService();

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        log.info((Object)LogManager.getHeader((Context)context, (String)"view_profile", (String)""));
        request.setAttribute("eperson", (Object)context.getCurrentUser());
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/edit-profile.jsp");
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean ok;
        EPerson eperson = context.getCurrentUser();
        boolean settingPassword = false;
        if (!eperson.getRequireCertificate() && !StringUtils.isEmpty((String)request.getParameter("password"))) {
            settingPassword = true;
        }
        if (!(ok = this.updateUserProfile(context, eperson, request))) {
            request.setAttribute("missing.fields", (Object)Boolean.TRUE);
        }
        if (ok && settingPassword && !(ok = this.confirmAndSetPassword(eperson, request))) {
            request.setAttribute("password.problem", (Object)Boolean.TRUE);
        }
        if (ok) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"edit_profile", (String)("password_changed=" + settingPassword)));
            this.personService.update(context, (DSpaceObject)eperson);
            request.setAttribute("password.updated", (Object)settingPassword);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/profile-updated.jsp");
            context.complete();
        } else {
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_profile", (String)"problem=true"));
            request.setAttribute("eperson", (Object)eperson);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/edit-profile.jsp");
        }
    }

    public boolean updateUserProfile(Context context, EPerson eperson, HttpServletRequest request) throws SQLException {
        String lastName = request.getParameter("last_name");
        String firstName = request.getParameter("first_name");
        String phone = request.getParameter("phone");
        String language = request.getParameter("language");
        eperson.setFirstName(context, firstName);
        eperson.setLastName(context, lastName);
        this.personService.setMetadataSingleValue(context, (DSpaceObject)eperson, "eperson", "phone", null, null, phone);
        eperson.setLanguage(context, language);
        return !StringUtils.isEmpty((String)lastName) && !StringUtils.isEmpty((String)firstName);
    }

    public boolean confirmAndSetPassword(EPerson eperson, HttpServletRequest request) {
        String password = request.getParameter("password");
        String passwordConfirm = request.getParameter("password_confirm");
        if (password == null || password.length() < 6) {
            return false;
        }
        if (!password.equals(passwordConfirm)) {
            return false;
        }
        this.personService.setPassword(eperson, password);
        return true;
    }
}

