/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.GoogleMetadata;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.Authenticate;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.CommunityService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.factory.CoreServiceFactory;
import org.dspace.core.service.PluginService;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.SubscribeService;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.identifier.DOI;
import org.dspace.identifier.factory.IdentifierServiceFactory;
import org.dspace.identifier.service.DOIService;
import org.dspace.identifier.service.IdentifierService;
import org.dspace.plugin.CollectionHomeProcessor;
import org.dspace.plugin.CommunityHomeProcessor;
import org.dspace.plugin.ItemHomeProcessor;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.jdom.Element;
import org.jdom.Text;
import org.jdom.output.XMLOutputter;

public class HandleServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(HandleServlet.class);
    private final transient HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private final transient SubscribeService subscribeService = EPersonServiceFactory.getInstance().getSubscribeService();
    private final transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final transient CommunityService communityService = ContentServiceFactory.getInstance().getCommunityService();
    private final transient CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private final transient PluginService pluginService = CoreServiceFactory.getInstance().getPluginService();
    private final transient DisseminationCrosswalk xHTMLHeadCrosswalk = (DisseminationCrosswalk)this.pluginService.getNamedPlugin(DisseminationCrosswalk.class, "XHTML_HEAD_ITEM");
    private final transient IdentifierService identifierService = IdentifierServiceFactory.getInstance().getIdentifierService();
    private final transient DOIService doiService = IdentifierServiceFactory.getInstance().getDOIService();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String handle = null;
        String extraPathInfo = null;
        DSpaceObject dso = null;
        String path = request.getPathInfo();
        if (path != null) {
            path = path.substring(1);
            try {
                int firstSlash = path.indexOf(47);
                int secondSlash = path.indexOf(47, firstSlash + 1);
                if (secondSlash != -1) {
                    handle = path.substring(0, secondSlash);
                    extraPathInfo = path.substring(secondSlash);
                } else {
                    handle = path;
                }
            }
            catch (NumberFormatException firstSlash) {
                // empty catch block
            }
        }
        if (handle != null) {
            dso = this.handleService.resolveToObject(context, handle);
        }
        if (dso == null) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_id", (String)("path=" + path)));
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)StringEscapeUtils.escapeHtml((String)path), (int)-1);
            return;
        }
        if ("/statistics".equals(extraPathInfo)) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"display_statistics", (String)("handle=" + handle + ", path=" + extraPathInfo)));
            request.setAttribute("handle", (Object)handle);
            RequestDispatcher dispatch = this.getServletContext().getNamedDispatcher("displaystats");
            dispatch.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if ("/display-statistics.jsp".equals(extraPathInfo)) {
            request.getRequestDispatcher(extraPathInfo).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if ("/browse".equals(extraPathInfo) || StringUtils.startsWith(extraPathInfo, (String)"/browse?")) {
            if (dso instanceof Community) {
                Community c = (Community)dso;
                request.setAttribute("dspace.community", (Object)c);
            } else if (dso instanceof Collection) {
                Collection c = (Collection)dso;
                request.setAttribute("dspace.collection", (Object)c);
            }
            request.getRequestDispatcher(extraPathInfo).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if ("/simple-search".equals(extraPathInfo) || StringUtils.startsWith(extraPathInfo, (String)"simple-search?")) {
            if (dso instanceof Community) {
                Community c = (Community)dso;
                request.setAttribute("dspace.community", (Object)c);
            } else if (dso instanceof Collection) {
                Collection c = (Collection)dso;
                request.setAttribute("dspace.collection", (Object)c);
            }
            request.getRequestDispatcher(extraPathInfo).forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (dso.getType() == 2) {
            if (extraPathInfo != null && !extraPathInfo.equals("/")) {
                log.debug((Object)"Found Item with extraPathInfo => Error.");
                JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)StringEscapeUtils.escapeHtml((String)path), (int)-1);
                return;
            }
            Item item = (Item)dso;
            if (context.getCurrentUser() != null) {
                this.displayItem(context, request, response, item, handle);
                return;
            }
            response.setDateHeader("Last-Modified", item.getLastModified().getTime());
            long modSince = request.getDateHeader("If-Modified-Since");
            if (modSince != -1L && item.getLastModified().getTime() < modSince) {
                response.setStatus(304);
                return;
            }
            this.displayItem(context, request, response, item, handle);
            return;
        }
        if (dso.getType() == 3) {
            Collection c = (Collection)dso;
            request.setAttribute("dspace.collection", (Object)c);
            List parents = c.getCommunities();
            request.setAttribute("dspace.community", parents.get(0));
            request.setAttribute("dspace.communities", (Object)this.getParents(context, (Community)parents.get(0), true));
            if (extraPathInfo != null && !extraPathInfo.equals("/")) {
                log.debug((Object)"Found Collection with extraPathInfo => Error.");
                JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)StringEscapeUtils.escapeHtml((String)path), (int)-1);
                return;
            }
            this.collectionHome(context, request, response, (Community)parents.get(0), c);
            return;
        }
        if (dso.getType() != 4) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"Handle not an item, collection or community", (String)("handle=" + handle)));
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)StringEscapeUtils.escapeHtml((String)path), (int)-1);
            return;
        }
        Community c = (Community)dso;
        request.setAttribute("dspace.community", (Object)c);
        request.setAttribute("dspace.communities", (Object)this.getParents(context, c, false));
        if (extraPathInfo != null && !extraPathInfo.equals("/")) {
            log.debug((Object)"Found Community with extraPathInfo => Error.");
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)StringEscapeUtils.escapeHtml((String)path), (int)-1);
            return;
        }
        this.communityHome(context, request, response, c);
    }

    private void displayItem(Context context, HttpServletRequest request, HttpServletResponse response, Item item, String handle) throws ServletException, IOException, SQLException, AuthorizeException {
        this.preProcessItemHome(context, request, response, item);
        if (item.isWithdrawn()) {
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tombstone.jsp");
            return;
        }
        this.authorizeService.authorizeAction(context, (DSpaceObject)item, 0);
        log.info((Object)LogManager.getHeader((Context)context, (String)"view_item", (String)("handle=" + handle)));
        if (this.itemService.canEdit(context, item)) {
            request.setAttribute("admin_button", (Object)Boolean.TRUE);
        }
        List collections = item.getCollections();
        request.setAttribute("dspace.collection", (Object)item.getOwningCollection());
        List comms = item.getOwningCollection().getCommunities();
        request.setAttribute("dspace.community", comms.get(0));
        request.setAttribute("dspace.communities", (Object)this.getParents(context, (Community)comms.get(0), true));
        boolean displayAll = false;
        String modeParam = request.getParameter("mode");
        if (modeParam != null && modeParam.equalsIgnoreCase("full")) {
            displayAll = true;
        }
        String headMetadata = "";
        try {
            List l = this.xHTMLHeadCrosswalk.disseminateList(context, (DSpaceObject)item);
            StringWriter sw = new StringWriter();
            XMLOutputter xmlo = new XMLOutputter();
            xmlo.output(new Text("\n"), (Writer)sw);
            for (Element e : l) {
                e.setNamespace(null);
                xmlo.output(e, (Writer)sw);
                xmlo.output(new Text("\n"), (Writer)sw);
            }
            boolean googleEnabled = ConfigurationManager.getBooleanProperty((String)"google-metadata.enable", (boolean)false);
            if (googleEnabled) {
                GoogleMetadata gmd = new GoogleMetadata(context, item);
                xmlo.output(new Text("\n"), (Writer)sw);
                for (Element e : gmd.disseminateList()) {
                    xmlo.output(e, (Writer)sw);
                    xmlo.output(new Text("\n"), (Writer)sw);
                }
            }
            headMetadata = sw.toString();
        }
        catch (CrosswalkException ce) {
            throw new ServletException((Throwable)ce);
        }
        String doi = null;
        if (this.identifierService != null) {
            doi = this.identifierService.lookup(UIUtil.obtainContext((HttpServletRequest)request), (DSpaceObject)item, DOI.class);
        }
        if (doi != null) {
            try {
                doi = this.doiService.DOIToExternalForm(doi);
            }
            catch (Exception ex) {
                doi = null;
                log.error((Object)("Unable to convert DOI '" + doi + "' into external form."), (Throwable)ex);
            }
        }
        String preferredIdentifier = null;
        if (item.getHandle() != null) {
            preferredIdentifier = this.handleService.getCanonicalForm(item.getHandle());
        }
        if ("doi".equalsIgnoreCase(ConfigurationManager.getProperty((String)"webui.preferred.identifier")) && doi != null) {
            preferredIdentifier = doi;
        }
        boolean suggestEnable = false;
        if (ConfigurationManager.getBooleanProperty((String)"webui.suggest.enable")) {
            suggestEnable = true;
            if (ConfigurationManager.getBooleanProperty((String)"webui.suggest.loggedinusers.only")) {
                suggestEnable = context.getCurrentUser() != null;
            }
        }
        DSpaceServicesFactory.getInstance().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, (DSpaceObject)item));
        request.setAttribute("suggest.enable", (Object)suggestEnable);
        request.setAttribute("display.all", (Object)displayAll);
        request.setAttribute("item", (Object)item);
        request.setAttribute("collections", (Object)collections);
        request.setAttribute("dspace.layout.head", (Object)headMetadata);
        request.setAttribute("doi", (Object)doi);
        request.setAttribute("preferred_identifier", (Object)preferredIdentifier);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/display-item.jsp");
    }

    private void preProcessItemHome(Context context, HttpServletRequest request, HttpServletResponse response, Item item) throws ServletException, IOException, SQLException {
        try {
            ItemHomeProcessor[] chp = (ItemHomeProcessor[])this.pluginService.getPluginSequence(ItemHomeProcessor.class);
            for (int i = 0; i < chp.length; ++i) {
                chp[i].process(context, request, response, item);
            }
        }
        catch (Exception e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void communityHome(Context context, HttpServletRequest request, HttpServletResponse response, Community community) throws ServletException, IOException, SQLException {
        if (!this.handleButton(request, response, community.getHandle())) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_community", (String)("community_id=" + community.getID())));
            List collections = community.getCollections();
            List subcommunities = community.getSubcommunities();
            this.preProcessCommunityHome(context, request, response, community);
            if (this.communityService.canEditBoolean(context, community)) {
                request.setAttribute("editor_button", (Object)Boolean.TRUE);
            }
            if (this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)community, 3)) {
                request.setAttribute("add_button", (Object)Boolean.TRUE);
            }
            if (this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)community, 4)) {
                request.setAttribute("remove_button", (Object)Boolean.TRUE);
            }
            DSpaceServicesFactory.getInstance().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, (DSpaceObject)community));
            request.setAttribute("community", (Object)community);
            request.setAttribute("collections", (Object)collections);
            request.setAttribute("subcommunities", (Object)subcommunities);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/community-home.jsp");
        }
    }

    private void preProcessCommunityHome(Context context, HttpServletRequest request, HttpServletResponse response, Community community) throws ServletException, IOException, SQLException {
        try {
            CommunityHomeProcessor[] chp = (CommunityHomeProcessor[])this.pluginService.getPluginSequence(CommunityHomeProcessor.class);
            for (int i = 0; i < chp.length; ++i) {
                chp[i].process(context, request, response, community);
            }
        }
        catch (Exception e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void collectionHome(Context context, HttpServletRequest request, HttpServletResponse response, Community community, Collection collection) throws ServletException, IOException, SQLException, AuthorizeException {
        if (!this.handleButton(request, response, collection.getHandle())) {
            boolean updated = false;
            if (request.getParameter("submit_subscribe") != null) {
                if (context.getCurrentUser() == null && !Authenticate.startAuthentication((Context)context, (HttpServletRequest)request, (HttpServletResponse)response)) {
                    return;
                }
                this.subscribeService.subscribe(context, context.getCurrentUser(), collection);
                updated = true;
            } else if (request.getParameter("submit_unsubscribe") != null) {
                this.subscribeService.unsubscribe(context, context.getCurrentUser(), collection);
                updated = true;
            }
            log.info((Object)LogManager.getHeader((Context)context, (String)"view_collection", (String)("collection_id=" + collection.getID())));
            this.preProcessCollectionHome(context, request, response, collection);
            EPerson e = context.getCurrentUser();
            boolean subscribed = false;
            if (e != null) {
                this.subscribeService.isSubscribed(context, e, collection);
                if (this.collectionService.canEditBoolean(context, collection, true)) {
                    request.setAttribute("editor_button", (Object)Boolean.TRUE);
                }
                if (this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)collection, 11)) {
                    request.setAttribute("admin_button", (Object)Boolean.TRUE);
                    Group group = collection.getSubmitters();
                    if (group != null) {
                        request.setAttribute("submitters", (Object)group);
                    }
                }
                if (this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)collection, 3)) {
                    request.setAttribute("can_submit_button", (Object)Boolean.TRUE);
                } else {
                    request.setAttribute("can_submit_button", (Object)Boolean.FALSE);
                }
            }
            DSpaceServicesFactory.getInstance().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, (DSpaceObject)collection));
            request.setAttribute("collection", (Object)collection);
            request.setAttribute("community", (Object)community);
            request.setAttribute("logged.in", (Object)(e != null ? 1 : 0));
            request.setAttribute("subscribed", (Object)subscribed);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/collection-home.jsp");
            if (updated) {
                context.complete();
            }
        }
    }

    private void preProcessCollectionHome(Context context, HttpServletRequest request, HttpServletResponse response, Collection collection) throws ServletException, IOException, SQLException {
        try {
            CollectionHomeProcessor[] chp = (CollectionHomeProcessor[])this.pluginService.getPluginSequence(CollectionHomeProcessor.class);
            for (int i = 0; i < chp.length; ++i) {
                chp[i].process(context, request, response, collection);
            }
        }
        catch (Exception e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private boolean handleButton(HttpServletRequest request, HttpServletResponse response, String handle) throws IOException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"");
        String location = request.getParameter("location");
        String prefix = "/";
        String url = null;
        if (location == null) {
            return false;
        }
        if (!location.equals("/")) {
            prefix = "/handle/" + location + "/";
        }
        if (button.equals("submit_search") || request.getParameter("query") != null) {
            url = request.getContextPath() + prefix + "simple-search?query=" + URLEncoder.encode(request.getParameter("query"), "UTF-8");
        }
        if (url != null) {
            response.sendRedirect(response.encodeRedirectURL(url));
            return true;
        }
        return false;
    }

    private List<Community> getParents(Context context, Community c, boolean include) throws SQLException {
        List parents = this.communityService.getAllParents(context, c);
        parents = Lists.reverse((List)parents);
        if (include) {
            parents.add(c);
        }
        return parents;
    }
}

