/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import com.sun.mail.smtp.SMTPAddressFailedException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.internet.AddressException;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.EditProfileServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authenticate.factory.AuthenticateServiceFactory;
import org.dspace.authenticate.service.AuthenticationService;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.factory.EPersonServiceFactory;
import org.dspace.eperson.service.AccountService;

public class RegisterServlet
extends EditProfileServlet {
    private static final Logger log = Logger.getLogger(RegisterServlet.class);
    public static final int ENTER_EMAIL_PAGE = 1;
    public static final int PERSONAL_INFO_PAGE = 2;
    public static final int NEW_PASSWORD_PAGE = 3;
    private boolean registering;
    private boolean ldap_enabled;
    private final transient AuthenticationService authenticationService = AuthenticateServiceFactory.getInstance().getAuthenticationService();
    private final transient AccountService accountService = EPersonServiceFactory.getInstance().getAccountService();

    public void init() throws ServletException {
        super.init();
        this.registering = this.getInitParameter("register").equalsIgnoreCase("true");
        this.ldap_enabled = ConfigurationManager.getBooleanProperty((String)"authentication-ldap", (String)"enable");
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String token = request.getParameter("token");
        if (token == null) {
            if (this.registering) {
                if (this.ldap_enabled) {
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/new-ldap-user.jsp");
                }
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/new-user.jsp");
            } else {
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/forgot-password.jsp");
            }
        } else {
            String email = this.accountService.getEmail(context, token);
            EPerson eperson = null;
            if (email != null) {
                eperson = this.personService.findByEmail(context, email);
            }
            request.setAttribute("eperson", eperson);
            request.setAttribute("token", (Object)token);
            if (this.registering && email != null) {
                boolean setPassword = this.authenticationService.allowSetPassword(context, request, email);
                request.setAttribute("set.password", (Object)setPassword);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/registration-form.jsp");
            } else if (!this.registering && eperson != null) {
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/new-password.jsp");
            } else {
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/invalid-token.jsp");
                return;
            }
        }
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int step = UIUtil.getIntParameter((HttpServletRequest)request, (String)"step");
        switch (step) {
            case 1: {
                this.processEnterEmail(context, request, response);
                break;
            }
            case 2: {
                this.processPersonalInfo(context, request, response);
                break;
            }
            case 3: {
                this.processNewPassword(context, request, response);
                break;
            }
            default: {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
    }

    private void processEnterEmail(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        block24: {
            String email = request.getParameter("email");
            email = email == null || email.length() > 64 ? "" : email.toLowerCase().trim();
            String netid = request.getParameter("netid");
            String password = request.getParameter("password");
            EPerson eperson = this.personService.findByEmail(context, email);
            EPerson eperson2 = null;
            if (netid != null) {
                eperson2 = this.personService.findByNetid(context, netid.toLowerCase());
            }
            try {
                if (this.registering) {
                    if (eperson != null && eperson.canLogIn() || eperson2 != null && eperson2.canLogIn()) {
                        log.info((Object)LogManager.getHeader((Context)context, (String)"already_registered", (String)("email=" + email)));
                        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/already-registered.jsp");
                        break block24;
                    }
                    boolean canRegister = this.authenticationService.canSelfRegister(context, request, email);
                    if (canRegister) {
                        if (!this.ldap_enabled || netid == null || netid.trim().equals("")) {
                            log.info((Object)LogManager.getHeader((Context)context, (String)"sendtoken_register", (String)("email=" + email)));
                            try {
                                this.accountService.sendRegistrationInfo(context, email);
                            }
                            catch (SendFailedException e) {
                                if (e.getNextException() instanceof SMTPAddressFailedException) {
                                    log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_email", (String)("email=" + email)));
                                    request.setAttribute("retry", (Object)Boolean.TRUE);
                                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/new-user.jsp");
                                    return;
                                }
                                throw e;
                            }
                            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/registration-sent.jsp");
                            context.complete();
                            break block24;
                        }
                        if (password != null && !password.equals("")) {
                            String ldap_provider_url = ConfigurationManager.getProperty((String)"authentication-ldap", (String)"provider_url");
                            String ldap_id_field = ConfigurationManager.getProperty((String)"authentication-ldap", (String)"id_field");
                            String ldap_search_context = ConfigurationManager.getProperty((String)"authentication-ldap", (String)"search_context");
                            Hashtable<String, String> env = new Hashtable<String, String>(11);
                            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                            env.put("java.naming.provider.url", ldap_provider_url);
                            env.put("java.naming.security.authentication", "simple");
                            env.put("java.naming.security.principal", ldap_id_field + "=" + netid + "," + ldap_search_context);
                            env.put("java.naming.security.credentials", password);
                            try {
                                InitialDirContext ctx = new InitialDirContext(env);
                                ctx.close();
                            }
                            catch (NamingException e) {
                                log.info((Object)LogManager.getHeader((Context)context, (String)"failed_login", (String)("netid=" + netid + e)));
                                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/login/ldap-incorrect.jsp");
                                return;
                            }
                        }
                        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/registration-form.jsp");
                        break block24;
                    }
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/cannot-register.jsp");
                    break block24;
                }
                if (eperson == null) {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"unknown_email", (String)("email=" + email)));
                    request.setAttribute("retry", (Object)Boolean.TRUE);
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/forgot-password.jsp");
                } else if (!eperson.canLogIn()) {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"unregistered_forgot_password", (String)("email=" + email)));
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/inactive-account.jsp");
                } else if (eperson.getRequireCertificate() && !this.registering) {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"certificate_user_forgot_password", (String)("email=" + email)));
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/error/require-certificate.jsp");
                } else {
                    log.info((Object)LogManager.getHeader((Context)context, (String)"sendtoken_forgotpw", (String)("email=" + email)));
                    this.accountService.sendForgotPasswordInfo(context, email);
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/password-token-sent.jsp");
                    context.complete();
                }
            }
            catch (AddressException ae) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"bad_email", (String)("email=" + email)));
                request.setAttribute("retry", (Object)Boolean.TRUE);
                if (this.registering) {
                    if (this.ldap_enabled) {
                        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/new-ldap-user.jsp");
                    } else {
                        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/new-user.jsp");
                    }
                } else {
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/forgot-password.jsp");
                }
            }
            catch (MessagingException me) {
                log.info((Object)LogManager.getHeader((Context)context, (String)"error_emailing", (String)("email=" + email)), (Throwable)me);
                JSPManager.showInternalError((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
    }

    private void processPersonalInfo(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String token = request.getParameter("token");
        String email = this.accountService.getEmail(context, token);
        String netid = request.getParameter("netid");
        if (netid != null && email == null) {
            email = request.getParameter("email");
        }
        if (email == null && netid == null) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_token", (String)("token=" + token)));
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/invalid-token.jsp");
            return;
        }
        EPerson eperson = null;
        if (email != null) {
            eperson = this.personService.findByEmail(context, email);
        }
        EPerson eperson2 = null;
        if (netid != null) {
            eperson2 = this.personService.findByNetid(context, netid.toLowerCase());
        }
        if (eperson2 != null) {
            eperson = eperson2;
        }
        if (eperson == null) {
            context.setIgnoreAuthorization(true);
            eperson = this.personService.create(context);
            eperson.setEmail(email);
            if (netid != null) {
                eperson.setNetid(netid.toLowerCase());
            }
            this.personService.update(context, (DSpaceObject)eperson);
            context.setIgnoreAuthorization(false);
        }
        context.setCurrentUser(eperson);
        boolean infoOK = this.updateUserProfile(context, eperson, request);
        eperson.setCanLogIn(true);
        eperson.setSelfRegistered(true);
        this.authenticationService.initEPerson(context, request, eperson);
        boolean passwordOK = true;
        if (!eperson.getRequireCertificate() && netid == null && this.authenticationService.allowSetPassword(context, request, eperson.getEmail())) {
            passwordOK = this.confirmAndSetPassword(eperson, request);
        }
        if (infoOK && passwordOK) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"usedtoken_register", (String)("email=" + eperson.getEmail())));
            if (token != null) {
                this.accountService.deleteToken(context, token);
            }
            this.personService.update(context, (DSpaceObject)eperson);
            request.setAttribute("eperson", (Object)eperson);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/registered.jsp");
            context.complete();
        } else {
            request.setAttribute("token", (Object)token);
            request.setAttribute("eperson", (Object)eperson);
            request.setAttribute("netid", (Object)netid);
            request.setAttribute("missing.fields", (Object)(!infoOK ? 1 : 0));
            request.setAttribute("password.problem", (Object)(!passwordOK ? 1 : 0));
            boolean setPassword = this.authenticationService.allowSetPassword(context, request, email);
            request.setAttribute("set.password", (Object)setPassword);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/registration-form.jsp");
            context.abort();
        }
    }

    private void processNewPassword(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String token = request.getParameter("token");
        EPerson eperson = this.accountService.getEPerson(context, token);
        if (eperson == null) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"invalid_token", (String)("token=" + token)));
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/invalid-token.jsp");
            return;
        }
        context.setCurrentUser(eperson);
        boolean passwordOK = this.confirmAndSetPassword(eperson, request);
        if (passwordOK) {
            log.info((Object)LogManager.getHeader((Context)context, (String)"usedtoken_forgotpw", (String)("email=" + eperson.getEmail())));
            this.personService.update(context, (DSpaceObject)eperson);
            this.accountService.deleteToken(context, token);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/password-changed.jsp");
            context.complete();
        } else {
            request.setAttribute("password.problem", (Object)Boolean.TRUE);
            request.setAttribute("token", (Object)token);
            request.setAttribute("eperson", (Object)eperson);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/register/new-password.jsp");
        }
    }
}

