/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.requestitem.RequestItem;
import org.dspace.app.requestitem.RequestItemAuthor;
import org.dspace.app.requestitem.RequestItemAuthorExtractor;
import org.dspace.app.requestitem.factory.RequestItemServiceFactory;
import org.dspace.app.requestitem.service.RequestItemService;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Email;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class RequestItemServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(RequestItemServlet.class);
    public static final int ENTER_FORM_PAGE = 1;
    public static final int ENTER_TOKEN = 2;
    public static final int APROVE_TOKEN = 3;
    public static final int RESUME_REQUEST = 4;
    public static final int RESUME_FREEACESS = 5;
    private final transient HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private final transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final transient BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private final transient RequestItemService requestItemService = RequestItemServiceFactory.getInstance().getRequestItemService();

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        int step = UIUtil.getIntParameter((HttpServletRequest)request, (String)"step");
        try {
            switch (step) {
                case 1: {
                    this.processForm(context, request, response);
                    break;
                }
                case 2: {
                    this.processToken(context, request, response);
                    break;
                }
                case 3: {
                    this.processLetter(context, request, response);
                    break;
                }
                case 4: {
                    this.processAttach(context, request, response);
                    break;
                }
                case 5: {
                    this.processAdmin(context, request, response);
                    break;
                }
                default: {
                    this.processForm(context, request, response);
                }
            }
            context.complete();
        }
        catch (MessagingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSGet(context, request, response);
    }

    private void processForm(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean showRequestCopy = false;
        if ("all".equalsIgnoreCase(ConfigurationManager.getProperty((String)"request.item.type")) || "logged".equalsIgnoreCase(ConfigurationManager.getProperty((String)"request.item.type")) && context.getCurrentUser() != null) {
            showRequestCopy = true;
        }
        if (!showRequestCopy) {
            throw new AuthorizeException("The request copy feature is disabled");
        }
        String handle = request.getParameter("handle");
        UUID bitstream_id = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"bitstream-id");
        String title = null;
        Item item = null;
        if (StringUtils.isNotBlank((String)handle)) {
            item = (Item)this.handleService.resolveToObject(context, handle);
        }
        if (item == null) {
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)handle, (int)-1);
        }
        if ((title = this.itemService.getMetadataFirstValue((DSpaceObject)item, "dc", "title", null, "*")) == null) {
            title = I18nUtil.getMessage((String)"jsp.general.untitled", (Context)context);
        }
        String requesterEmail = request.getParameter("email");
        EPerson currentUser = context.getCurrentUser();
        String userName = null;
        if (currentUser != null) {
            requesterEmail = currentUser.getEmail();
            userName = currentUser.getFullName();
        }
        if (request.getParameter("submit") != null) {
            String reqname = request.getParameter("reqname");
            String coment = request.getParameter("coment");
            if (coment == null || coment.equals("")) {
                coment = "";
            }
            boolean allfiles = "true".equals(request.getParameter("allfiles"));
            if (requesterEmail == null || requesterEmail.equals("") || reqname == null || reqname.equals("")) {
                request.setAttribute("handle", (Object)handle);
                request.setAttribute("bitstream-id", (Object)bitstream_id);
                request.setAttribute("reqname", (Object)reqname);
                request.setAttribute("email", (Object)requesterEmail);
                request.setAttribute("coment", (Object)coment);
                request.setAttribute("title", (Object)title);
                request.setAttribute("allfiles", (Object)(allfiles ? "true" : null));
                request.setAttribute("requestItem.problem", (Object)Boolean.TRUE);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/requestItem/request-form.jsp");
                return;
            }
            try {
                String token = this.requestItemService.createRequest(context, bitstream_id != null ? (Bitstream)this.bitstreamService.find(context, bitstream_id) : null, item, allfiles, requesterEmail, reqname, coment);
                Email email = Email.getEmail((String)I18nUtil.getEmailFilename((Locale)context.getCurrentLocale(), (String)"request_item.author"));
                RequestItemAuthor author = ((RequestItemAuthorExtractor)DSpaceServicesFactory.getInstance().getServiceManager().getServiceByName(RequestItemAuthorExtractor.class.getName(), RequestItemAuthorExtractor.class)).getRequestItemAuthor(context, item);
                String authorEmail = author.getEmail();
                String authorName = author.getFullName();
                email.addRecipient(authorEmail);
                email.addArgument((Object)reqname);
                email.addArgument((Object)requesterEmail);
                email.addArgument((Object)(allfiles ? I18nUtil.getMessage((String)"itemRequest.all") : ((Bitstream)this.bitstreamService.find(context, bitstream_id)).getName()));
                email.addArgument((Object)this.handleService.getCanonicalForm(item.getHandle()));
                email.addArgument((Object)title);
                email.addArgument((Object)coment);
                email.addArgument((Object)token);
                email.addArgument((Object)authorName);
                email.addArgument((Object)authorEmail);
                email.addArgument((Object)ConfigurationManager.getProperty((String)"dspace.name"));
                email.addArgument((Object)ConfigurationManager.getProperty((String)"mail.helpdesk"));
                email.setReplyTo(requesterEmail);
                email.send();
                log.info((Object)LogManager.getHeader((Context)context, (String)"sent_email_requestItem", (String)("submitter_id=" + requesterEmail + ",bitstream_id=" + bitstream_id + ",requestEmail=" + requesterEmail)));
                request.setAttribute("handle", (Object)handle);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/requestItem/request-send.jsp");
            }
            catch (MessagingException me) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"error_mailing_requestItem", (String)""), (Throwable)me);
                JSPManager.showInternalError((HttpServletRequest)request, (HttpServletResponse)response);
            }
        } else {
            log.info((Object)LogManager.getHeader((Context)context, (String)"show_requestItem_form", (String)"problem=false"));
            request.setAttribute("handle", (Object)handle);
            request.setAttribute("bitstream-id", (Object)bitstream_id);
            request.setAttribute("email", (Object)requesterEmail);
            request.setAttribute("reqname", (Object)userName);
            request.setAttribute("title", (Object)title);
            request.setAttribute("allfiles", (Object)"true");
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/requestItem/request-form.jsp");
        }
    }

    private void processToken(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String token = request.getParameter("token");
        RequestItem requestItem = this.requestItemService.findByToken(context, token);
        if (requestItem != null) {
            Item item = requestItem.getItem();
            String title = "";
            String handle = "";
            if (item != null) {
                title = this.itemService.getMetadataFirstValue((DSpaceObject)item, "dc", "title", null, "*");
                if (title == null) {
                    title = "";
                }
                handle = item.getHandle();
            }
            request.setAttribute("request-name", (Object)requestItem.getReqName());
            request.setAttribute("handle", (Object)handle);
            request.setAttribute("title", (Object)title);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/requestItem/request-information.jsp");
        } else {
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (int)-1);
        }
    }

    private void processLetter(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException, MessagingException {
        String token = request.getParameter("token");
        boolean yes = request.getParameter("submit_yes") != null;
        boolean no = request.getParameter("submit_no") != null;
        RequestItem requestItem = this.requestItemService.findByToken(context, token);
        if (requestItem != null && (yes || no)) {
            Item item = requestItem.getItem();
            String title = this.itemService.getMetadataFirstValue((DSpaceObject)item, "dc", "title", null, "*");
            title = title != null ? title : I18nUtil.getMessage((String)"jsp.general.untitled", (Context)context);
            EPerson submiter = item.getSubmitter();
            Object[] args = new String[]{requestItem.getReqName(), this.handleService.getCanonicalForm(item.getHandle()), title, submiter.getFullName(), submiter.getEmail()};
            String subject = I18nUtil.getMessage((String)("itemRequest.response.subject." + (yes ? "approve" : "reject")), (Context)context);
            String message = MessageFormat.format(I18nUtil.getMessage((String)("itemRequest.response.body." + (yes ? "approve" : "reject")), (Context)context), args);
            request.setAttribute("response", (Object)yes);
            request.setAttribute("subject", (Object)subject);
            request.setAttribute("message", (Object)message);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/requestItem/request-letter.jsp");
        } else {
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (int)-1);
        }
    }

    private void processAttach(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        boolean submit_next;
        String token = request.getParameter("token");
        boolean bl = submit_next = request.getParameter("submit_next") != null;
        if (submit_next) {
            RequestItem requestItem = this.requestItemService.findByToken(context, token);
            if (requestItem != null) {
                String subject = request.getParameter("subject");
                String message = request.getParameter("message");
                boolean accept = UIUtil.getBoolParameter((HttpServletRequest)request, (String)"accept_request");
                try {
                    Item item = requestItem.getItem();
                    Email email = new Email();
                    email.setSubject(subject);
                    email.setContent("{0}");
                    email.addRecipient(requestItem.getReqEmail());
                    email.addArgument((Object)message);
                    if (accept) {
                        if (requestItem.getBitstream() == null) {
                            List bundles = this.itemService.getBundles(item, "ORIGINAL");
                            for (Bundle b : bundles) {
                                List bbitstreams = b.getBitstreams();
                                for (Bitstream bitstream : bbitstreams) {
                                    if (bitstream.getFormat(context).isInternal() || !this.authorizeService.authorizeActionBoolean(context, null, (DSpaceObject)bitstream, 0, false)) continue;
                                    email.addAttachment(this.bitstreamService.retrieve(context, bitstream), bitstream.getName(), bitstream.getFormat(context).getMIMEType());
                                }
                            }
                        } else {
                            Bitstream bit = requestItem.getBitstream();
                            email.addAttachment(this.bitstreamService.retrieve(context, bit), bit.getName(), bit.getFormat(context).getMIMEType());
                        }
                    }
                    email.send();
                    requestItem.setAccept_request(accept);
                    requestItem.setDecision_date(new Date());
                    this.requestItemService.update(context, requestItem);
                    log.info((Object)LogManager.getHeader((Context)context, (String)"sent_attach_requestItem", (String)("token=" + token)));
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/requestItem/request-free-access.jsp");
                }
                catch (MessagingException me) {
                    log.warn((Object)LogManager.getHeader((Context)context, (String)"error_mailing_requestItem", (String)""), (Throwable)me);
                    JSPManager.showInternalError((HttpServletRequest)request, (HttpServletResponse)response);
                }
            } else {
                JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, null, (int)-1);
            }
        } else {
            this.processToken(context, request, response);
        }
    }

    private void processAdmin(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String token = request.getParameter("token");
        boolean free = request.getParameter("submit_free") != null;
        String name = request.getParameter("name");
        String mail = request.getParameter("email");
        RequestItem requestItem = this.requestItemService.findByToken(context, token);
        if (requestItem != null && free) {
            try {
                Item item = requestItem.getItem();
                EPerson submiter = item.getSubmitter();
                String emailRequest = submiter != null ? submiter.getEmail() : ConfigurationManager.getProperty((String)"mail.helpdesk");
                if (emailRequest == null) {
                    emailRequest = ConfigurationManager.getProperty((String)"mail.admin");
                }
                Email email = Email.getEmail((String)I18nUtil.getEmailFilename((Locale)context.getCurrentLocale(), (String)"request_item.admin"));
                email.addRecipient(emailRequest);
                email.addArgument((Object)requestItem.getBitstream().getName());
                email.addArgument((Object)this.handleService.getCanonicalForm(item.getHandle()));
                email.addArgument((Object)requestItem.getToken());
                email.addArgument((Object)name);
                email.addArgument((Object)mail);
                email.send();
                log.info((Object)LogManager.getHeader((Context)context, (String)"sent_adm_requestItem", (String)("token=" + requestItem.getToken() + "item_id=" + item.getID())));
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/requestItem/response-send.jsp");
            }
            catch (MessagingException me) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"error_mailing_requestItem", (String)""), (Throwable)me);
                JSPManager.showInternalError((HttpServletRequest)request, (HttpServletResponse)response);
            }
        } else {
            JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (int)-1);
        }
    }

    public static String getLinkTokenEmail(Context context, String token) throws SQLException {
        String base = ConfigurationManager.getProperty((String)"dspace.url");
        String specialLink = new StringBuffer().append(base).append(base.endsWith("/") ? "" : "/").append("request-item").append("?step=").append(2).append("&token=").append(token).toString();
        return specialLink;
    }
}

