/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import com.google.gson.Gson;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.FileUploadRequest;
import org.dspace.app.webui.util.JSONUploadResponse;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.WorkspaceItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.submit.AbstractProcessingStep;
import org.dspace.submit.step.UploadStep;
import org.dspace.workflow.WorkflowItem;
import org.dspace.workflow.WorkflowItemService;
import org.dspace.workflowbasic.factory.BasicWorkflowServiceFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class SubmissionController
extends DSpaceServlet {
    public static final int SELECT_COLLECTION = 0;
    public static final int FIRST_STEP = 1;
    public static final int WORKFLOW_FIRST_STEP = 0;
    private static final String COMPLETE_JSP = "/submit/complete.jsp";
    private String tempDir = null;
    private static Object mutex = new Object();
    private static Logger log = Logger.getLogger(SubmissionController.class);
    private static WorkspaceItemService workspaceItemService;
    private static BitstreamService bitstreamService;
    private static BundleService bundleService;
    private static WorkflowItemService workflowItemService;

    public void init() throws ServletException {
        super.init();
        workspaceItemService = ContentServiceFactory.getInstance().getWorkspaceItemService();
        bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
        bundleService = ContentServiceFactory.getInstance().getBundleService();
        workflowItemService = BasicWorkflowServiceFactory.getInstance().getBasicWorkflowItemService();
    }

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String workspaceID = request.getParameter("resume");
        String workflowID = request.getParameter("workflow");
        String resumableFilename = request.getParameter("resumableFilename");
        if (workspaceID != null) {
            try {
                WorkspaceItem wi = workspaceItemService.find(context, Integer.parseInt(workspaceID));
                SubmissionInfo si = SubmissionInfo.load((HttpServletRequest)request, (InProgressSubmission)wi);
                if (SubmissionController.getStepReached((SubmissionInfo)si) >= si.getSubmissionConfig().getNumberOfSteps()) {
                    int lastStep = si.getSubmissionConfig().getNumberOfSteps() - 1;
                    wi.setStageReached(lastStep);
                    wi.setPageReached(Integer.MAX_VALUE);
                    workspaceItemService.update(context, (InProgressSubmission)wi);
                    si.setSubmissionItem((InProgressSubmission)wi);
                }
                SubmissionController.setBeginningOfStep((HttpServletRequest)request, (boolean)true);
                this.doStep(context, request, response, si, 1);
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"bad_workspace_id", (String)("bad_id=" + workspaceID)));
                JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)workspaceID, (int)-1);
            }
        } else if (workflowID != null) {
            try {
                WorkflowItem wi = workflowItemService.find(context, Integer.parseInt(workflowID));
                SubmissionInfo si = SubmissionInfo.load((HttpServletRequest)request, (InProgressSubmission)wi);
                SubmissionController.setBeginningOfStep((HttpServletRequest)request, (boolean)true);
                this.doStep(context, request, response, si, 0);
            }
            catch (NumberFormatException nfe) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"bad_workflow_id", (String)("bad_id=" + workflowID)));
                JSPManager.showInvalidIDError((HttpServletRequest)request, (HttpServletResponse)response, (String)workflowID, (int)-1);
            }
        } else if (!StringUtils.isEmpty((String)resumableFilename)) {
            if (request.getMethod().equals("GET")) {
                this.DoGetResumable(request, response);
            }
        } else {
            this.doDSPost(context, request, response);
        }
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        SubmissionInfo subInfo;
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            block23: {
                try {
                    request = this.wrapMultipartRequest(request);
                    String resumableFilename = request.getParameter("resumableFilename");
                    if (StringUtils.isEmpty((String)resumableFilename)) break block23;
                    log.debug((Object)("resumable Filename: '" + resumableFilename + "'."));
                    File completedFile = null;
                    try {
                        log.debug((Object)"Starting doPostResumable method.");
                        completedFile = this.doPostResumable(request);
                    }
                    catch (IOException e) {
                        response.sendError(416);
                    }
                    if (completedFile == null) {
                        log.debug((Object)"Got one file chunk, but the upload is not completed yet.");
                        return;
                    }
                    log.debug((Object)"Going to assemble file chunks.");
                    if (completedFile.length() > 0L) {
                        String fileName = completedFile.getName();
                        String filePath = this.tempDir + File.separator + fileName;
                        BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(completedFile));
                        SubmissionInfo si = SubmissionController.getSubmissionInfo((Context)context, (HttpServletRequest)request);
                        UploadStep us = new UploadStep();
                        request.setAttribute(fileName + "-path", (Object)filePath);
                        request.setAttribute(fileName + "-inputstream", (Object)fileInputStream);
                        request.setAttribute(fileName + "-description", (Object)request.getParameter("description"));
                        int uploadResult = us.processUploadFile(context, request, response, si);
                        if (!completedFile.delete()) {
                            log.error((Object)("Unable to delete temporary file " + filePath));
                        }
                        if (uploadResult != 0) {
                            response.sendError(500);
                            return;
                        }
                    }
                    return;
                }
                catch (FileUploadBase.FileSizeLimitExceededException e) {
                    log.warn((Object)"Upload exceeded upload.max");
                    if (ConfigurationManager.getBooleanProperty((String)"webui.submit.upload.progressbar", (boolean)true)) {
                        Gson gson = new Gson();
                        response.setContentType("text/html");
                        JSONUploadResponse jsonResponse = new JSONUploadResponse();
                        jsonResponse.addUploadFileSizeLimitExceeded(e.getActualSize(), e.getPermittedSize());
                        response.getWriter().print(gson.toJson((Object)jsonResponse));
                        response.flushBuffer();
                    } else {
                        JSPManager.showFileSizeLimitExceededError((HttpServletRequest)request, (HttpServletResponse)response, (String)e.getMessage(), (long)e.getActualSize(), (long)e.getPermittedSize());
                    }
                    return;
                }
            }
            this.uploadFiles(context, request);
        }
        if ((subInfo = SubmissionController.getSubmissionInfo((Context)context, (HttpServletRequest)request)) == null) {
            if (request.getSession().getAttribute("removed_thesis") != null) {
                request.getSession().removeAttribute("removed_thesis");
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/submit/thesis-removed-workaround.jsp");
                return;
            }
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
            JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        if (UIUtil.getSubmitButton((HttpServletRequest)request, (String)"").equals("submit_cancel")) {
            SubmissionStepConfig currentStepConfig = SubmissionController.getCurrentStepConfig((HttpServletRequest)request, (SubmissionInfo)subInfo);
            this.doCancelOrSave(context, request, response, subInfo, currentStepConfig);
        } else if (subInfo.getSubmissionItem() == null) {
            this.doStep(context, request, response, subInfo, 0);
        } else {
            SubmissionStepConfig currentStepConfig = SubmissionController.getCurrentStepConfig((HttpServletRequest)request, (SubmissionInfo)subInfo);
            if (UIUtil.getBoolParameter((HttpServletRequest)request, (String)"cancellation")) {
                this.processCancelOrSave(context, request, response, subInfo, currentStepConfig);
            } else if (UIUtil.getSubmitButton((HttpServletRequest)request, (String)"").startsWith("submit_prev")) {
                this.doPreviousStep(context, request, response, subInfo, currentStepConfig);
            } else if (UIUtil.getSubmitButton((HttpServletRequest)request, (String)"").startsWith("submit_jump_")) {
                this.doStepJump(context, request, response, subInfo, currentStepConfig);
            } else {
                this.doStep(context, request, response, subInfo, currentStepConfig.getStepNumber());
            }
        }
    }

    private void doStep(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int stepNumber) throws ServletException, IOException, SQLException, AuthorizeException {
        SubmissionStepConfig currentStepConfig = null;
        if (subInfo.getSubmissionConfig() != null) {
            currentStepConfig = subInfo.getSubmissionConfig().getStep(stepNumber);
        } else {
            log.fatal((Object)LogManager.getHeader((Context)context, (String)"no_submission_process", (String)("trying to load step=" + stepNumber + ", but submission process is null")));
            JSPManager.showInternalError((HttpServletRequest)request, (HttpServletResponse)response);
        }
        if (!subInfo.isInWorkflow() && currentStepConfig.getStepNumber() > SubmissionController.getStepReached((SubmissionInfo)subInfo)) {
            this.userHasReached(context, subInfo, currentStepConfig.getStepNumber());
            SubmissionController.setBeginningOfStep((HttpServletRequest)request, (boolean)true);
        }
        SubmissionController.saveCurrentStepConfig((HttpServletRequest)request, (SubmissionStepConfig)currentStepConfig);
        log.debug((Object)("Calling Step Class: '" + currentStepConfig.getProcessingClassName() + "'"));
        try {
            JSPStepManager stepManager = JSPStepManager.loadStep((SubmissionStepConfig)currentStepConfig);
            boolean stepFinished = stepManager.processStep(context, request, response, subInfo);
            if (stepFinished) {
                if (request instanceof FileUploadRequest) {
                    request = ((FileUploadRequest)request).getOriginalRequest();
                }
                subInfo = SubmissionController.getSubmissionInfo((Context)context, (HttpServletRequest)request);
                this.doNextStep(context, request, response, subInfo, currentStepConfig);
            } else {
                context.complete();
            }
        }
        catch (Exception e) {
            log.error((Object)("Error loading step class'" + currentStepConfig.getProcessingClassName() + "':"), (Throwable)e);
            JSPManager.showInternalError((HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    private void doNextStep(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, SubmissionStepConfig currentStepConfig) throws ServletException, IOException, SQLException, AuthorizeException {
        int currentStepNum = currentStepConfig == null ? -1 : currentStepConfig.getStepNumber();
        if (subInfo.getSubmissionConfig().hasMoreSteps(currentStepNum)) {
            SubmissionController.setBeginningOfStep((HttpServletRequest)request, (boolean)true);
            this.doStep(context, request, response, subInfo, ++currentStepNum);
        } else if (subInfo.isInWorkflow()) {
            request.setAttribute("workflow.item", (Object)subInfo.getSubmissionItem());
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/perform-task.jsp");
        } else {
            SubmissionController.saveSubmissionInfo((HttpServletRequest)request, (SubmissionInfo)subInfo);
            SubmissionController.showProgressAwareJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)"/submit/complete.jsp");
        }
    }

    private void doPreviousStep(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, SubmissionStepConfig currentStepConfig) throws ServletException, IOException, SQLException, AuthorizeException {
        int result = this.doSaveCurrentState(context, request, response, subInfo, currentStepConfig);
        int currentStepNum = currentStepConfig == null ? -1 : currentStepConfig.getStepNumber();
        int currPage = AbstractProcessingStep.getCurrentPage((HttpServletRequest)request);
        double currStepAndPage = Double.parseDouble(currentStepNum + "." + currPage);
        double stepAndPageReached = -1.0;
        if (!subInfo.isInWorkflow()) {
            stepAndPageReached = Double.parseDouble(SubmissionController.getStepReached((SubmissionInfo)subInfo) + "." + JSPStepManager.getPageReached((SubmissionInfo)subInfo));
        }
        if (result != 0 && currStepAndPage != stepAndPageReached) {
            this.doStep(context, request, response, subInfo, currentStepNum);
        }
        int currentPageNum = AbstractProcessingStep.getCurrentPage((HttpServletRequest)request);
        boolean foundPrevious = false;
        if (currentPageNum > 1) {
            AbstractProcessingStep.setCurrentPage((HttpServletRequest)request, (int)(currentPageNum - 1));
            foundPrevious = true;
            SubmissionController.setBeginningOfStep((HttpServletRequest)request, (boolean)true);
            this.doStep(context, request, response, subInfo, currentStepNum);
        } else if (currentStepNum > 1) {
            currentStepConfig = SubmissionController.getPreviousVisibleStep((HttpServletRequest)request, (SubmissionInfo)subInfo);
            if (currentStepConfig != null) {
                currentStepNum = currentStepConfig.getStepNumber();
                foundPrevious = true;
            }
            if (foundPrevious) {
                request.setAttribute("step.backwards", (Object)Boolean.TRUE);
                SubmissionController.setBeginningOfStep((HttpServletRequest)request, (boolean)true);
                this.doStep(context, request, response, subInfo, currentStepNum);
            }
        }
        if (!foundPrevious) {
            log.error((Object)LogManager.getHeader((Context)context, (String)"no_previous_visible_step", (String)("Attempting to go to previous step for step=" + currentStepNum + "." + "NO PREVIOUS VISIBLE STEP OR PAGE FOUND!")));
            JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    private void doStepJump(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, SubmissionStepConfig currentStepConfig) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"");
        int nextStep = -1;
        int nextPage = -1;
        if (buttonPressed.startsWith("submit_jump_")) {
            try {
                String stepAndPage = buttonPressed.substring(12);
                String[] fields = stepAndPage.split("\\.");
                nextStep = Integer.parseInt(fields[0]);
                nextPage = Integer.parseInt(fields[1]);
            }
            catch (NumberFormatException ne) {
                nextStep = -1;
                nextPage = -1;
            }
            if (!subInfo.isInWorkflow() && nextStep < 1 || subInfo.isInWorkflow() && nextStep < 0) {
                nextStep = -1;
                nextPage = -1;
            }
            if (!subInfo.isInWorkflow() && nextStep > SubmissionController.getStepReached((SubmissionInfo)subInfo)) {
                nextStep = -1;
            }
        }
        if (nextStep == -1) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
            JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
        } else {
            int result = this.doSaveCurrentState(context, request, response, subInfo, currentStepConfig);
            if (request instanceof FileUploadRequest) {
                FileUploadRequest fur = (FileUploadRequest)request;
                request = fur.getOriginalRequest();
            }
            int currStep = currentStepConfig.getStepNumber();
            int currPage = AbstractProcessingStep.getCurrentPage((HttpServletRequest)request);
            double currStepAndPage = Double.parseDouble(currStep + "." + currPage);
            double stepAndPageReached = -1.0;
            if (!subInfo.isInWorkflow()) {
                stepAndPageReached = Double.parseDouble(SubmissionController.getStepReached((SubmissionInfo)subInfo) + "." + JSPStepManager.getPageReached((SubmissionInfo)subInfo));
            }
            if (result != 0 && currStepAndPage != stepAndPageReached) {
                this.doStep(context, request, response, subInfo, currStep);
            } else {
                AbstractProcessingStep.setCurrentPage((HttpServletRequest)request, (int)nextPage);
                SubmissionController.setBeginningOfStep((HttpServletRequest)request, (boolean)true);
                log.debug((Object)("Jumping to Step " + nextStep + " and Page " + nextPage));
                this.doStep(context, request, response, subInfo, nextStep);
            }
        }
    }

    private void doCancelOrSave(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, SubmissionStepConfig stepConfig) throws ServletException, IOException, SQLException, AuthorizeException {
        if (subInfo.isInWorkflow()) {
            int result = this.doSaveCurrentState(context, request, response, subInfo, stepConfig);
            if (result == 0) {
                request.setAttribute("workflow.item", (Object)subInfo.getSubmissionItem());
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/mydspace/perform-task.jsp");
            } else {
                int currStep = stepConfig.getStepNumber();
                this.doStep(context, request, response, subInfo, currStep);
            }
        } else if (subInfo.getSubmissionItem() == null) {
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/submit/cancelled-removed.jsp");
        } else {
            SubmissionController.setCancellationInProgress((HttpServletRequest)request, (boolean)true);
            int result = this.doSaveCurrentState(context, request, response, subInfo, stepConfig);
            int currStep = stepConfig.getStepNumber();
            int currPage = AbstractProcessingStep.getCurrentPage((HttpServletRequest)request);
            double currStepAndPage = Float.parseFloat(currStep + "." + currPage);
            double stepAndPageReached = Float.parseFloat(SubmissionController.getStepReached((SubmissionInfo)subInfo) + "." + JSPStepManager.getPageReached((SubmissionInfo)subInfo));
            if (result != 0 && currStepAndPage < stepAndPageReached) {
                this.setReachedStepAndPage(context, subInfo, currStep, currPage);
            }
            context.complete();
            SubmissionController.saveSubmissionInfo((HttpServletRequest)request, (SubmissionInfo)subInfo);
            SubmissionController.saveCurrentStepConfig((HttpServletRequest)request, (SubmissionStepConfig)stepConfig);
            SubmissionController.showProgressAwareJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)"/submit/cancel.jsp");
        }
    }

    private int doSaveCurrentState(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, SubmissionStepConfig stepConfig) throws ServletException {
        int result = -1;
        try {
            log.debug((Object)("Cancel/Save or Jump/Previous Request: calling processing for Step: '" + stepConfig.getProcessingClassName() + "'"));
            try {
                ClassLoader loader = this.getClass().getClassLoader();
                Class<?> stepClass = loader.loadClass(stepConfig.getProcessingClassName());
                AbstractProcessingStep step = (AbstractProcessingStep)stepClass.newInstance();
                result = step.doProcessing(context, request, response, subInfo);
            }
            catch (Exception e) {
                log.error((Object)("Error loading step class'" + stepConfig.getProcessingClassName() + "':"), (Throwable)e);
                JSPManager.showInternalError((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        return result;
    }

    private void processCancelOrSave(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, SubmissionStepConfig currentStepConfig) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_back");
        if (buttonPressed.equals("submit_back")) {
            SubmissionController.setBeginningOfStep((HttpServletRequest)request, (boolean)true);
            this.doStep(context, request, response, subInfo, currentStepConfig.getStepNumber());
        } else if (buttonPressed.equals("submit_remove")) {
            WorkspaceItem wi = (WorkspaceItem)subInfo.getSubmissionItem();
            workspaceItemService.deleteAll(context, wi);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/submit/cancelled-removed.jsp");
            context.complete();
        } else if (buttonPressed.equals("submit_keep")) {
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/submit/saved.jsp");
        } else {
            this.doStepJump(context, request, response, subInfo, currentStepConfig);
        }
    }

    private static void showProgressAwareJSP(HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, String jspPath) throws ServletException, IOException {
        SubmissionController.saveSubmissionInfo((HttpServletRequest)request, (SubmissionInfo)subInfo);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)jspPath);
    }

    public static SubmissionInfo getSubmissionInfo(Context context, HttpServletRequest request) throws SQLException, ServletException {
        SubmissionInfo info = null;
        if (request.getAttribute("submission.info") != null) {
            info = (SubmissionInfo)request.getAttribute("submission.info");
        } else {
            if (request.getParameter("workflow_id") != null) {
                int workflowID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"workflow_id");
                info = SubmissionInfo.load((HttpServletRequest)request, (InProgressSubmission)workflowItemService.find(context, workflowID));
            } else if (request.getParameter("workspace_item_id") != null) {
                int workspaceID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"workspace_item_id");
                info = SubmissionInfo.load((HttpServletRequest)request, (InProgressSubmission)workspaceItemService.find(context, workspaceID));
            } else {
                info = SubmissionInfo.load((HttpServletRequest)request, null);
            }
            if (SubmissionController.getStepReached((SubmissionInfo)info) > 1 && info.getSubmissionItem() == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"cannot_load_submission_info", (String)"InProgressSubmission is null!"));
                return null;
            }
            if (request.getParameter("bundle_id") != null) {
                UUID bundleID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"bundle_id");
                info.setBundle((Bundle)bundleService.find(context, bundleID));
            }
            if (request.getParameter("bitstream_id") != null) {
                UUID bitstreamID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"bitstream_id");
                info.setBitstream((Bitstream)bitstreamService.find(context, bitstreamID));
            }
            SubmissionController.saveSubmissionInfo((HttpServletRequest)request, (SubmissionInfo)info);
        }
        return info;
    }

    public static void saveSubmissionInfo(HttpServletRequest request, SubmissionInfo si) {
        request.setAttribute("submission.info", (Object)si);
    }

    public static SubmissionStepConfig getCurrentStepConfig(HttpServletRequest request, SubmissionInfo si) {
        int stepNum = -1;
        SubmissionStepConfig step = (SubmissionStepConfig)request.getAttribute("step");
        if (step == null) {
            stepNum = UIUtil.getIntParameter((HttpServletRequest)request, (String)"step");
            if (stepNum < 0 || si == null || si.getSubmissionConfig() == null) {
                return null;
            }
            return si.getSubmissionConfig().getStep(stepNum);
        }
        return step;
    }

    public static void saveCurrentStepConfig(HttpServletRequest request, SubmissionStepConfig step) {
        request.setAttribute("step", (Object)step);
    }

    public static boolean isFirstStep(HttpServletRequest request, SubmissionInfo si) {
        SubmissionStepConfig step = SubmissionController.getCurrentStepConfig((HttpServletRequest)request, (SubmissionInfo)si);
        return step != null && SubmissionController.getPreviousVisibleStep((HttpServletRequest)request, (SubmissionInfo)si) == null;
    }

    public static SubmissionStepConfig getPreviousVisibleStep(HttpServletRequest request, SubmissionInfo si) {
        SubmissionStepConfig step = SubmissionController.getCurrentStepConfig((HttpServletRequest)request, (SubmissionInfo)si);
        SubmissionStepConfig previousStep = null;
        int currentStepNum = step.getStepNumber();
        while (currentStepNum > 1) {
            SubmissionStepConfig currentStepConfig = si.getSubmissionConfig().getStep(--currentStepNum);
            if (!currentStepConfig.isVisible()) continue;
            previousStep = currentStepConfig;
            break;
        }
        return previousStep;
    }

    public static boolean isBeginningOfStep(HttpServletRequest request) {
        Boolean stepStart = (Boolean)request.getAttribute("step.start");
        if (stepStart != null) {
            return stepStart;
        }
        return false;
    }

    public static void setBeginningOfStep(HttpServletRequest request, boolean beginningOfStep) {
        request.setAttribute("step.start", (Object)beginningOfStep);
    }

    public static boolean isCancellationInProgress(HttpServletRequest request) {
        Boolean cancellation = (Boolean)request.getAttribute("submission.cancellation");
        if (cancellation != null) {
            return cancellation;
        }
        return false;
    }

    private static void setCancellationInProgress(HttpServletRequest request, boolean cancellationInProgress) {
        request.setAttribute("submission.cancellation", (Object)cancellationInProgress);
    }

    public static String getSubmissionParameters(Context context, HttpServletRequest request) throws SQLException, ServletException {
        SubmissionInfo si = SubmissionController.getSubmissionInfo((Context)context, (HttpServletRequest)request);
        SubmissionStepConfig step = SubmissionController.getCurrentStepConfig((HttpServletRequest)request, (SubmissionInfo)si);
        String info = "";
        if (si.getSubmissionItem() != null && si.isInWorkflow()) {
            info = info + "<input type=\"hidden\" name=\"workflow_id\" value=\"" + si.getSubmissionItem().getID() + "\"/>";
        } else if (si.getSubmissionItem() != null) {
            info = info + "<input type=\"hidden\" name=\"workspace_item_id\" value=\"" + si.getSubmissionItem().getID() + "\"/>";
        }
        if (si.getBundle() != null) {
            info = info + "<input type=\"hidden\" name=\"bundle_id\" value=\"" + si.getBundle().getID() + "\"/>";
        }
        if (si.getBitstream() != null) {
            info = info + "<input type=\"hidden\" name=\"bitstream_id\" value=\"" + si.getBitstream().getID() + "\"/>";
        }
        if (step != null) {
            info = info + "<input type=\"hidden\" name=\"step\" value=\"" + step.getStepNumber() + "\"/>";
        }
        int page = AbstractProcessingStep.getCurrentPage((HttpServletRequest)request);
        info = info + "<input type=\"hidden\" name=\"page\" value=\"" + page + "\"/>";
        String jspDisplayed = JSPStepManager.getLastJSPDisplayed((HttpServletRequest)request);
        info = info + "<input type=\"hidden\" name=\"jsp\" value=\"" + jspDisplayed + "\"/>";
        return info;
    }

    private void userHasReached(Context c, SubmissionInfo subInfo, int step) throws SQLException, AuthorizeException, IOException {
        WorkspaceItem wi;
        if (!subInfo.isInWorkflow() && subInfo.getSubmissionItem() != null && step > (wi = (WorkspaceItem)subInfo.getSubmissionItem()).getStageReached()) {
            wi.setStageReached(step);
            wi.setPageReached(1);
            workspaceItemService.update(c, (InProgressSubmission)wi);
        }
    }

    private void setReachedStepAndPage(Context c, SubmissionInfo subInfo, int step, int page) throws SQLException, AuthorizeException, IOException {
        if (!subInfo.isInWorkflow() && subInfo.getSubmissionItem() != null) {
            WorkspaceItem wi = (WorkspaceItem)subInfo.getSubmissionItem();
            wi.setStageReached(step);
            wi.setPageReached(page);
            workspaceItemService.update(c, (InProgressSubmission)wi);
        }
    }

    public static int getStepReached(SubmissionInfo subInfo) {
        if (subInfo == null || subInfo.isInWorkflow() || subInfo.getSubmissionItem() == null) {
            return -1;
        }
        WorkspaceItem wi = (WorkspaceItem)subInfo.getSubmissionItem();
        int i = wi.getStageReached();
        if (i == -1) {
            i = 1;
        }
        return i;
    }

    private HttpServletRequest wrapMultipartRequest(HttpServletRequest request) throws ServletException, FileUploadBase.FileSizeLimitExceededException {
        try {
            if (!Class.forName("org.dspace.app.webui.util.FileUploadRequest").isInstance(request)) {
                FileUploadRequest wrappedRequest = new FileUploadRequest(request);
                return wrappedRequest;
            }
            return request;
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            throw new FileUploadBase.FileSizeLimitExceededException(e.getMessage(), e.getActualSize(), e.getPermittedSize());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void uploadFiles(Context context, HttpServletRequest request) throws ServletException {
        FileUploadRequest wrapper = null;
        String filePath = null;
        BufferedInputStream fileInputStream = null;
        try {
            wrapper = Class.forName("org.dspace.app.webui.util.FileUploadRequest").isInstance(request) ? (FileUploadRequest)request : new FileUploadRequest(request);
            log.debug((Object)"Did not recoginze resumable upload, falling back to simple upload.");
            Enumeration fileParams = wrapper.getFileParameterNames();
            while (fileParams.hasMoreElements()) {
                String fileName = (String)fileParams.nextElement();
                File temp = wrapper.getFile(fileName);
                if (temp == null || temp.length() <= 0L) continue;
                fileInputStream = new BufferedInputStream(new FileInputStream(temp));
                filePath = wrapper.getFilesystemName(fileName);
                if (!temp.delete()) {
                    log.error((Object)"Unable to delete temporary file");
                }
                request.setAttribute(fileName + "-path", (Object)filePath);
                request.setAttribute(fileName + "-inputstream", (Object)fileInputStream);
                request.setAttribute(fileName + "-description", (Object)wrapper.getParameter("description"));
            }
        }
        catch (Exception e) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"upload_error", (String)""), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected void DoGetResumable(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String chunkPath;
        File chunkFile;
        this.tempDir = ConfigurationManager.getProperty((String)"upload.temp.dir") != null ? ConfigurationManager.getProperty((String)"upload.temp.dir") : System.getProperty("java.io.tmpdir");
        String resumableIdentifier = request.getParameter("resumableIdentifier");
        String resumableChunkNumber = request.getParameter("resumableChunkNumber");
        long resumableCurrentChunkSize = Long.valueOf(request.getParameter("resumableCurrentChunkSize"));
        this.tempDir = this.tempDir + File.separator + resumableIdentifier;
        File fileDir = new File(this.tempDir);
        if (!fileDir.exists()) {
            fileDir.mkdir();
        }
        if ((chunkFile = new File(chunkPath = this.tempDir + File.separator + "part" + resumableChunkNumber)).exists()) {
            if (chunkFile.length() == resumableCurrentChunkSize) {
                response.setStatus(200);
                return;
            }
            chunkFile.delete();
        }
        response.sendError(404);
    }

    protected File doPostResumable(HttpServletRequest request) throws FileUploadBase.FileSizeLimitExceededException, IOException, ServletException {
        File completedFile = null;
        FileUploadRequest wrapper = null;
        this.tempDir = ConfigurationManager.getProperty((String)"upload.temp.dir") != null ? ConfigurationManager.getProperty((String)"upload.temp.dir") : System.getProperty("java.io.tmpdir");
        try {
            wrapper = Class.forName("org.dspace.app.webui.util.FileUploadRequest").isInstance(request) ? (FileUploadRequest)request : new FileUploadRequest(request);
        }
        catch (ClassNotFoundException ex) {
            log.fatal((Object)"Cannot find class org.dspace.app.webui.util.FileUploadRequest");
            throw new ServletException("Cannot find class org.dspace.app.webui.util.FileUploadRequest.", (Throwable)ex);
        }
        String resumableIdentifier = wrapper.getParameter("resumableIdentifier");
        long resumableTotalSize = Long.valueOf(wrapper.getParameter("resumableTotalSize"));
        int resumableTotalChunks = Integer.valueOf(wrapper.getParameter("resumableTotalChunks"));
        String chunkDirPath = this.tempDir + File.separator + resumableIdentifier;
        File chunkDirPathFile = new File(chunkDirPath);
        boolean foundAll = true;
        long currentSize = 0L;
        if (chunkDirPathFile.exists()) {
            for (int p = 1; p <= resumableTotalChunks; ++p) {
                File file = new File(chunkDirPath + File.separator + "part" + Integer.toString(p));
                if (!file.exists()) {
                    foundAll = false;
                    break;
                }
                currentSize += file.length();
            }
        }
        if (foundAll && currentSize >= resumableTotalSize) {
            File file = this.makeFileFromChunks(this.tempDir, chunkDirPathFile, (HttpServletRequest)wrapper);
            if (file != null) {
                completedFile = file;
            }
        }
        return completedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File makeFileFromChunks(String tmpDir, File chunkDirPath, HttpServletRequest request) throws IOException {
        int resumableTotalChunks = Integer.valueOf(request.getParameter("resumableTotalChunks"));
        String resumableFilename = request.getParameter("resumableFilename");
        String chunkPath = chunkDirPath.getAbsolutePath() + File.separator + "part";
        File destFile = null;
        String destFilePath = tmpDir + File.separator + resumableFilename;
        destFile = new File(destFilePath);
        InputStream is = null;
        FileOutputStream os = null;
        try {
            destFile.createNewFile();
            os = new FileOutputStream(destFile);
            for (int i = 1; i <= resumableTotalChunks; ++i) {
                File fi = new File(chunkPath.concat(Integer.toString(i)));
                try {
                    int lenght;
                    is = new FileInputStream(fi);
                    byte[] buffer = new byte[1024];
                    while ((lenght = is.read(buffer)) > 0) {
                        ((OutputStream)os).write(buffer, 0, lenght);
                    }
                    continue;
                }
                catch (IOException e) {
                    if (!destFile.delete()) {
                        log.warn((Object)("While writing an uploaded file an error occurred. We were unable to delete the damaged file: " + destFile.getAbsolutePath() + "."));
                    }
                    throw e;
                }
            }
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (os != null) {
                    ((OutputStream)os).close();
                }
            }
            catch (IOException iOException) {}
            if (!this.deleteDirectory(chunkDirPath)) {
                log.warn((Object)("Coudln't delete temporary upload path " + chunkDirPath.getAbsolutePath() + ", ignoring it."));
            }
        }
        return destFile;
    }

    public boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }
}

