/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.app.webui.util.VersionUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.Context;
import org.dspace.services.factory.DSpaceServicesFactory;
import org.dspace.utils.DSpace;
import org.dspace.versioning.Version;
import org.dspace.versioning.VersionHistory;
import org.dspace.versioning.factory.VersionServiceFactory;
import org.dspace.versioning.service.VersionHistoryService;
import org.dspace.versioning.service.VersioningService;

public class VersionHistoryServlet
extends DSpaceServlet {
    private static final Logger log = Logger.getLogger(VersionHistoryServlet.class);
    private final transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final transient VersionHistoryService versionHistoryService = VersionServiceFactory.getInstance().getVersionHistoryService();
    private final transient VersioningService versioningService = VersionServiceFactory.getInstance().getVersionService();

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String submit;
        Version version;
        UUID itemID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"itemID");
        String versionID = request.getParameter("versionID");
        Item item = (Item)this.itemService.find(context, itemID);
        if (item == null) {
            throw new IllegalArgumentException("Item is null");
        }
        Boolean show_submitter = (Boolean)new DSpace().getConfigurationService().getPropertyAsType("versioning.item.history.include.submitter", (Object)Boolean.FALSE);
        if (!this.authorizeService.isAdmin(context, (DSpaceObject)item.getOwningCollection())) {
            if (((Boolean)DSpaceServicesFactory.getInstance().getConfigurationService().getPropertyAsType("versioning.item.history.view.admin", (Object)true)).booleanValue()) {
                throw new AuthorizeException();
            }
        } else {
            show_submitter = Boolean.TRUE;
        }
        request.setAttribute("showSubmitter", (Object)show_submitter);
        VersionHistory history = this.versionHistoryService.findByItem(context, item);
        if ((versionID == null || versionID.isEmpty()) && (version = this.versionHistoryService.getVersion(context, history, item)) != null) {
            versionID = String.valueOf(version.getId());
        }
        if ((submit = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit")) != null && submit.equals("submit_cancel")) {
            response.sendRedirect(request.getContextPath() + "/handle/" + item.getHandle());
            context.complete();
            return;
        }
        if (submit != null && submit.equals("submit_delete")) {
            String[] versionIDs = request.getParameterValues("remove");
            Item latestVersion = this.doDeleteVersions(request, itemID, versionIDs);
            if (latestVersion != null) {
                response.sendRedirect(request.getContextPath() + "/tools/history?delete=true&itemID=" + latestVersion.getID().toString());
            } else {
                response.sendRedirect(request.getContextPath());
            }
            context.complete();
            return;
        }
        if (submit != null && submit.equals("submit_restore")) {
            this.doRestoreVersion(request, itemID, versionID);
        } else if (submit != null && submit.equals("submit_update")) {
            this.doUpdateVersion(request, itemID, versionID);
            response.sendRedirect(request.getContextPath() + "/tools/history?itemID=" + itemID + "&versionID=" + versionID);
            context.complete();
            return;
        }
        request.setAttribute("item", (Object)item);
        request.setAttribute("itemID", (Object)itemID);
        request.setAttribute("versionID", (Object)versionID);
        request.setAttribute("allVersions", (Object)this.versioningService.getVersionsByHistory(context, history));
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/version-history.jsp");
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        this.doDSGet(UIUtil.obtainContext((HttpServletRequest)request), request, response);
    }

    private Item doDeleteVersions(HttpServletRequest request, UUID itemID, String ... versionIDs) throws SQLException, AuthorizeException, IOException {
        return VersionUtil.processDeleteVersions((Context)UIUtil.obtainContext((HttpServletRequest)request), (UUID)itemID, (String[])versionIDs);
    }

    private UUID doRestoreVersion(HttpServletRequest request, UUID itemID, String versionID) throws NumberFormatException, SQLException, AuthorizeException, IOException {
        String summary = request.getParameter("summary");
        VersionUtil.processRestoreVersion((Context)UIUtil.obtainContext((HttpServletRequest)request), (int)Integer.parseInt(versionID), (String)summary);
        return itemID;
    }

    private UUID doUpdateVersion(HttpServletRequest request, UUID itemID, String versionID) throws SQLException, AuthorizeException, IOException {
        String summary = request.getParameter("summary");
        VersionUtil.processUpdateVersion((Context)UIUtil.obtainContext((HttpServletRequest)request), (UUID)itemID, (String)summary);
        return itemID;
    }
}

