/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.servlet.admin;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.app.util.Util;
import org.dspace.app.webui.servlet.DSpaceServlet;
import org.dspace.app.webui.servlet.admin.EditCommunitiesServlet;
import org.dspace.app.webui.util.FileUploadRequest;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.authority.Choices;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamFormatService;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.BundleService;
import org.dspace.content.service.CollectionService;
import org.dspace.content.service.ItemService;
import org.dspace.content.service.MetadataFieldService;
import org.dspace.content.service.MetadataSchemaService;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.handle.factory.HandleServiceFactory;
import org.dspace.handle.service.HandleService;
import org.dspace.license.factory.LicenseServiceFactory;
import org.dspace.license.service.CreativeCommonsService;

public class EditItemServlet
extends DSpaceServlet {
    public static final int START_DELETE = 1;
    public static final int CONFIRM_DELETE = 2;
    public static final int UPDATE_ITEM = 3;
    public static final int START_WITHDRAW = 4;
    public static final int CONFIRM_WITHDRAW = 5;
    public static final int REINSTATE = 6;
    public static final int START_MOVE_ITEM = 7;
    public static final int CONFIRM_MOVE_ITEM = 8;
    public static final int START_PRIVATING = 9;
    public static final int CONFIRM_PRIVATING = 10;
    public static final int PUBLICIZE = 11;
    protected static final String UPLOAD_BITSTREAM_JSP = "/tools/upload-bitstream.jsp";
    private static final Logger log = Logger.getLogger(EditCommunitiesServlet.class);
    private final transient CollectionService collectionService = ContentServiceFactory.getInstance().getCollectionService();
    private final transient ItemService itemService = ContentServiceFactory.getInstance().getItemService();
    private final transient BitstreamFormatService bitstreamFormatService = ContentServiceFactory.getInstance().getBitstreamFormatService();
    private final transient BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private final transient BundleService bundleService = ContentServiceFactory.getInstance().getBundleService();
    private final transient HandleService handleService = HandleServiceFactory.getInstance().getHandleService();
    private final transient MetadataFieldService metadataFieldService = ContentServiceFactory.getInstance().getMetadataFieldService();
    private final transient MetadataSchemaService metadataSchemaService = ContentServiceFactory.getInstance().getMetadataSchemaService();
    private final transient CreativeCommonsService creativeCommonsService = LicenseServiceFactory.getInstance().getCreativeCommonsService();

    protected void doDSGet(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        UUID internalID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"item_id");
        String handle = request.getParameter("handle");
        boolean showError = false;
        Item itemToEdit = null;
        if (internalID != null) {
            itemToEdit = (Item)this.itemService.find(context, internalID);
            showError = itemToEdit == null;
        } else if (handle != null && !handle.equals("")) {
            DSpaceObject dso = this.handleService.resolveToObject(context, handle.trim());
            if (dso != null && dso.getType() == 2) {
                itemToEdit = (Item)dso;
                showError = false;
            } else {
                showError = true;
            }
        }
        if (itemToEdit != null) {
            this.checkEditAuthorization(context, itemToEdit);
            this.showEditForm(context, request, response, itemToEdit);
        } else {
            if (showError) {
                request.setAttribute("invalid.id", (Object)Boolean.TRUE);
            }
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/get-item-id.jsp");
        }
    }

    protected void doDSPost(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        String contentType = request.getContentType();
        if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
            this.processUploadBitstream(context, request, response);
            return;
        }
        if (request.getParameter("submit_cancel") != null) {
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/get-item-id.jsp");
            return;
        }
        int action = UIUtil.getIntParameter((HttpServletRequest)request, (String)"action");
        Item item = (Item)this.itemService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"item_id"));
        String handle = this.handleService.findHandle(context, (DSpaceObject)item);
        this.checkEditAuthorization(context, item);
        request.setAttribute("item", (Object)item);
        request.setAttribute("handle", (Object)handle);
        switch (action) {
            case 1: {
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/confirm-delete-item.jsp");
                break;
            }
            case 2: {
                Iterator collIter = item.getCollections().iterator();
                while (collIter.hasNext()) {
                    Collection c = (Collection)collIter.next();
                    collIter.remove();
                    this.collectionService.removeItem(context, c, item);
                }
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/get-item-id.jsp");
                context.complete();
                break;
            }
            case 3: {
                this.processUpdateItem(context, request, response, item);
                break;
            }
            case 4: {
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/confirm-withdraw-item.jsp");
                break;
            }
            case 5: {
                this.itemService.withdraw(context, item);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/get-item-id.jsp");
                context.complete();
                break;
            }
            case 6: {
                this.itemService.reinstate(context, item);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/get-item-id.jsp");
                context.complete();
                break;
            }
            case 7: {
                if (this.authorizeService.isAdmin(context, (DSpaceObject)item)) {
                    List allNotLinkedCollections = this.itemService.getCollectionsNotLinked(context, item);
                    List allLinkedCollections = item.getCollections();
                    ArrayList<Collection> authNotLinkedCollections = new ArrayList<Collection>();
                    for (Collection c : allNotLinkedCollections) {
                        if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)c, 3)) continue;
                        authNotLinkedCollections.add(c);
                    }
                    ArrayList<Collection> authLinkedCollections = new ArrayList<Collection>();
                    for (Collection c : allLinkedCollections) {
                        if (!this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)c, 4)) continue;
                        authLinkedCollections.add(c);
                    }
                    request.setAttribute("linkedCollections", authLinkedCollections);
                    request.setAttribute("notLinkedCollections", authNotLinkedCollections);
                    JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/move-item.jsp");
                    break;
                }
                throw new ServletException("You must be an administrator to move an item");
            }
            case 8: {
                if (this.authorizeService.isAdmin(context, (DSpaceObject)item)) {
                    Collection fromCollection = (Collection)this.collectionService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection_from_id"));
                    Collection toCollection = (Collection)this.collectionService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)request, (String)"collection_to_id"));
                    Boolean inheritPolicies = false;
                    if (request.getParameter("inheritpolicies") != null) {
                        inheritPolicies = true;
                    }
                    if (fromCollection == null || toCollection == null) {
                        throw new ServletException("Missing or incorrect collection IDs for moving item");
                    }
                    this.itemService.move(context, item, fromCollection, toCollection, inheritPolicies.booleanValue());
                    this.showEditForm(context, request, response, item);
                    context.complete();
                    break;
                }
                throw new ServletException("You must be an administrator to move an item");
            }
            case 9: {
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/confirm-privating-item.jsp");
                break;
            }
            case 10: {
                item.setDiscoverable(false);
                this.itemService.update(context, (DSpaceObject)item);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/get-item-id.jsp");
                context.complete();
                break;
            }
            case 11: {
                item.setDiscoverable(true);
                this.itemService.update(context, (DSpaceObject)item);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/get-item-id.jsp");
                context.complete();
                break;
            }
            default: {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }
    }

    private void checkEditAuthorization(Context c, Item item) throws AuthorizeException, SQLException {
        if (!this.itemService.canEdit(c, item)) {
            UUID userID = null;
            if (c.getCurrentUser() != null) {
                userID = c.getCurrentUser().getID();
            }
            throw new AuthorizeException("EditItemServlet: User " + userID + " not authorized to edit item " + item.getID());
        }
    }

    private void showEditForm(Context context, HttpServletRequest request, HttpServletResponse response, Item item) throws ServletException, IOException, SQLException, AuthorizeException {
        if (request.getParameter("cc_license_url") != null) {
            AuthorizeUtil.authorizeManageCCLicense((Context)context, (Item)item);
            context.turnOffAuthorisationSystem();
            this.creativeCommonsService.setLicense(context, item, request.getParameter("cc_license_url"));
            context.restoreAuthSystemState();
        }
        String handle = this.handleService.findHandle(context, (DSpaceObject)item);
        List collections = item.getCollections();
        List types = this.metadataFieldService.findAll(context);
        HashMap<Integer, String> metadataFields = new HashMap<Integer, String>();
        List schemas = this.metadataSchemaService.findAll(context);
        for (MetadataSchema s : schemas) {
            String schemaName = s.getName();
            List fields = this.metadataFieldService.findAllInSchema(context, s);
            for (MetadataField f : fields) {
                String displayName = "";
                displayName = schemaName + "." + f.getElement() + (f.getQualifier() == null ? "" : "." + f.getQualifier());
                metadataFields.put(f.getFieldID(), displayName);
            }
        }
        request.setAttribute("admin_button", (Object)this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)item, 11));
        try {
            AuthorizeUtil.authorizeManageItemPolicy((Context)context, (Item)item);
            request.setAttribute("policy_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("policy_button", (Object)Boolean.FALSE);
        }
        if (this.authorizeService.authorizeActionBoolean(context, this.itemService.getParentObject(context, (DSpaceObject)item), 4)) {
            request.setAttribute("delete_button", (Object)Boolean.TRUE);
        } else {
            request.setAttribute("delete_button", (Object)Boolean.FALSE);
        }
        try {
            this.authorizeService.authorizeAction(context, (DSpaceObject)item, 3);
            request.setAttribute("create_bitstream_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("create_bitstream_button", (Object)Boolean.FALSE);
        }
        try {
            this.authorizeService.authorizeAction(context, (DSpaceObject)item, 4);
            request.setAttribute("remove_bitstream_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("remove_bitstream_button", (Object)Boolean.FALSE);
        }
        try {
            AuthorizeUtil.authorizeManageCCLicense((Context)context, (Item)item);
            request.setAttribute("cclicense_button", (Object)Boolean.TRUE);
        }
        catch (AuthorizeException authex) {
            request.setAttribute("cclicense_button", (Object)Boolean.FALSE);
        }
        try {
            if (0 < this.itemService.getBundles(item, "ORIGINAL").size()) {
                AuthorizeUtil.authorizeManageBundlePolicy((Context)context, (Bundle)((Bundle)this.itemService.getBundles(item, "ORIGINAL").get(0)));
                request.setAttribute("reorder_bitstreams_button", (Object)Boolean.TRUE);
            }
        }
        catch (AuthorizeException authex) {
            request.setAttribute("reorder_bitstreams_button", (Object)Boolean.FALSE);
        }
        if (!item.isWithdrawn()) {
            try {
                AuthorizeUtil.authorizeWithdrawItem((Context)context, (Item)item);
                request.setAttribute("withdraw_button", (Object)Boolean.TRUE);
            }
            catch (AuthorizeException authex) {
                request.setAttribute("withdraw_button", (Object)Boolean.FALSE);
            }
        } else {
            try {
                AuthorizeUtil.authorizeReinstateItem((Context)context, (Item)item);
                request.setAttribute("reinstate_button", (Object)Boolean.TRUE);
            }
            catch (AuthorizeException authex) {
                request.setAttribute("reinstate_button", (Object)Boolean.FALSE);
            }
        }
        if (item.isDiscoverable()) {
            request.setAttribute("privating_button", (Object)this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)item, 1));
        } else {
            request.setAttribute("publicize_button", (Object)this.authorizeService.authorizeActionBoolean(context, (DSpaceObject)item, 1));
        }
        request.setAttribute("item", (Object)item);
        request.setAttribute("handle", (Object)handle);
        request.setAttribute("collections", (Object)collections);
        request.setAttribute("dc.types", (Object)types);
        request.setAttribute("metadataFields", metadataFields);
        JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/edit-item-form.jsp");
    }

    private void processUpdateItem(Context context, HttpServletRequest request, HttpServletResponse response, Item item) throws ServletException, IOException, SQLException, AuthorizeException {
        String button = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit");
        this.itemService.clearMetadata(context, (DSpaceObject)item, "*", "*", "*", "*");
        Enumeration unsortedParamNames = request.getParameterNames();
        LinkedList<String> sortedParamNames = new LinkedList<String>();
        while (unsortedParamNames.hasMoreElements()) {
            sortedParamNames.add((String)unsortedParamNames.nextElement());
        }
        Collections.sort(sortedParamNames);
        for (String p : sortedParamNames) {
            String key;
            StringTokenizer st;
            if (p.startsWith("value")) {
                String sconfidence;
                String authority;
                st = new StringTokenizer(p, "_");
                st.nextToken();
                String schema = st.nextToken();
                String element = st.nextToken();
                String qualifier = null;
                if (st.countTokens() == 2) {
                    qualifier = st.nextToken();
                }
                String sequenceNumber = st.nextToken();
                key = this.metadataFieldService.findByElement(context, schema, element, qualifier).toString();
                String language = request.getParameter("language_" + key + "_" + sequenceNumber);
                if (language != null && (language = language.trim()).equals("")) {
                    language = null;
                }
                if ((authority = request.getParameter("choice_" + key + "_authority_" + sequenceNumber)) != null && authority.equals("")) {
                    authority = null;
                }
                int confidence = (sconfidence = request.getParameter("choice_" + key + "_confidence_" + sequenceNumber)) == null || sconfidence.equals("") ? 0 : Choices.getConfidenceValue((String)sconfidence);
                String value = request.getParameter(p).trim();
                if (value.equals("") && authority == null || button.equals("submit_remove_" + key + "_" + sequenceNumber)) continue;
                this.itemService.addMetadata(context, (DSpaceObject)item, schema, element, qualifier, language, value, authority, confidence);
                continue;
            }
            if (!p.startsWith("bitstream_name")) continue;
            st = new StringTokenizer(p, "_");
            st.nextToken();
            st.nextToken();
            UUID bundleID = UUID.fromString(st.nextToken());
            UUID bitstreamID = UUID.fromString(st.nextToken());
            Bundle bundle = (Bundle)this.bundleService.find(context, bundleID);
            Bitstream bitstream = (Bitstream)this.bitstreamService.find(context, bitstreamID);
            key = String.valueOf(bundleID) + "_" + bitstreamID;
            if (button.equals("submit_delete_bitstream_" + key)) {
                this.bundleService.removeBitstream(context, bundle, bitstream);
                if (bundle.getBitstreams().size() != 0) continue;
                this.itemService.removeBundle(context, item, bundle);
                continue;
            }
            String name = request.getParameter(p);
            String source = request.getParameter("bitstream_source_" + key);
            String desc = request.getParameter("bitstream_description_" + key);
            int formatID = UIUtil.getIntParameter((HttpServletRequest)request, (String)("bitstream_format_id_" + key));
            String userFormatDesc = request.getParameter("bitstream_user_format_description_" + key);
            UUID primaryBitstreamID = UIUtil.getUUIDParameter((HttpServletRequest)request, (String)(bundleID + "_primary_bitstream_id"));
            if (source.equals("")) {
                source = null;
            }
            if (desc.equals("")) {
                desc = null;
            }
            if (userFormatDesc.equals("")) {
                userFormatDesc = null;
            }
            bitstream.setName(context, name);
            bitstream.setSource(context, source);
            bitstream.setDescription(context, desc);
            bitstream.setFormat(context, (BitstreamFormat)this.bitstreamFormatService.find(context, formatID));
            if (primaryBitstreamID != null) {
                bundle.setPrimaryBitstreamID((Bitstream)this.bitstreamService.find(context, primaryBitstreamID));
            }
            if (userFormatDesc != null) {
                bitstream.setUserFormatDescription(context, userFormatDesc);
            }
            this.bitstreamService.update(context, (DSpaceObject)bitstream);
            this.bundleService.update(context, (DSpaceObject)bundle);
        }
        if (button.equals("submit_addfield")) {
            int dcTypeID = UIUtil.getIntParameter((HttpServletRequest)request, (String)"addfield_dctype");
            String value = request.getParameter("addfield_value").trim();
            String lang = request.getParameter("addfield_language");
            if (lang != null && (lang = lang.trim()).equals("")) {
                lang = null;
            }
            MetadataField field = this.metadataFieldService.find(context, dcTypeID);
            MetadataSchema schema = field.getMetadataSchema();
            this.itemService.addMetadata(context, (DSpaceObject)item, schema.getName(), field.getElement(), field.getQualifier(), lang, value);
        }
        this.itemService.update(context, (DSpaceObject)item);
        if (button.equals("submit_addcc")) {
            request.setAttribute("item", (Object)item);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)"/tools/creative-commons-edit.jsp");
        }
        if (button.equals("submit_addbitstream")) {
            request.setAttribute("item", (Object)item);
            JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)UPLOAD_BITSTREAM_JSP);
        } else if (button.equals("submit_update_order") || button.startsWith("submit_order_")) {
            List bundles = this.itemService.getBundles(item, "ORIGINAL");
            for (Bundle bundle : bundles) {
                List bitstreams = bundle.getBitstreams();
                UUID[] newBitstreamOrder = new UUID[bitstreams.size()];
                if (button.equals("submit_update_order")) {
                    for (Bitstream bitstream : bitstreams) {
                        int order = Util.getIntParameter((HttpServletRequest)request, (String)("order_" + bitstream.getID()));
                        newBitstreamOrder[--order] = bitstream.getID();
                    }
                } else {
                    String inputKey = button.replace("submit_order_", "") + "_value";
                    if (inputKey.startsWith(bundle.getID() + "_")) {
                        List vals = Util.getUUIDParameters((HttpServletRequest)request, (String)inputKey);
                        int idx = 0;
                        Iterator i$ = vals.iterator();
                        while (i$.hasNext()) {
                            UUID v;
                            newBitstreamOrder[idx] = v = (UUID)i$.next();
                            ++idx;
                        }
                    } else {
                        newBitstreamOrder = null;
                    }
                }
                if (newBitstreamOrder == null) continue;
                this.bundleService.setOrder(context, bundle, newBitstreamOrder);
                this.bundleService.update(context, (DSpaceObject)bundle);
            }
            this.showEditForm(context, request, response, item);
        } else {
            this.showEditForm(context, request, response, item);
        }
        context.complete();
    }

    private void processUploadBitstream(Context context, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, SQLException, AuthorizeException {
        try {
            FileUploadRequest wrapper = new FileUploadRequest(request);
            Bitstream b = null;
            Item item = (Item)this.itemService.find(context, UIUtil.getUUIDParameter((HttpServletRequest)wrapper, (String)"item_id"));
            File temp = wrapper.getFile("file");
            if (temp == null) {
                boolean noFileSelected = true;
                request.setAttribute("noFileSelected", (Object)noFileSelected);
                request.setAttribute("item", (Object)item);
                JSPManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (String)UPLOAD_BITSTREAM_JSP);
                return;
            }
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(temp));
            this.checkEditAuthorization(context, item);
            List bundles = this.itemService.getBundles(item, "ORIGINAL");
            if (bundles == null || bundles.size() == 0) {
                b = this.itemService.createSingleBitstream(context, (InputStream)is, item, "ORIGINAL");
                Collection owningCollection = item.getOwningCollection();
                if (owningCollection != null) {
                    Bundle bnd = (Bundle)b.getBundles().get(0);
                    this.bundleService.inheritCollectionDefaultPolicies(context, bnd, owningCollection);
                }
            } else {
                b = this.bitstreamService.create(context, (Bundle)bundles.get(0), (InputStream)is);
            }
            String noPath = wrapper.getFilesystemName("file");
            while (noPath.indexOf(47) > -1) {
                noPath = noPath.substring(noPath.indexOf(47) + 1);
            }
            while (noPath.indexOf(92) > -1) {
                noPath = noPath.substring(noPath.indexOf(92) + 1);
            }
            b.setName(context, noPath);
            b.setSource(context, wrapper.getFilesystemName("file"));
            BitstreamFormat bf = this.bitstreamFormatService.guessFormat(context, b);
            b.setFormat(context, bf);
            this.bitstreamService.update(context, (DSpaceObject)b);
            this.itemService.update(context, (DSpaceObject)item);
            this.showEditForm(context, request, response, item);
            if (!temp.delete()) {
                log.error((Object)"Unable to delete temporary file");
            }
            context.complete();
        }
        catch (FileUploadBase.FileSizeLimitExceededException ex) {
            log.warn((Object)"Upload exceeded upload.max");
            JSPManager.showFileSizeLimitExceededError((HttpServletRequest)request, (HttpServletResponse)response, (String)ex.getMessage(), (long)ex.getActualSize(), (long)ex.getPermittedSize());
        }
    }
}

