/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.webui.submit.JSPStep;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.ResourcePolicy;
import org.dspace.authorize.factory.AuthorizeServiceFactory;
import org.dspace.authorize.service.AuthorizeService;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;

public class JSPAccessStep
extends JSPStep {
    private static final String DISPLAY_JSP = "/submit/access-step.jsp";
    private static final String EDIT_POLICY_JSP = "/submit/edit-policy.jsp";
    private static final String REVIEW_JSP = "/submit/review-policy.jsp";
    private boolean advanced = ConfigurationManager.getBooleanProperty((String)"webui.submission.restrictstep.enableAdvancedForm", (boolean)false);
    private static Logger log = Logger.getLogger(JSPAccessStep.class);
    private AuthorizeService authorizeService = AuthorizeServiceFactory.getInstance().getAuthorizeService();

    public void doPreProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)DISPLAY_JSP);
    }

    public void doPostProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int status) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_next");
        if (status == 10) {
            JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)EDIT_POLICY_JSP);
        } else if (buttonPressed.equals("submit_add_policy") || buttonPressed.startsWith("submit_delete_edit_policies_") || buttonPressed.equals("submit_edit_cancel") || buttonPressed.equals("submit_save") || status > 0) {
            if (status > 0 && status != 10) {
                request.setAttribute("error_id", (Object)status);
            }
            JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)DISPLAY_JSP);
        }
    }

    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        return 1;
    }

    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        List rpolicies = new ArrayList();
        try {
            rpolicies = this.authorizeService.findPoliciesByDSOAndType(context, (DSpaceObject)subInfo.getSubmissionItem().getItem(), ResourcePolicy.TYPE_CUSTOM);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        Item item = subInfo.getSubmissionItem().getItem();
        request.setAttribute("submission.item.isdiscoverable", (Object)item.isDiscoverable());
        request.setAttribute("submission.item.rpolicies", rpolicies);
        request.setAttribute("advancedEmbargo", (Object)this.advanced);
        return REVIEW_JSP;
    }
}

