/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.submit.step;

import com.google.gson.Gson;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.DCInputsReader;
import org.dspace.app.util.DCInputsReaderException;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.webui.submit.JSPStepManager;
import org.dspace.app.webui.submit.step.JSPUploadStep;
import org.dspace.app.webui.util.JSONUploadResponse;
import org.dspace.app.webui.util.JSPManager;
import org.dspace.app.webui.util.UIUtil;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.BitstreamService;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class JSPUploadWithEmbargoStep
extends JSPUploadStep {
    private static final String ACCESS_POLICIES_JSP = "/submit/set-policies.jsp";
    private static final String EDIT_POLICY_JSP = "/submit/edit-policy.jsp";
    private static final String EDIT_BITSTREAM_ACCESS_JSP = "/submit/edit-bitstream-access.jsp";
    private static Logger log = Logger.getLogger(JSPUploadWithEmbargoStep.class);
    private BitstreamService bitstreamService = ContentServiceFactory.getInstance().getBitstreamService();
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public void doPostProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo, int status) throws ServletException, IOException, SQLException, AuthorizeException {
        Bitstream bitstream;
        UUID id;
        String buttonPressed = UIUtil.getSubmitButton((HttpServletRequest)request, (String)"submit_next");
        boolean fileRequired = ConfigurationManager.getBooleanProperty((String)"webui.submit.upload.required", (boolean)true);
        if (UIUtil.getBoolParameter((HttpServletRequest)request, (String)"ajaxUpload")) {
            Gson gson = new Gson();
            response.setContentType("text/html");
            JSONUploadResponse jsonResponse = new JSONUploadResponse();
            String bitstreamName = null;
            UUID bitstreamID = null;
            long size = 0L;
            String url = null;
            if (subInfo.getBitstream() != null) {
                Bitstream bitstream2 = subInfo.getBitstream();
                bitstreamName = bitstream2.getName();
                bitstreamID = bitstream2.getID();
                size = bitstream2.getSize();
                url = request.getContextPath() + "/retrieve/" + bitstreamID + "/" + UIUtil.encodeBitstreamName((String)bitstreamName);
                jsonResponse.addUploadFileStatus(bitstreamName, bitstreamID, size, url, status);
                response.getWriter().print(gson.toJson((Object)jsonResponse));
                response.flushBuffer();
            }
            return;
        }
        if (buttonPressed.equalsIgnoreCase("submit_skip") || buttonPressed.equalsIgnoreCase("submit_upload") && !fileRequired) {
            Bundle bnd;
            List bundles = this.itemService.getBundles(subInfo.getSubmissionItem().getItem(), "ORIGINAL");
            boolean fileAlreadyUploaded = false;
            Iterator i$ = bundles.iterator();
            while (i$.hasNext() && !(fileAlreadyUploaded = (bnd = (Bundle)i$.next()).getBitstreams().size() > 0)) {
            }
            if (fileAlreadyUploaded) {
                this.showUploadFileList(context, request, response, subInfo, true, false);
            }
            return;
        }
        if (buttonPressed.equalsIgnoreCase("submit_retry")) {
            this.showUploadPage(context, request, response, subInfo, false);
        } else if (status == 30) {
            this.showEditBitstreamAccess(context, request, response, subInfo);
        } else if (status == 25) {
            this.showUploadPage(context, request, response, subInfo, false);
        } else if (status == 10) {
            this.showEditPolicy(context, request, response, subInfo);
        }
        if (status != 0) {
            DCInputsReader inputsReader;
            Collection c;
            if (status == 1) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            } else if (status == 2 || status == 5) {
                if (buttonPressed.startsWith("submit_remove_")) {
                    this.showUploadPage(context, request, response, subInfo, false);
                } else {
                    if (subInfo != null) {
                        try {
                            c = subInfo.getSubmissionItem().getCollection();
                            inputsReader = new DCInputsReader();
                            request.setAttribute("submission.inputs", (Object)inputsReader.getInputs(c.getHandle()));
                        }
                        catch (DCInputsReaderException e) {
                            throw new ServletException((Throwable)e);
                        }
                    }
                    JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)"/submit/upload-error.jsp");
                }
            } else if (status == 14) {
                if (subInfo != null) {
                    try {
                        c = subInfo.getSubmissionItem().getCollection();
                        inputsReader = new DCInputsReader();
                        request.setAttribute("submission.inputs", (Object)inputsReader.getInputs(c.getHandle()));
                    }
                    catch (DCInputsReaderException e) {
                        throw new ServletException((Throwable)e);
                    }
                }
                JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)"/submit/virus-checker-error.jsp");
            } else if (status == 16) {
                if (subInfo != null) {
                    try {
                        c = subInfo.getSubmissionItem().getCollection();
                        inputsReader = new DCInputsReader();
                        request.setAttribute("submission.inputs", (Object)inputsReader.getInputs(c.getHandle()));
                    }
                    catch (DCInputsReaderException e) {
                        throw new ServletException((Throwable)e);
                    }
                }
                JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)"/submit/virus-error.jsp");
            } else if (status == 10) {
                this.showGetFileFormat(context, request, response, subInfo);
            }
        }
        if (status == 0 && buttonPressed.equals("submit_next")) {
            return;
        }
        if (buttonPressed.equals("submit_more")) {
            this.showChooseFile(context, request, response, subInfo);
        } else if (buttonPressed.equals("submit_show_checksums")) {
            this.showUploadFileList(context, request, response, subInfo, false, true);
        } else if (buttonPressed.startsWith("submit_describe_")) {
            try {
                id = UUID.fromString(buttonPressed.substring(16));
                bitstream = (Bitstream)this.bitstreamService.find(context, id);
            }
            catch (NumberFormatException nfe) {
                bitstream = null;
            }
            if (bitstream == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            }
            subInfo.setBitstream(bitstream);
            this.showFileDescription(context, request, response, subInfo);
        } else if (buttonPressed.startsWith("submit_format_")) {
            try {
                id = UUID.fromString(buttonPressed.substring(14));
                bitstream = (Bitstream)this.bitstreamService.find(context, id);
            }
            catch (NumberFormatException nfe) {
                bitstream = null;
            }
            if (bitstream == null) {
                log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
                JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
            }
            subInfo.setBitstream(bitstream);
            this.showGetFileFormat(context, request, response, subInfo);
        } else {
            String contentType = request.getContentType();
            boolean fileUpload = false;
            if (contentType != null && contentType.indexOf("multipart/form-data") != -1) {
                fileUpload = true;
            }
            this.showUploadPage(context, request, response, subInfo, fileUpload);
        }
    }

    private void showEditBitstreamAccess(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws SQLException, ServletException, IOException {
        if (subInfo == null || subInfo.getBitstream() == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
            JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
        }
        JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)EDIT_BITSTREAM_ACCESS_JSP);
    }

    private void showEditPolicy(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws SQLException, ServletException, IOException {
        if (subInfo == null || subInfo.getBitstream() == null) {
            log.warn((Object)LogManager.getHeader((Context)context, (String)"integrity_error", (String)UIUtil.getRequestLogInfo((HttpServletRequest)request)));
            JSPManager.showIntegrityError((HttpServletRequest)request, (HttpServletResponse)response);
        }
        JSPStepManager.showJSP((HttpServletRequest)request, (HttpServletResponse)response, (SubmissionInfo)subInfo, (String)EDIT_POLICY_JSP);
    }

    public String getReviewJSP(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) {
        request.setAttribute("submission.step.uploadwithembargo", (Object)true);
        return super.getReviewJSP(context, request, response, subInfo);
    }
}

