/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.AKeyBasedStyleSelection;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.services.ConfigurationService;
import org.dspace.services.factory.DSpaceServicesFactory;

public class CollectionStyleSelection
extends AKeyBasedStyleSelection {
    private Map<String, String> styles;
    private static Logger log = Logger.getLogger(CollectionStyleSelection.class);
    private final transient ConfigurationService configurationService = DSpaceServicesFactory.getInstance().getConfigurationService();

    public String getStyleForItem(Item item) throws SQLException {
        Collection c = item.getOwningCollection();
        if (c != null) {
            return this.getFromMap(c.getHandle());
        }
        return "default";
    }

    private void readKeyStyleConfig() {
        this.styles = new HashMap();
        List keys = this.configurationService.getPropertyKeys("webui.itemdisplay");
        for (String key : keys) {
            if (!key.endsWith(".collections")) continue;
            String styleName = key.substring("webui.itemdisplay.".length(), key.length() - ".collections".length());
            String[] collections = this.configurationService.getArrayProperty(key);
            for (int i = 0; i < collections.length; ++i) {
                this.styles.put(collections[i].trim(), styleName.toLowerCase());
            }
        }
    }

    public String getFromMap(String handle) {
        String styleName;
        if (this.styles == null) {
            this.readKeyStyleConfig();
        }
        if ((styleName = (String)this.styles.get(handle)) == null) {
            return "default";
        }
        if (this.isConfigurationDefinedForStyle(styleName)) {
            log.warn((Object)("dspace.cfg specifies undefined item display style '" + styleName + "' for collection handle " + handle + ".  Using default"));
            return "default";
        }
        return styleName;
    }
}

