/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.webui.util;

import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.app.webui.util.AKeyBasedStyleSelection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataValue;
import org.dspace.content.factory.ContentServiceFactory;
import org.dspace.content.service.ItemService;
import org.dspace.core.ConfigurationManager;

public class MetadataStyleSelection
extends AKeyBasedStyleSelection {
    private static Logger log = Logger.getLogger(MetadataStyleSelection.class);
    private ItemService itemService = ContentServiceFactory.getInstance().getItemService();

    public String getStyleForItem(Item item) throws SQLException {
        String metadata = ConfigurationManager.getProperty((String)"webui.itemdisplay.metadata-style");
        List value = this.itemService.getMetadataByMetadataString((DSpaceObject)item, metadata);
        String styleName = "default";
        if (value.size() > 0) {
            if (value.size() >= 1) {
                log.warn((Object)("more then one value for metadata '" + metadata + "'. Using the first one"));
            }
            styleName = ((MetadataValue)value.get(0)).getValue().toLowerCase();
        }
        if (this.isConfigurationDefinedForStyle(styleName)) {
            log.warn((Object)("metadata '" + metadata + "' specify undefined item display style '" + styleName + "'.  Using default"));
            return "default";
        }
        return styleName;
    }
}

