/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rdf.providing;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.rdf.negotiation.Negotiator;
import org.dspace.utils.DSpace;

public class LocalURIRedirectionServlet
extends HttpServlet {
    public static final String ACCEPT_HEADER_NAME = "Accept";
    private static final Logger log = Logger.getLogger(LocalURIRedirectionServlet.class);

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        log.debug((Object)("Pathinfo: " + pathInfo));
        if (StringUtils.isEmpty((String)pathInfo) || StringUtils.countMatches((String)pathInfo, (String)"/") < 2) {
            log.debug((Object)"Path does not contain the expected number of slashes.");
            response.sendError(404);
            return;
        }
        String[] path = request.getPathInfo().substring(1).split("/");
        String handle = path[0] + "/" + path[1];
        String dspaceURL = new DSpace().getConfigurationService().getProperty("dspace.url");
        int requestedMimeType = Negotiator.negotiate((String)request.getHeader(ACCEPT_HEADER_NAME));
        Context context = null;
        DSpaceObject dso = null;
        try {
            context = new Context(1);
            dso = HandleManager.resolveToObject((Context)context, (String)handle);
        }
        catch (SQLException ex) {
            log.error((Object)("SQLException: " + ex.getMessage()), (Throwable)ex);
            context.abort();
            response.sendError(503);
            return;
        }
        catch (IllegalStateException ex) {
            log.error((Object)("Cannot resolve handle " + handle + ". IllegalStateException:" + ex.getMessage()), (Throwable)ex);
            context.abort();
            response.sendError(400);
            return;
        }
        if (dso == null) {
            log.info((Object)("Cannot resolve handle '" + handle + "' to dso. => 404"));
            context.abort();
            response.sendError(404);
            return;
        }
        context.abort();
        Negotiator.sendRedirect((HttpServletResponse)response, (String)handle, (String)"", (int)requestedMimeType, (boolean)true);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Ensures that URIs used in RDF can be dereferenced.";
    }
}

