/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.rest.common.Bitstream;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.dspace.utils.DSpace;

@Path(value="/bitstreams")
public class BitstreamResource {
    Logger log = Logger.getLogger(BitstreamResource.class);
    private static org.dspace.core.Context context;
    private static final boolean writeStatistics;

    @GET
    @Path(value="/{bitstream_id}")
    @Produces(value={"application/json", "application/xml"})
    public Bitstream getBitstream(@PathParam(value="bitstream_id") Integer bitstream_id, @QueryParam(value="expand") String expand) {
        try {
            org.dspace.content.Bitstream bitstream;
            if (context == null || !context.isValid()) {
                context = new org.dspace.core.Context();
                context.getDBConnection().setAutoCommit(true);
            }
            if (AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)(bitstream = org.dspace.content.Bitstream.find((org.dspace.core.Context)context, (int)bitstream_id)), (int)0)) {
                return new Bitstream(bitstream, expand);
            }
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/{bitstream_id}/retrieve")
    public Response getFile(@PathParam(value="bitstream_id") Integer bitstream_id, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) {
        try {
            org.dspace.content.Bitstream bitstream;
            if (context == null || !context.isValid()) {
                context = new org.dspace.core.Context();
                context.getDBConnection().setAutoCommit(true);
            }
            if (AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)(bitstream = org.dspace.content.Bitstream.find((org.dspace.core.Context)context, (int)bitstream_id)), (int)0)) {
                if (writeStatistics) {
                    this.writeStats(bitstream_id, user_ip, user_agent, xforwarderfor, headers, request);
                }
                return Response.ok((Object)bitstream.retrieve()).type(bitstream.getFormat().getMIMEType()).build();
            }
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (SQLException e) {
            this.log.error((Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (AuthorizeException e) {
            this.log.error((Object)e.getMessage());
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    private void writeStats(Integer bitstream_id, String user_ip, String user_agent, String xforwarderfor, HttpHeaders headers, HttpServletRequest request) {
        try {
            DSpaceObject bitstream = DSpaceObject.find((org.dspace.core.Context)context, (int)0, (int)bitstream_id);
            if (user_ip == null || user_ip.length() == 0) {
                new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, bitstream));
            } else {
                new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, user_ip, user_agent, xforwarderfor, context, bitstream));
            }
            this.log.debug((Object)"fired event");
        }
        catch (SQLException ex) {
            this.log.error((Object)("SQL exception can't write usageEvent \n" + ex));
        }
    }

    static {
        writeStatistics = ConfigurationManager.getBooleanProperty((String)"rest", (String)"stats", (boolean)false);
    }
}

