/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.rest.common.Item;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.dspace.utils.DSpace;

@Path(value="/items")
public class ItemsResource {
    private static final boolean writeStatistics = ConfigurationManager.getBooleanProperty((String)"rest", (String)"stats", (boolean)false);
    private static final Logger log = Logger.getLogger(ItemsResource.class);
    private static org.dspace.core.Context context;

    @GET
    @Path(value="/{item_id}")
    @Produces(value={"application/json", "application/xml"})
    public Item getItem(@PathParam(value="item_id") Integer item_id, @QueryParam(value="expand") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        try {
            org.dspace.content.Item item;
            if (context == null || !context.isValid()) {
                context = new org.dspace.core.Context();
                context.getDBConnection().setAutoCommit(true);
            }
            if (AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)(item = org.dspace.content.Item.find((org.dspace.core.Context)context, (int)item_id)), (int)0)) {
                if (writeStatistics) {
                    this.writeStats(item_id, user_ip, user_agent, xforwarderfor, headers, request);
                }
                return new Item(item, expand, context);
            }
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    private void writeStats(Integer item_id, String user_ip, String user_agent, String xforwarderfor, HttpHeaders headers, HttpServletRequest request) {
        try {
            DSpaceObject item = DSpaceObject.find((org.dspace.core.Context)context, (int)2, (int)item_id);
            if (user_ip == null || user_ip.length() == 0) {
                new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, item));
            } else {
                new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, user_ip, user_agent, xforwarderfor, context, item));
            }
            log.debug((Object)"fired event");
        }
        catch (SQLException ex) {
            log.error((Object)("SQL exception can't write usageEvent \n" + ex));
        }
    }
}

