/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.rest.common.Bitstream;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.dspace.utils.DSpace;

@Path(value="/bitstreams")
public class BitstreamResource {
    Logger log = Logger.getLogger(BitstreamResource.class);
    private static final boolean writeStatistics = ConfigurationManager.getBooleanProperty((String)"rest", (String)"stats", (boolean)false);

    @GET
    @Path(value="/{bitstream_id}")
    @Produces(value={"application/json", "application/xml"})
    public Bitstream getBitstream(@PathParam(value="bitstream_id") Integer bitstream_id, @QueryParam(value="expand") String expand) {
        org.dspace.core.Context context = null;
        try {
            context = new org.dspace.core.Context();
            org.dspace.content.Bitstream bitstream = org.dspace.content.Bitstream.find((org.dspace.core.Context)context, (int)bitstream_id);
            if (AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)bitstream, (int)0)) {
                Bitstream bitstream2 = new Bitstream(bitstream, expand);
                return bitstream2;
            }
            try {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            catch (SQLException e) {
                this.log.error((Object)e.getMessage());
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        finally {
            if (context != null) {
                try {
                    context.complete();
                }
                catch (SQLException e) {
                    this.log.error((Object)(e.getMessage() + " occurred while trying to close"));
                }
            }
        }
    }

    @GET
    @Path(value="/{bitstream_id}/retrieve")
    public Response getFile(@PathParam(value="bitstream_id") Integer bitstream_id, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) {
        org.dspace.core.Context context = null;
        try {
            context = new org.dspace.core.Context();
            org.dspace.content.Bitstream bitstream = org.dspace.content.Bitstream.find((org.dspace.core.Context)context, (int)bitstream_id);
            if (AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)bitstream, (int)0)) {
                if (writeStatistics) {
                    this.writeStats(context, bitstream_id, user_ip, user_agent, xforwarderfor, headers, request);
                }
                Response response = Response.ok((Object)bitstream.retrieve()).type(bitstream.getFormat().getMIMEType()).build();
                return response;
            }
            try {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            catch (IOException e) {
                this.log.error((Object)e.getMessage());
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            catch (SQLException e) {
                this.log.error((Object)e.getMessage());
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
            catch (AuthorizeException e) {
                this.log.error((Object)e.getMessage());
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
        finally {
            if (context != null) {
                try {
                    context.complete();
                }
                catch (SQLException e) {
                    this.log.error((Object)(e.getMessage() + " occurred while trying to close"));
                }
            }
        }
    }

    private void writeStats(org.dspace.core.Context context, Integer bitstream_id, String user_ip, String user_agent, String xforwarderfor, HttpHeaders headers, HttpServletRequest request) {
        try {
            DSpaceObject bitstream = DSpaceObject.find((org.dspace.core.Context)context, (int)0, (int)bitstream_id);
            if (user_ip == null || user_ip.length() == 0) {
                new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, bitstream));
            } else {
                new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, user_ip, user_agent, xforwarderfor, context, bitstream));
            }
            this.log.debug((Object)"fired event");
        }
        catch (SQLException ex) {
            this.log.error((Object)("SQL exception can't write usageEvent \n" + ex));
        }
    }
}

