/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.rest.common.Collection;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.dspace.utils.DSpace;

@Path(value="/collections")
public class CollectionsResource {
    private static Logger log = Logger.getLogger(CollectionsResource.class);
    @Context
    ServletContext servletContext;
    private static final boolean writeStatistics = ConfigurationManager.getBooleanProperty((String)"rest", (String)"stats", (boolean)false);

    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/xml"})
    public Collection[] list(@QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset) {
        org.dspace.core.Context context = null;
        try {
            context = new org.dspace.core.Context();
            org.dspace.content.Collection[] collections = limit != null && limit >= 0 && offset != null && offset >= 0 ? org.dspace.content.Collection.findAll((org.dspace.core.Context)context, (Integer)limit, (Integer)offset) : org.dspace.content.Collection.findAll((org.dspace.core.Context)context);
            ArrayList<Collection> collectionArrayList = new ArrayList<Collection>();
            for (org.dspace.content.Collection collection : collections) {
                if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)collection, (int)0)) continue;
                Collection restCollection = new Collection(collection, null, context, limit, offset);
                collectionArrayList.add(restCollection);
            }
            Collection[] collectionArray = collectionArrayList.toArray(new Collection[0]);
            return collectionArray;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            if (context != null) {
                try {
                    context.complete();
                }
                catch (SQLException e) {
                    log.error((Object)(e.getMessage() + " occurred while trying to close"));
                }
            }
        }
    }

    @GET
    @Path(value="/{collection_id}")
    @Produces(value={"application/json", "application/xml"})
    public Collection getCollection(@PathParam(value="collection_id") Integer collection_id, @QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) {
        org.dspace.core.Context context = null;
        try {
            context = new org.dspace.core.Context();
            org.dspace.content.Collection collection = org.dspace.content.Collection.find((org.dspace.core.Context)context, (int)collection_id);
            if (AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)collection, (int)0)) {
                if (writeStatistics) {
                    this.writeStats(context, collection_id, user_ip, user_agent, xforwarderfor, headers, request);
                }
                Collection collection2 = new Collection(collection, expand, context, limit, offset);
                return collection2;
            }
            try {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        finally {
            if (context != null) {
                try {
                    context.complete();
                }
                catch (SQLException e) {
                    log.error((Object)(e.getMessage() + " occurred while trying to close"));
                }
            }
        }
    }

    private void writeStats(org.dspace.core.Context context, Integer collection_id, String user_ip, String user_agent, String xforwarderfor, HttpHeaders headers, HttpServletRequest request) {
        try {
            DSpaceObject collection = DSpaceObject.find((org.dspace.core.Context)context, (int)3, (int)collection_id);
            if (user_ip == null || user_ip.length() == 0) {
                new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, collection));
            } else {
                new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, user_ip, user_agent, xforwarderfor, context, collection));
            }
            log.debug((Object)"fired event");
        }
        catch (SQLException ex) {
            log.error((Object)("SQL exception can't write usageEvent \n" + ex));
        }
    }
}

