/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.DSpaceObject;
import org.dspace.core.ConfigurationManager;
import org.dspace.rest.common.Community;
import org.dspace.services.model.Event;
import org.dspace.usage.UsageEvent;
import org.dspace.utils.DSpace;

@Path(value="/communities")
public class CommunitiesResource {
    private static Logger log = Logger.getLogger(CommunitiesResource.class);
    private static final boolean writeStatistics = ConfigurationManager.getBooleanProperty((String)"rest", (String)"stats", (boolean)false);

    @GET
    @Path(value="/")
    @Produces(value={"application/json", "application/xml"})
    public Community[] list(@QueryParam(value="expand") String expand) {
        org.dspace.core.Context context = null;
        try {
            context = new org.dspace.core.Context();
            org.dspace.content.Community[] topCommunities = org.dspace.content.Community.findAllTop((org.dspace.core.Context)context);
            ArrayList<Community> communityArrayList = new ArrayList<Community>();
            for (org.dspace.content.Community community : topCommunities) {
                if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)community, (int)0)) continue;
                Community restCommunity = new Community(community, expand, context);
                communityArrayList.add(restCommunity);
            }
            Community[] communityArray = communityArrayList.toArray(new Community[0]);
            return communityArray;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            if (context != null) {
                try {
                    context.complete();
                }
                catch (SQLException e) {
                    log.error((Object)(e.getMessage() + " occurred while trying to close"));
                }
            }
        }
    }

    @GET
    @Path(value="/{community_id}")
    @Produces(value={"application/json", "application/xml"})
    public Community getCommunity(@PathParam(value="community_id") Integer community_id, @QueryParam(value="expand") String expand, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwarderfor") String xforwarderfor, @Context HttpHeaders headers, @Context HttpServletRequest request) {
        org.dspace.core.Context context = null;
        try {
            context = new org.dspace.core.Context();
            org.dspace.content.Community community = org.dspace.content.Community.find((org.dspace.core.Context)context, (int)community_id);
            if (AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)community, (int)0)) {
                if (writeStatistics) {
                    this.writeStats(context, community_id, user_ip, user_agent, xforwarderfor, headers, request);
                }
                Community community2 = new Community(community, expand, context);
                return community2;
            }
            try {
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        finally {
            if (context != null) {
                try {
                    context.complete();
                }
                catch (SQLException e) {
                    log.error((Object)(e.getMessage() + " occurred while trying to close"));
                }
            }
        }
    }

    private void writeStats(org.dspace.core.Context context, Integer community_id, String user_ip, String user_agent, String xforwarderfor, HttpHeaders headers, HttpServletRequest request) {
        try {
            DSpaceObject community = DSpaceObject.find((org.dspace.core.Context)context, (int)4, (int)community_id);
            if (user_ip == null || user_ip.length() == 0) {
                new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, request, context, community));
            } else {
                new DSpace().getEventService().fireEvent((Event)new UsageEvent(UsageEvent.Action.VIEW, user_ip, user_agent, xforwarderfor, context, community));
            }
            log.debug((Object)"fired event");
        }
        catch (SQLException ex) {
            log.error((Object)("SQL exception can't write usageEvent \n" + ex));
        }
    }
}

