/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest.common;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.log4j.Logger;
import org.dspace.app.util.MetadataExposure;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bundle;
import org.dspace.content.DCValue;
import org.dspace.core.Context;
import org.dspace.rest.common.Bitstream;
import org.dspace.rest.common.Collection;
import org.dspace.rest.common.Community;
import org.dspace.rest.common.DSpaceObject;
import org.dspace.rest.common.MetadataEntry;

@XmlRootElement(name="item")
public class Item
extends DSpaceObject {
    Logger log = Logger.getLogger(Item.class);
    String isArchived;
    String isWithdrawn;
    String lastModified;
    Collection parentCollection;
    List<Collection> parentCollectionList;
    List<Community> parentCommunityList;
    List<MetadataEntry> metadata;
    List<Bitstream> bitstreams;

    public Item() {
    }

    public Item(org.dspace.content.Item item, String expand, Context context) throws SQLException, WebApplicationException {
        super((org.dspace.content.DSpaceObject)item);
        this.setup(item, expand, context);
    }

    private void setup(org.dspace.content.Item item, String expand, Context context) throws SQLException {
        List<Object> expandFields = new ArrayList();
        if (expand != null) {
            expandFields = Arrays.asList(expand.split(","));
        }
        if (expandFields.contains("metadata") || expandFields.contains("all")) {
            DCValue[] dcvs;
            this.metadata = new ArrayList();
            for (DCValue dCValue : dcvs = item.getMetadata("*", "*", "*", "*")) {
                if (MetadataExposure.isHidden((Context)context, (String)dCValue.schema, (String)dCValue.element, (String)dCValue.qualifier)) continue;
                this.metadata.add(new MetadataEntry(dCValue.getField(), dCValue.value));
            }
        } else {
            this.addExpand("metadata");
        }
        this.setArchived(Boolean.toString(item.isArchived()));
        this.setWithdrawn(Boolean.toString(item.isWithdrawn()));
        this.setLastModified(item.getLastModified().toString());
        if (expandFields.contains("parentCollection") || expandFields.contains("all")) {
            this.parentCollection = new Collection(item.getOwningCollection(), null, context, null, null);
        } else {
            this.addExpand("parentCollection");
        }
        if (expandFields.contains("parentCollectionList") || expandFields.contains("all")) {
            this.parentCollectionList = new ArrayList();
            org.dspace.content.Collection[] collections = item.getCollections();
            for (DCValue dCValue : collections) {
                this.parentCollectionList.add(new Collection((org.dspace.content.Collection)dCValue, null, context, null, null));
            }
        } else {
            this.addExpand("parentCollectionList");
        }
        if (expandFields.contains("parentCommunityList") || expandFields.contains("all")) {
            this.parentCommunityList = new ArrayList();
            org.dspace.content.Community[] communities = item.getCommunities();
            for (DCValue dCValue : communities) {
                this.parentCommunityList.add(new Community((org.dspace.content.Community)dCValue, null, context));
            }
        } else {
            this.addExpand("parentCommunityList");
        }
        if (expandFields.contains("bitstreams") || expandFields.contains("all")) {
            this.bitstreams = new ArrayList();
            Bundle[] bundles = item.getBundles();
            for (DCValue dCValue : bundles) {
                org.dspace.content.Bitstream[] itemBitstreams;
                for (org.dspace.content.Bitstream itemBitstream : itemBitstreams = dCValue.getBitstreams()) {
                    if (!AuthorizeManager.authorizeActionBoolean((Context)context, (org.dspace.content.DSpaceObject)itemBitstream, (int)0)) continue;
                    this.bitstreams.add(new Bitstream(itemBitstream, null));
                }
            }
        } else {
            this.addExpand("bitstreams");
        }
        if (!expandFields.contains("all")) {
            this.addExpand("all");
        }
    }

    public String getArchived() {
        return this.isArchived;
    }

    public void setArchived(String archived) {
        this.isArchived = archived;
    }

    public String getWithdrawn() {
        return this.isWithdrawn;
    }

    public void setWithdrawn(String withdrawn) {
        this.isWithdrawn = withdrawn;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(String lastModified) {
        this.lastModified = lastModified;
    }

    public Collection getParentCollection() {
        return this.parentCollection;
    }

    public List<Collection> getParentCollectionList() {
        return this.parentCollectionList;
    }

    public List<MetadataEntry> getMetadata() {
        return this.metadata;
    }

    public List<Bitstream> getBitstreams() {
        return this.bitstreams;
    }

    public List<Community> getParentCommunityList() {
        return this.parentCommunityList;
    }

    public void setParentCollection(Collection parentCollection) {
        this.parentCollection = parentCollection;
    }

    public void setParentCollectionList(List<Collection> parentCollectionList) {
        this.parentCollectionList = parentCollectionList;
    }

    public void setParentCommunityList(List<Community> parentCommunityList) {
        this.parentCommunityList = parentCommunityList;
    }

    @XmlElement(required=true)
    public void setMetadata(List<MetadataEntry> metadata) {
        this.metadata = metadata;
    }

    public void setBitstreams(List<Bitstream> bitstreams) {
        this.bitstreams = bitstreams;
    }
}

