/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.sql.SQLException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.Context;
import org.dspace.handle.HandleManager;
import org.dspace.rest.common.Collection;
import org.dspace.rest.common.Community;
import org.dspace.rest.common.DSpaceObject;
import org.dspace.rest.common.Item;

@Path(value="/handle")
public class HandleResource {
    private static Logger log = Logger.getLogger(HandleResource.class);
    private static Context context;

    @GET
    @Path(value="/{prefix}/{suffix}")
    @Produces(value={"application/json", "application/xml"})
    public DSpaceObject getObject(@PathParam(value="prefix") String prefix, @PathParam(value="suffix") String suffix, @QueryParam(value="expand") String expand) {
        try {
            org.dspace.content.DSpaceObject dso;
            if (context == null || !context.isValid()) {
                context = new Context();
                context.getDBConnection().setAutoCommit(true);
            }
            if ((dso = HandleManager.resolveToObject((Context)context, (String)(prefix + "/" + suffix))) == null) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            log.info((Object)("DSO Lookup by handle: [" + prefix + "] / [" + suffix + "] got result of: " + dso.getTypeText() + "_" + dso.getID()));
            if (AuthorizeManager.authorizeActionBoolean((Context)context, (org.dspace.content.DSpaceObject)dso, (int)0)) {
                switch (dso.getType()) {
                    case 4: {
                        return new Community((org.dspace.content.Community)dso, expand, context);
                    }
                    case 3: {
                        return new Collection((org.dspace.content.Collection)dso, expand, context, null, null);
                    }
                    case 2: {
                        return new Item((org.dspace.content.Item)dso, expand, context);
                    }
                }
                return new DSpaceObject(dso);
            }
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage());
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

