/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.rest.common.User;

/*
 * Exception performing whole class analysis ignored.
 */
public class TokenHolder {
    private static final Logger log = Logger.getLogger(TokenHolder.class);
    public static String TOKEN_HEADER = "rest-dspace-token";
    private static Map<String, String> tokens = new HashMap();
    private static Map<String, EPerson> persons = new HashMap();

    public static String login(User user) throws WebApplicationException {
        Context context = null;
        String token = null;
        try {
            context = new Context();
            EPerson dspaceUser = EPerson.findByEmail((Context)context, (String)user.getEmail());
            if (dspaceUser == null || !dspaceUser.checkPassword(user.getPassword())) {
                token = null;
            } else if (tokens.containsKey(user.getEmail())) {
                token = (String)tokens.get(user.getEmail());
            } else {
                token = TokenHolder.generateToken();
                persons.put(token, dspaceUser);
                tokens.put(user.getEmail(), token);
            }
            log.trace((Object)("User(" + user.getEmail() + ") has been logged."));
            context.complete();
        }
        catch (SQLException e) {
            context.abort();
            log.error((Object)("Could not read user from database. Message:" + e));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        catch (AuthorizeException e) {
            context.abort();
            log.error((Object)("Could not find user, AuthorizeException. Message:" + (Object)((Object)e)));
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
        finally {
            if (context != null && context.isValid()) {
                context.abort();
                log.error((Object)"Something get wrong. Aborting context in finally statement.");
                throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        return token;
    }

    public static EPerson getEPerson(String token) {
        return (EPerson)persons.get(token);
    }

    public static boolean logout(String token) {
        if (token == null || persons.get(token) == null) {
            return false;
        }
        String email = ((EPerson)persons.get(token)).getEmail();
        EPerson person = (EPerson)persons.remove(token);
        if (person == null) {
            return false;
        }
        tokens.remove(email);
        return true;
    }

    private static String generateToken() {
        return UUID.randomUUID().toString();
    }
}

