/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.rest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.browse.BrowseException;
import org.dspace.browse.IndexBrowse;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.InstallItem;
import org.dspace.content.ItemIterator;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.service.ItemService;
import org.dspace.eperson.EPerson;
import org.dspace.rest.Resource;
import org.dspace.rest.common.Collection;
import org.dspace.rest.common.Item;
import org.dspace.rest.common.MetadataEntry;
import org.dspace.rest.exceptions.ContextException;
import org.dspace.usage.UsageEvent;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/collections")
public class CollectionsResource
extends Resource {
    private static Logger log = Logger.getLogger(CollectionsResource.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{collection_id}")
    @Produces(value={"application/json", "application/xml"})
    public Collection getCollection(@PathParam(value="collection_id") Integer collectionId, @QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading collection(id=" + collectionId + ")."));
        org.dspace.core.Context context = null;
        Collection collection = null;
        try {
            context = CollectionsResource.createContext((EPerson)CollectionsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Collection dspaceCollection = this.findCollection(context, collectionId.intValue(), 0);
            this.writeStats((DSpaceObject)dspaceCollection, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            collection = new Collection(dspaceCollection, expand, context, limit, offset);
            context.complete();
        }
        catch (SQLException e) {
            CollectionsResource.processException((String)("Could not read collection(id=" + collectionId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CollectionsResource.processException((String)("Could not read collection(id=" + collectionId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)("Collection(id=" + collectionId + ") has been successfully read."));
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"application/json", "application/xml"})
    public Collection[] getCollections(@QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading all collections.(offset=" + offset + ",limit=" + limit + ")"));
        org.dspace.core.Context context = null;
        ArrayList<Collection> collections = new ArrayList<Collection>();
        try {
            org.dspace.content.Collection[] dspaceCollections;
            context = CollectionsResource.createContext((EPerson)CollectionsResource.getUser((HttpHeaders)headers));
            if (limit == null || limit < 0 || offset == null || offset < 0) {
                log.warn((Object)"Paging was badly set.");
                limit = 100;
                offset = 0;
            }
            for (org.dspace.content.Collection dspaceCollection : dspaceCollections = org.dspace.content.Collection.findAll((org.dspace.core.Context)context, (Integer)limit, (Integer)offset)) {
                if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)dspaceCollection, (int)0)) continue;
                Collection collection = new Collection(dspaceCollection, null, context, limit, offset);
                collections.add(collection);
                this.writeStats((DSpaceObject)dspaceCollection, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            }
            context.complete();
        }
        catch (SQLException e) {
            CollectionsResource.processException((String)("Something went wrong while reading collections from database. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CollectionsResource.processException((String)("Something went wrong while reading collections, ContextError. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)"All collections were successfully read.");
        return collections.toArray(new Collection[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/{collection_id}/items")
    @Produces(value={"application/json", "application/xml"})
    public Item[] getCollectionItems(@PathParam(value="collection_id") Integer collectionId, @QueryParam(value="expand") String expand, @QueryParam(value="limit") @DefaultValue(value="100") Integer limit, @QueryParam(value="offset") @DefaultValue(value="0") Integer offset, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Reading collection(id=" + collectionId + ") items."));
        org.dspace.core.Context context = null;
        ArrayList<Item> items = null;
        try {
            context = CollectionsResource.createContext((EPerson)CollectionsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Collection dspaceCollection = this.findCollection(context, collectionId.intValue(), 0);
            this.writeStats((DSpaceObject)dspaceCollection, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            items = new ArrayList<Item>();
            ItemIterator dspaceItems = dspaceCollection.getItems();
            for (int i = 0; dspaceItems.hasNext() && i < limit + offset; ++i) {
                org.dspace.content.Item dspaceItem;
                if (i < offset || !ItemService.isItemListedForUser((org.dspace.core.Context)context, (org.dspace.content.Item)(dspaceItem = dspaceItems.next()))) continue;
                items.add(new Item(dspaceItem, expand, context));
                this.writeStats((DSpaceObject)dspaceItem, UsageEvent.Action.VIEW, user_ip, user_agent, xforwardedfor, headers, request, context);
            }
            context.complete();
        }
        catch (SQLException e) {
            CollectionsResource.processException((String)("Could not read collection items, SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CollectionsResource.processException((String)("Could not read collection items, ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.trace((Object)("All items in collection(id=" + collectionId + ") were successfully read."));
        return items.toArray(new Item[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/{collection_id}/items")
    @Consumes(value={"application/json", "application/xml"})
    public Item addCollectionItem(@PathParam(value="collection_id") Integer collectionId, Item item, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Create item in collection(id=" + collectionId + ")."));
        org.dspace.core.Context context = null;
        Item returnItem = null;
        try {
            context = CollectionsResource.createContext((EPerson)CollectionsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Collection dspaceCollection = this.findCollection(context, collectionId.intValue(), 1);
            this.writeStats((DSpaceObject)dspaceCollection, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            log.trace((Object)("Creating item in collection(id=" + collectionId + ")."));
            WorkspaceItem workspaceItem = WorkspaceItem.create((org.dspace.core.Context)context, (org.dspace.content.Collection)dspaceCollection, (boolean)false);
            org.dspace.content.Item dspaceItem = workspaceItem.getItem();
            log.trace((Object)("Adding metadata to item(id=" + dspaceItem.getID() + ")."));
            if (item.getMetadata() != null) {
                for (MetadataEntry entry : item.getMetadata()) {
                    String[] data = this.mySplit(entry.getKey());
                    dspaceItem.addMetadata(data[0], data[1], data[2], entry.getLanguage(), entry.getValue());
                }
            }
            workspaceItem.update();
            IndexBrowse browse = new IndexBrowse();
            browse.indexItem(dspaceItem);
            log.trace((Object)("Installing item to collection(id=" + collectionId + ")."));
            dspaceItem = InstallItem.installItem((org.dspace.core.Context)context, (InProgressSubmission)workspaceItem);
            returnItem = new Item(dspaceItem, "", context);
            context.complete();
        }
        catch (SQLException e) {
            CollectionsResource.processException((String)("Could not add item into collection(id=" + collectionId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CollectionsResource.processException((String)("Could not add item into collection(id=" + collectionId + "), AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            CollectionsResource.processException((String)("Could not add item into collection(id=" + collectionId + "), IOException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (BrowseException e) {
            CollectionsResource.processException((String)("Could not add item into browse index, BrowseException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CollectionsResource.processException((String)("Could not add item into collection(id=" + collectionId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Item successfully created in collection(id=" + collectionId + "). Item handle=" + returnItem.getHandle()));
        return returnItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/{collection_id}")
    @Consumes(value={"application/json", "application/xml"})
    public Response updateCollection(@PathParam(value="collection_id") Integer collectionId, Collection collection, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Updating collection(id=" + collectionId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = CollectionsResource.createContext((EPerson)CollectionsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Collection dspaceCollection = this.findCollection(context, collectionId.intValue(), 1);
            this.writeStats((DSpaceObject)dspaceCollection, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            dspaceCollection.setMetadata("name", collection.getName());
            dspaceCollection.setLicense(collection.getLicense());
            dspaceCollection.setMetadata("copyright_text", collection.getCopyrightText());
            dspaceCollection.setMetadata("introductory_text", collection.getIntroductoryText());
            dspaceCollection.setMetadata("short_description", collection.getShortDescription());
            dspaceCollection.setMetadata("side_bar_text", collection.getSidebarText());
            dspaceCollection.update();
            context.complete();
        }
        catch (ContextException e) {
            CollectionsResource.processException((String)("Could not update collection(id=" + collectionId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (SQLException e) {
            CollectionsResource.processException((String)("Could not update collection(id=" + collectionId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CollectionsResource.processException((String)("Could not update collection(id=" + collectionId + "), AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Collection(id=" + collectionId + ") successfully updated."));
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{collection_id}")
    @Consumes(value={"application/json", "application/xml"})
    public Response deleteCollection(@PathParam(value="collection_id") Integer collectionId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Delete collection(id=" + collectionId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = CollectionsResource.createContext((EPerson)CollectionsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Collection dspaceCollection = this.findCollection(context, collectionId.intValue(), 2);
            this.writeStats((DSpaceObject)dspaceCollection, UsageEvent.Action.REMOVE, user_ip, user_agent, xforwardedfor, headers, request, context);
            Community community = (Community)dspaceCollection.getParentObject();
            community.removeCollection(dspaceCollection);
            context.complete();
        }
        catch (ContextException e) {
            CollectionsResource.processException((String)("Could not delete collection(id=" + collectionId + "), ContextExcpetion. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (SQLException e) {
            CollectionsResource.processException((String)("Could not delete collection(id=" + collectionId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CollectionsResource.processException((String)("Could not delete collection(id=" + collectionId + "), AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            CollectionsResource.processException((String)("Could not delete collection(id=" + collectionId + "), IOException. Message: " + e), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Collection(id=" + collectionId + ") was successfully deleted."));
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="/{collection_id}/items/{item_id}")
    @Consumes(value={"application/json", "application/xml"})
    public Response deleteCollectionItem(@PathParam(value="collection_id") Integer collectionId, @PathParam(value="item_id") Integer itemId, @QueryParam(value="userIP") String user_ip, @QueryParam(value="userAgent") String user_agent, @QueryParam(value="xforwardedfor") String xforwardedfor, @Context HttpHeaders headers, @Context HttpServletRequest request) throws WebApplicationException {
        log.info((Object)("Delete item(id=" + itemId + ") in collection(id=" + collectionId + ")."));
        org.dspace.core.Context context = null;
        try {
            context = CollectionsResource.createContext((EPerson)CollectionsResource.getUser((HttpHeaders)headers));
            org.dspace.content.Collection dspaceCollection = this.findCollection(context, collectionId.intValue(), 1);
            org.dspace.content.Item item = null;
            ItemIterator dspaceItems = dspaceCollection.getItems();
            while (dspaceItems.hasNext()) {
                org.dspace.content.Item dspaceItem = dspaceItems.next();
                if (dspaceItem.getID() != itemId.intValue()) continue;
                item = dspaceItem;
            }
            if (item == null) {
                context.abort();
                log.warn((Object)("Item(id=" + itemId + ") was not found!"));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, item, (int)4)) {
                context.abort();
                if (context.getCurrentUser() != null) {
                    log.error((Object)("User(" + context.getCurrentUser().getEmail() + ") has not permission to delete item!"));
                } else {
                    log.error((Object)"User(anonymous) has not permission to delete item!");
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
            this.writeStats((DSpaceObject)dspaceCollection, UsageEvent.Action.UPDATE, user_ip, user_agent, xforwardedfor, headers, request, context);
            this.writeStats((DSpaceObject)item, UsageEvent.Action.REMOVE, user_ip, user_agent, xforwardedfor, headers, request, context);
            dspaceCollection.removeItem(item);
            context.complete();
        }
        catch (ContextException e) {
            CollectionsResource.processException((String)("Could not delete item(id=" + itemId + ") in collection(id=" + collectionId + "), ContextException. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        catch (SQLException e) {
            CollectionsResource.processException((String)("Could not delete item(id=" + itemId + ") in collection(id=" + collectionId + "), SQLException. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (AuthorizeException e) {
            CollectionsResource.processException((String)("Could not delete item(id=" + itemId + ") in collection(id=" + collectionId + "), AuthorizeException. Message: " + (Object)((Object)e)), (org.dspace.core.Context)context);
        }
        catch (IOException e) {
            CollectionsResource.processException((String)("Could not delete item(id=" + itemId + ") in collection(id=" + collectionId + "), IOException. Message: " + e), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        log.info((Object)("Item(id=" + itemId + ") in collection(id=" + collectionId + ") was successfully deleted."));
        return Response.ok().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/find-collection")
    @Consumes(value={"application/json", "application/xml"})
    @Produces(value={"application/json", "application/xml"})
    public Collection findCollectionByName(String name, @Context HttpHeaders headers) throws WebApplicationException {
        log.info((Object)("Searching for first collection with name=" + name + "."));
        org.dspace.core.Context context = null;
        Collection collection = null;
        try {
            org.dspace.content.Collection[] dspaceCollections;
            context = CollectionsResource.createContext((EPerson)CollectionsResource.getUser((HttpHeaders)headers));
            for (org.dspace.content.Collection dspaceCollection : dspaceCollections = org.dspace.content.Collection.findAll((org.dspace.core.Context)context)) {
                if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)dspaceCollection, (int)0) || !dspaceCollection.getName().equals(name)) continue;
                collection = new Collection(dspaceCollection, "", context, Integer.valueOf(100), Integer.valueOf(0));
                break;
            }
            context.complete();
        }
        catch (SQLException e) {
            CollectionsResource.processException((String)("Something went wrong while searching for collection(name=" + name + ") from database. Message: " + e), (org.dspace.core.Context)context);
        }
        catch (ContextException e) {
            CollectionsResource.processException((String)("Something went wrong while searching for collection(name=" + name + "), ContextError. Message: " + e.getMessage()), (org.dspace.core.Context)context);
        }
        finally {
            this.processFinally(context);
        }
        if (collection == null) {
            log.info((Object)"Collection was not found.");
        } else {
            log.info((Object)("Collection was found with id(" + collection.getId() + ")."));
        }
        return collection;
    }

    private org.dspace.content.Collection findCollection(org.dspace.core.Context context, int id, int action) throws WebApplicationException {
        org.dspace.content.Collection collection = null;
        try {
            collection = org.dspace.content.Collection.find((org.dspace.core.Context)context, (int)id);
            if (collection == null) {
                context.abort();
                log.warn((Object)("Collection(id=" + id + ") was not found!"));
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
            if (!AuthorizeManager.authorizeActionBoolean((org.dspace.core.Context)context, (DSpaceObject)collection, (int)action)) {
                context.abort();
                if (context.getCurrentUser() != null) {
                    log.error((Object)("User(" + context.getCurrentUser().getEmail() + ") has not permission to " + this.getActionString(action) + " collection!"));
                } else {
                    log.error((Object)("User(anonymous) has not permission to " + this.getActionString(action) + " collection!"));
                }
                throw new WebApplicationException(Response.Status.UNAUTHORIZED);
            }
        }
        catch (SQLException e) {
            CollectionsResource.processException((String)("Something get wrong while finding collection(id=" + id + "). SQLException, Message: " + e), (org.dspace.core.Context)context);
        }
        return collection;
    }
}

